/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine.runtime.xpath;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathFunctionResolver;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.xpath.XPathEvaluator;
import net.sf.saxon.xpath.XPathFactoryImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.wso2.carbon.humantask.core.engine.runtime.api.EvaluationContext;
import org.wso2.carbon.humantask.core.engine.runtime.api.ExpressionLanguageRuntime;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskRuntimeException;
import org.wso2.carbon.humantask.core.engine.runtime.xpath.JaxpFunctionResolver;
import org.wso2.carbon.humantask.core.engine.runtime.xpath.XPathProcessingException;
import org.wso2.carbon.humantask.core.utils.DOMUtils;
import org.wso2.carbon.humantask.core.utils.Duration;
import org.wso2.carbon.humantask.core.utils.ISO8601DateParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathExpressionRuntime
implements ExpressionLanguageRuntime {
    private static final Log log = LogFactory.getLog(ExpressionLanguageRuntime.class);
    public static final String ns = "urn:wsht:sublang:xpath2.0";
    private static final String JAVAX_XML_XPATH_XPATH_FACTORY = "javax.xml.xpath.XPathFactory:";
    private static final String NET_SF_SAXON_XPATH_XPATH_FACTORY_IMPL = "net.sf.saxon.xpath.XPathFactoryImpl";

    @Override
    public List evaluate(String exp, EvaluationContext evalCtx) {
        List<Object> result;
        Object someRes;
        try {
            someRes = this.evaluate(exp, evalCtx, XPathConstants.NODESET);
        }
        catch (Exception e) {
            someRes = this.evaluate(exp, evalCtx, XPathConstants.STRING);
        }
        if (someRes instanceof List) {
            result = (ArrayList)someRes;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returned list of size " + result.size()));
            }
            if (result.size() == 1 && !(result.get(0) instanceof Node)) {
                Object simpleType = result.get(0);
                String textVal = simpleType instanceof Date ? ISO8601DateParser.format((Date)simpleType) : (simpleType instanceof DurationValue ? ((DurationValue)simpleType).getStringValue() : simpleType.toString());
                Document document = DOMUtils.newDocument();
                Element wrapper = document.createElement("wrapper");
                Text text = document.createTextNode(textVal);
                wrapper.appendChild(text);
                document.appendChild(wrapper);
                result = Collections.singletonList(text);
            }
        } else if (someRes instanceof NodeList) {
            NodeList retVal = (NodeList)someRes;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returned node list of size " + retVal.getLength()));
            }
            result = new ArrayList(retVal.getLength());
            for (int m = 0; m < retVal.getLength(); ++m) {
                Node val = retVal.item(m);
                if (val.getNodeType() == 9) {
                    val = ((Document)val).getDocumentElement();
                }
                result.add(val);
            }
        } else if (someRes instanceof String) {
            Document document = DOMUtils.newDocument();
            Element wrapper = document.createElement("wrapper");
            Text text = document.createTextNode((String)someRes);
            wrapper.appendChild(text);
            document.appendChild(wrapper);
            result = Collections.singletonList(text);
        } else {
            result = null;
        }
        return result;
    }

    private Object evaluate(String exp, EvaluationContext evalCtx, QName type) {
        try {
            XPathFactoryImpl xpf = new XPathFactoryImpl();
            JaxpFunctionResolver funcResolve = new JaxpFunctionResolver(evalCtx);
            xpf.setXPathFunctionResolver(funcResolve);
            XPathEvaluator xpe = (XPathEvaluator)xpf.newXPath();
            xpe.setXPathFunctionResolver((XPathFunctionResolver)funcResolve);
            xpe.setBackwardsCompatible(true);
            xpe.setNamespaceContext(evalCtx.getNameSpaceContextOfTask());
            XPathExpression xpathExpression = xpe.compile(exp);
            Node contextNode = evalCtx.getRootNode() == null ? DOMUtils.newDocument() : evalCtx.getRootNode();
            Object evalResult = xpathExpression.evaluate(contextNode, type);
            if (evalResult != null && log.isDebugEnabled()) {
                log.debug((Object)("Expression " + exp + " generate result " + evalResult + " - type=" + evalResult.getClass().getName()));
                if (evalCtx.getRootNode() != null) {
                    log.debug((Object)("Was using context node " + DOMUtils.domToString(evalCtx.getRootNode())));
                }
            }
            return evalResult;
        }
        catch (XPathFactoryConfigurationException e) {
            log.error((Object)"Exception occurred while creating XPathFactory.", (Throwable)e);
            throw new XPathProcessingException("Exception occurred while creating XPathFactory.", e);
        }
        catch (XPathExpressionException e) {
            String msg = "Error evaluating XPath expression: " + exp;
            log.error((Object)msg, (Throwable)e);
            throw new XPathProcessingException(msg, e);
        }
        catch (ParserConfigurationException e) {
            String msg = "XML Parsing error.";
            log.error((Object)msg, (Throwable)e);
            throw new XPathProcessingException(msg, e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new XPathProcessingException(e.getMessage(), e);
        }
    }

    @Override
    public String evaluateAsString(String exp, EvaluationContext evalCtx) {
        return (String)this.evaluate(exp, evalCtx, XPathConstants.STRING);
    }

    @Override
    public Calendar evaluateAsDate(String exp, EvaluationContext evalCtx) {
        List<Node> literal = XPathExpressionRuntime.toList(this.evaluate(exp, evalCtx));
        if (literal.size() == 0) {
            throw new IllegalArgumentException("No results for expression:" + exp);
        }
        if (literal.size() > 1) {
            throw new IllegalArgumentException("Multiple results for expression:" + exp);
        }
        Object date = literal.get(0);
        if (date instanceof Calendar) {
            return (Calendar)date;
        }
        if (date instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)date);
            return cal;
        }
        if (date instanceof Element) {
            date = ((Element)date).getTextContent();
        }
        if (date instanceof Text) {
            date = ((Text)date).getTextContent();
        }
        try {
            return ISO8601DateParser.parseCal(date.toString());
        }
        catch (Exception ex) {
            String errmsg = "Invalid date format: " + literal;
            log.error((Object)errmsg, (Throwable)ex);
            throw new IllegalArgumentException(errmsg, ex);
        }
    }

    @Override
    public Duration evaluateAsDuration(String exp, EvaluationContext evalCtx) {
        String literal = exp;
        if (!Duration.isValidExpression(exp)) {
            literal = this.evaluateAsString(exp, evalCtx);
        }
        try {
            return new Duration(literal);
        }
        catch (Exception ex) {
            String errmsg = "Invalid duration: " + exp;
            log.error((Object)errmsg, (Throwable)ex);
            throw new IllegalArgumentException(errmsg, ex);
        }
    }

    @Override
    public boolean evaluateAsBoolean(String exp, EvaluationContext evalCtx) {
        return (Boolean)this.evaluate(exp, evalCtx, XPathConstants.BOOLEAN);
    }

    @Override
    public Number evaluateAsNumber(String exp, EvaluationContext evalCtx) {
        return (Number)this.evaluate(exp, evalCtx, XPathConstants.NUMBER);
    }

    @Override
    public Node evaluateAsPart(String exp, String partName, EvaluationContext evalCtx) {
        Document document = DOMUtils.newDocument();
        Element node = document.createElement(partName);
        List nodeList = this.evaluate(exp, evalCtx);
        if (nodeList.size() == 0) {
            String errMsg = "0 nodes selected for the expression: " + exp;
            log.error((Object)errMsg);
            throw new HumanTaskRuntimeException(errMsg);
        }
        if (nodeList.size() > 1) {
            String errMsg = "More than one nodes are selected for the expression: " + exp;
            log.error((Object)errMsg);
            throw new HumanTaskRuntimeException(errMsg);
        }
        Node partNode = (Node)nodeList.get(0);
        this.replaceElement(node, (Element)partNode);
        return node;
    }

    private Element replaceElement(Element lval, Element src) {
        Document doc = lval.getOwnerDocument();
        NodeList nl = src.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            lval.appendChild(doc.importNode(nl.item(i), true));
        }
        NamedNodeMap attrs = src.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            String prefix;
            String attrValNs;
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().startsWith("xmlns")) continue;
            lval.setAttributeNodeNS((Attr)doc.importNode(attrs.item(i), true));
            int colonIdx = attr.getValue().indexOf(":");
            if (colonIdx <= 0 || (attrValNs = src.lookupPrefix(prefix = attr.getValue().substring(0, colonIdx))) == null) continue;
            lval.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, attrValNs);
        }
        return lval;
    }

    public static List<Node> toList(Object nl) {
        if (nl == null) {
            return null;
        }
        if (nl instanceof List) {
            return (List)nl;
        }
        NodeList cnl = (NodeList)nl;
        LinkedList<Node> ll = new LinkedList<Node>();
        for (int m = 0; m < cnl.getLength(); ++m) {
            ll.add(cnl.item(m));
        }
        return ll;
    }
}

