/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.carbon.humantask.TArgument;
import org.wso2.carbon.humantask.TDeadline;
import org.wso2.carbon.humantask.TDeadlines;
import org.wso2.carbon.humantask.TFrom;
import org.wso2.carbon.humantask.TPriorityExpr;
import org.wso2.carbon.humantask.core.api.event.TaskEventInfo;
import org.wso2.carbon.humantask.core.api.event.TaskInfo;
import org.wso2.carbon.humantask.core.api.scheduler.Scheduler;
import org.wso2.carbon.humantask.core.dao.DeadlineDAO;
import org.wso2.carbon.humantask.core.dao.EventDAO;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.MessageDAO;
import org.wso2.carbon.humantask.core.dao.OrganizationalEntityDAO;
import org.wso2.carbon.humantask.core.dao.PresentationDescriptionDAO;
import org.wso2.carbon.humantask.core.dao.PresentationNameDAO;
import org.wso2.carbon.humantask.core.dao.PresentationParameterDAO;
import org.wso2.carbon.humantask.core.dao.PresentationSubjectDAO;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.dao.TaskEventType;
import org.wso2.carbon.humantask.core.dao.TaskStatus;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Deadline;
import org.wso2.carbon.humantask.core.engine.HumanTaskException;
import org.wso2.carbon.humantask.core.engine.PeopleQueryEvaluator;
import org.wso2.carbon.humantask.core.engine.runtime.api.EvaluationContext;
import org.wso2.carbon.humantask.core.engine.runtime.api.ExpressionLanguageRuntime;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskRuntimeException;
import org.wso2.carbon.humantask.core.internal.HumanTaskServiceComponent;
import org.wso2.carbon.humantask.core.store.HumanTaskBaseConfiguration;
import org.wso2.carbon.humantask.core.store.HumanTaskStore;
import org.wso2.carbon.humantask.core.store.TaskConfiguration;
import org.wso2.carbon.humantask.core.utils.Duration;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommonTaskUtil {
    private static final Log log = LogFactory.getLog(CommonTaskUtil.class);

    private CommonTaskUtil() {
    }

    public static Boolean hasSubTasks(TaskDAO task) {
        Boolean hasSubTasks = false;
        if (task.getSubTasks() != null && task.getSubTasks().size() > 0) {
            hasSubTasks = true;
        }
        return hasSubTasks;
    }

    public static Boolean hasAttachments(TaskDAO task) {
        Boolean hasAttachments = false;
        if (task.getAttachments() != null && task.getAttachments().size() > 0) {
            hasAttachments = true;
        }
        return hasAttachments;
    }

    public static Boolean hasComments(TaskDAO task) {
        Boolean hasComments = false;
        if (task.getComments() != null && task.getComments().size() > 0) {
            hasComments = true;
        }
        return hasComments;
    }

    public static Boolean hasOutput(TaskDAO task) {
        Boolean hasOutput = false;
        if (task.getOutputMessage() != null) {
            hasOutput = true;
        }
        return hasOutput;
    }

    public static Boolean hasFault(TaskDAO task) {
        Boolean hasFailure = false;
        if (task.getFailureMessage() != null) {
            hasFailure = true;
        }
        return hasFailure;
    }

    public static HumanTaskBaseConfiguration getTaskConfiguration(TaskDAO task) {
        HumanTaskStore taskStore = HumanTaskServiceComponent.getHumanTaskServer().getTaskStoreManager().getHumanTaskStore(task.getTenantId());
        return taskStore.getTaskConfiguration(QName.valueOf(task.getName()));
    }

    public static boolean hasPotentialOwners(TaskDAO task) {
        PeopleQueryEvaluator pqe = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getPeopleQueryEvaluator();
        boolean hasPotentialOwners = false;
        for (GenericHumanRoleDAO humanRoleDAO : task.getHumanRoles()) {
            if (!GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS.equals((Object)humanRoleDAO.getType()) || humanRoleDAO.getOrgEntities() == null || humanRoleDAO.getOrgEntities().size() <= 0) continue;
            try {
                pqe.checkOrgEntitiesExist(humanRoleDAO.getOrgEntities());
                hasPotentialOwners = true;
            }
            catch (HumanTaskRuntimeException ex) {
                hasPotentialOwners = false;
            }
        }
        return hasPotentialOwners;
    }

    public static OrganizationalEntityDAO getUserEntityForRole(TaskDAO task, GenericHumanRoleDAO.GenericHumanRoleType type) {
        OrganizationalEntityDAO matchingUser = null;
        for (GenericHumanRoleDAO humanRoleDAO : task.getHumanRoles()) {
            if (!type.equals((Object)humanRoleDAO.getType()) || humanRoleDAO.getOrgEntities() == null || humanRoleDAO.getOrgEntities().size() != 1) continue;
            matchingUser = humanRoleDAO.getOrgEntities().get(0);
            break;
        }
        return matchingUser;
    }

    public static List<OrganizationalEntityDAO> getOrgEntitiesForRole(TaskDAO task, GenericHumanRoleDAO.GenericHumanRoleType type) {
        ArrayList<OrganizationalEntityDAO> matchingOrgEntities = new ArrayList<OrganizationalEntityDAO>();
        if (task != null && type != null) {
            for (GenericHumanRoleDAO humanRoleDAO : task.getHumanRoles()) {
                if (!humanRoleDAO.getType().equals((Object)type) || humanRoleDAO.getOrgEntities() == null) continue;
                matchingOrgEntities.addAll(humanRoleDAO.getOrgEntities());
                break;
            }
        }
        return matchingOrgEntities;
    }

    public static PresentationNameDAO getDefaultPresentationName(TaskDAO task) {
        PresentationNameDAO defaultPresentationName = null;
        if (task.getPresentationNames() != null && task.getPresentationNames().size() > 0) {
            if (task.getPresentationNames().size() == 1) {
                defaultPresentationName = task.getPresentationNames().get(0);
            } else {
                for (PresentationNameDAO presentationName : task.getPresentationNames()) {
                    if (!StringUtils.isNotEmpty((String)presentationName.getXmlLang()) || !presentationName.getXmlLang().toLowerCase().contains("en")) continue;
                    defaultPresentationName = presentationName;
                    break;
                }
            }
            if (defaultPresentationName == null) {
                task.getPresentationNames().get(0);
            }
        }
        return defaultPresentationName;
    }

    public static PresentationSubjectDAO getDefaultPresentationSubject(TaskDAO task) {
        PresentationSubjectDAO defaultPresentationSubject = null;
        if (task.getPresentationSubjects() != null && task.getPresentationSubjects().size() > 0) {
            if (task.getPresentationSubjects().size() == 1) {
                defaultPresentationSubject = task.getPresentationSubjects().get(0);
            } else {
                for (PresentationSubjectDAO subject : task.getPresentationSubjects()) {
                    if (!StringUtils.isNotEmpty((String)subject.getXmlLang()) || !subject.getXmlLang().toLowerCase().contains("en")) continue;
                    defaultPresentationSubject = subject;
                    break;
                }
            }
            if (defaultPresentationSubject == null) {
                task.getPresentationSubjects().get(0);
            }
        }
        return defaultPresentationSubject;
    }

    public static PresentationDescriptionDAO getDefaultPresentationDescription(TaskDAO task) {
        PresentationDescriptionDAO presentationDescriptionDAO = null;
        if (task.getPresentationDescriptions() != null && task.getPresentationDescriptions().size() > 0) {
            if (task.getPresentationDescriptions().size() == 1) {
                presentationDescriptionDAO = task.getPresentationDescriptions().get(0);
            } else {
                for (PresentationDescriptionDAO description : task.getPresentationDescriptions()) {
                    if (!StringUtils.isNotEmpty((String)description.getXmlLang()) || !description.getXmlLang().toLowerCase().contains("en")) continue;
                    presentationDescriptionDAO = description;
                    break;
                }
            }
            if (presentationDescriptionDAO == null) {
                task.getPresentationDescriptions().get(0);
            }
        }
        return presentationDescriptionDAO;
    }

    public static void nominate(TaskDAO task, PeopleQueryEvaluator pqe) {
        if (task.getActivationTime() == null || !task.getActivationTime().after(new Date())) {
            for (GenericHumanRoleDAO ghr : task.getHumanRoles()) {
                if (!GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS.equals((Object)ghr.getType())) continue;
                for (OrganizationalEntityDAO orgEntity : ghr.getOrgEntities()) {
                    if (!OrganizationalEntityDAO.OrganizationalEntityType.GROUP.equals((Object)orgEntity.getOrgEntityType())) continue;
                    String roleName = orgEntity.getName();
                    if (pqe.isExistingRole(roleName) && pqe.getUserNameListForRole(roleName).size() == 1) {
                        GenericHumanRoleDAO actualOwnerRole = pqe.createGHRForRoleName(roleName, GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
                        actualOwnerRole.setTask(task);
                        task.addHumanRole(actualOwnerRole);
                        task.setStatus(TaskStatus.RESERVED);
                        continue;
                    }
                    if (!pqe.isExistingRole(roleName)) continue;
                    task.setStatus(TaskStatus.READY);
                }
            }
        }
    }

    public static int calculateTaskPriority(HumanTaskBaseConfiguration taskConfig, EvaluationContext evalCtx) {
        TPriorityExpr priorityDef = taskConfig.getPriorityExpression();
        int taskPriorityInt = 5;
        if (priorityDef != null) {
            String expLang = priorityDef.getExpressionLanguage() == null ? taskConfig.getExpressionLanguage() : priorityDef.getExpressionLanguage();
            ExpressionLanguageRuntime expLangRuntime = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getExpressionLanguageRuntime(expLang);
            Number priority = expLangRuntime.evaluateAsNumber(priorityDef.newCursor().getTextValue().trim(), evalCtx);
            if (priority.intValue() > 10 || priority.intValue() < 1) {
                log.warn((Object)String.format("Ignoring the task priority value :[%d] The task priority has to be with 1 and 10. ", priority.intValue()));
            } else {
                taskPriorityInt = priority.intValue();
            }
        }
        return taskPriorityInt;
    }

    public static String calculateRole(EvaluationContext evalCtx, String roleExpression) {
        String role = null;
        String expLang = "urn:wsht:sublang:xpath2.0";
        ExpressionLanguageRuntime expLangRuntime = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getExpressionLanguageRuntime(expLang);
        role = expLangRuntime.evaluateAsString(roleExpression, evalCtx);
        if (role == null) {
            log.warn((Object)String.format("Role cannot be  null", new Object[0]));
        }
        return role;
    }

    public static List<OrganizationalEntityDAO> getOrganizationalEntities(PeopleQueryEvaluator peopleQueryEvaluator, TFrom tFrom, EvaluationContext evaluationContext) throws HumanTaskException {
        String roleName = null;
        for (TArgument tArgument : tFrom.getArgumentArray()) {
            if (!"role".equals(tArgument.getName())) continue;
            roleName = tArgument.newCursor().getTextValue();
            if (roleName == null || !roleName.contains("htd:getInput")) break;
            roleName = CommonTaskUtil.calculateRole(evaluationContext, roleName);
            break;
        }
        if (roleName == null || StringUtils.isEmpty(roleName)) {
            throw new HumanTaskRuntimeException("The role name cannot be empty: " + tFrom.toString());
        }
        roleName = roleName.trim();
        ArrayList<OrganizationalEntityDAO> orgEnties = new ArrayList<OrganizationalEntityDAO>();
        orgEnties.add(peopleQueryEvaluator.createGroupOrgEntityForRole(roleName));
        return orgEnties;
    }

    public static String replaceUsingPresentationParams(List<PresentationParameterDAO> presentationParameters, String expression) {
        String result = expression.replaceAll("\\{\\{", "{");
        result = result.replaceAll("\\}\\}", "}");
        for (PresentationParameterDAO param : presentationParameters) {
            result = result.replaceAll("\\{\\$" + param.getName() + "\\}", param.getValue());
        }
        for (PresentationParameterDAO param : presentationParameters) {
            result = result.replaceAll("\\$" + param.getName() + "\\$", param.getValue());
        }
        return result;
    }

    public static void setTaskToMessage(TaskDAO task) {
        task.getInputMessage().setTask(task);
    }

    public static Element getMessagePart(MessageDAO inputMessage, String partName) {
        Element node = inputMessage.getBodyData();
        if (node.hasChildNodes()) {
            Node matchingElement = null;
            if (node.getElementsByTagName(partName).getLength() > 0) {
                matchingElement = (Element)node.getElementsByTagName(partName).item(0);
            }
            if (matchingElement != null && matchingElement.getFirstChild() != null) {
                return (Element)matchingElement.getFirstChild();
            }
            return matchingElement;
        }
        throw new HumanTaskRuntimeException("The input message does not have any child elements");
    }

    public static void processDeadlines(TaskDAO task, TaskConfiguration taskConf, EvaluationContext evalContext) {
        TDeadlines deadlines = taskConf.getDeadlines();
        if (deadlines != null) {
            TDeadline[] startDeadlines = deadlines.getStartDeadlineArray();
            TDeadline[] completionDeadlines = deadlines.getCompletionDeadlineArray();
            for (TDeadline deadline : startDeadlines) {
                DeadlineDAO startDeadline = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getDaoConnectionFactory().getConnection().createDeadline();
                startDeadline.setStatus(TaskStatus.IN_PROGRESS);
                startDeadline.setName(deadline.getName() == null ? "startDeadline" : deadline.getName());
                startDeadline.setTask(task);
                startDeadline.setDeadlineDate(CommonTaskUtil.calculateDeadline(task, deadline, taskConf, evalContext).getTime());
                task.addDeadline(startDeadline);
            }
            for (TDeadline deadline : completionDeadlines) {
                Deadline completionDeadline = new Deadline();
                completionDeadline.setStatus(TaskStatus.COMPLETED);
                completionDeadline.setName(deadline.getName() == null ? "completionDeadline" : deadline.getName());
                completionDeadline.setTask(task);
                completionDeadline.setDeadlineDate(CommonTaskUtil.calculateDeadline(task, deadline, taskConf, evalContext).getTime());
                task.addDeadline(completionDeadline);
            }
        }
    }

    private static Calendar calculateDeadline(TaskDAO taskDAO, TDeadline deadline, TaskConfiguration taskConf, EvaluationContext evalCtx) {
        if (deadline.getUntil() != null) {
            String expLang = deadline.getUntil().getExpressionLanguage() == null ? taskConf.getExpressionLanguage() : deadline.getUntil().getExpressionLanguage();
            return HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getExpressionLanguageRuntime(expLang).evaluateAsDate(deadline.getUntil().newCursor().getTextValue(), evalCtx);
        }
        if (deadline.getFor() != null) {
            String expLang = deadline.getFor().getExpressionLanguage() == null ? taskConf.getExpressionLanguage() : deadline.getFor().getExpressionLanguage();
            Duration duration = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getExpressionLanguageRuntime(expLang).evaluateAsDuration(deadline.getFor().newCursor().getTextValue(), evalCtx);
            Calendar durationCalendar = Calendar.getInstance();
            durationCalendar.setTime(taskDAO.getActivationTime());
            duration.addTo(durationCalendar);
            return durationCalendar;
        }
        return null;
    }

    public static void scheduleDeadlines(TaskDAO task) {
        List<DeadlineDAO> deadlines = task.getDeadlines();
        for (DeadlineDAO deadline : deadlines) {
            HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().scheduleJob(System.currentTimeMillis(), deadline.getDeadlineDate().getTime(), Scheduler.JobType.TIMER_DEADLINE, null, task.getId(), deadline.getName());
        }
    }

    public static String getPotentialOwnerRoleName(TaskDAO task) {
        String roleName = null;
        block0: for (GenericHumanRoleDAO role : task.getHumanRoles()) {
            if (!GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS.equals((Object)role.getType())) continue;
            for (OrganizationalEntityDAO orgEntity : role.getOrgEntities()) {
                if (!OrganizationalEntityDAO.OrganizationalEntityType.GROUP.equals((Object)orgEntity.getOrgEntityType())) continue;
                roleName = orgEntity.getName();
                break block0;
            }
        }
        return roleName;
    }

    public static List<String> getAssignableUserNameList(TaskDAO task, boolean excludeActualOwner) {
        String potentialOwnerRole = CommonTaskUtil.getPotentialOwnerRoleName(task);
        RegistryService registryService = HumanTaskServiceComponent.getRegistryService();
        try {
            UserRealm userRealm = registryService.getUserRealm(task.getTenantId().intValue());
            String[] assignableUsersArray = userRealm.getUserStoreManager().getUserListOfRole(potentialOwnerRole);
            ArrayList<String> allPotentialOwners = new ArrayList<String>(Arrays.asList(assignableUsersArray));
            OrganizationalEntityDAO actualOwner = CommonTaskUtil.getActualOwner(task);
            if (excludeActualOwner && actualOwner != null) {
                allPotentialOwners.remove(actualOwner.getName());
            }
            return allPotentialOwners;
        }
        catch (RegistryException e) {
            throw new HumanTaskRuntimeException("Cannot locate user realm for tenant id " + task.getTenantId());
        }
        catch (UserStoreException e) {
            throw new HumanTaskRuntimeException("Error retrieving the UserStoreManager " + task.getTenantId(), e);
        }
    }

    public static OrganizationalEntityDAO getActualOwner(TaskDAO task) {
        OrganizationalEntityDAO actualOwnerOrgEntity = null;
        List<OrganizationalEntityDAO> actualOwner = CommonTaskUtil.getOrgEntitiesForRole(task, GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        if (actualOwner != null && actualOwner.size() == 1) {
            actualOwnerOrgEntity = actualOwner.get(0);
        }
        return actualOwnerOrgEntity;
    }

    public static TaskEventInfo createNewTaskEvent(TaskDAO task) {
        TaskEventInfo createTaskEvent = new TaskEventInfo();
        createTaskEvent.setEventType(TaskEventType.CREATE);
        createTaskEvent.setTimestamp(task.getCreatedOn());
        createTaskEvent.setTaskInfo(CommonTaskUtil.populateTaskInfo(task));
        return createTaskEvent;
    }

    public static TaskInfo populateTaskInfo(TaskDAO taskDAO) {
        TaskInfo taskInfo = new TaskInfo();
        taskInfo.setId(taskDAO.getId());
        taskInfo.setCreatedDate(taskDAO.getCreatedOn());
        taskInfo.setName(taskDAO.getName());
        if (CommonTaskUtil.getDefaultPresentationDescription(taskDAO) != null) {
            taskInfo.setDescription(CommonTaskUtil.getDefaultPresentationDescription(taskDAO).getValue());
        }
        if (CommonTaskUtil.getActualOwner(taskDAO) != null) {
            taskInfo.setOwner(CommonTaskUtil.getActualOwner(taskDAO).getName());
        }
        if (CommonTaskUtil.getDefaultPresentationName(taskDAO) != null) {
            taskInfo.setName(CommonTaskUtil.getDefaultPresentationName(taskDAO).getValue());
        }
        if (CommonTaskUtil.getDefaultPresentationSubject(taskDAO) != null) {
            taskInfo.setSubject(CommonTaskUtil.getDefaultPresentationSubject(taskDAO).getValue());
        }
        taskInfo.setStatus(taskDAO.getStatus());
        taskInfo.setType(taskDAO.getType());
        taskInfo.setModifiedDate(taskDAO.getUpdatedOn());
        taskInfo.setStatusBeforeSuspension(taskDAO.getStatusBeforeSuspension());
        return taskInfo;
    }

    public static TaskEventInfo populateTaskEventInfo(EventDAO eventDAO, TaskDAO taskDAO) {
        TaskEventInfo eventInfo = new TaskEventInfo();
        eventInfo.setTimestamp(eventDAO.getTimeStamp());
        eventInfo.setEventInitiator(eventDAO.getUser());
        eventInfo.setEventType(eventDAO.getType());
        eventInfo.setNewState(eventDAO.getNewState());
        eventInfo.setOldState(eventDAO.getOldState());
        eventInfo.setTaskInfo(CommonTaskUtil.populateTaskInfo(taskDAO));
        return eventInfo;
    }
}

