/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.OrganizationalEntityDAO;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.dao.TaskStatus;
import org.wso2.carbon.humantask.core.dao.TaskType;
import org.wso2.carbon.humantask.core.engine.PeopleQueryEvaluator;
import org.wso2.carbon.humantask.core.engine.people.eval.PeopleQueryComparators;
import org.wso2.carbon.humantask.core.engine.util.CommonTaskUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperationAuthorizationUtil {
    private OperationAuthorizationUtil() {
    }

    public static boolean authoriseUser(TaskDAO task, OrganizationalEntityDAO validatee, List<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoleTypes, PeopleQueryEvaluator pqe) {
        List<GenericHumanRoleDAO> humanRolesInTask = task.getHumanRoles();
        for (GenericHumanRoleDAO role : humanRolesInTask) {
            if (!allowedRoleTypes.contains((Object)role.getType())) continue;
            for (OrganizationalEntityDAO entityForRole : OperationAuthorizationUtil.getGroupOrganizationalEntities(role)) {
                String roleName;
                List<String> userListForRole;
                if (!OrganizationalEntityDAO.OrganizationalEntityType.GROUP.equals((Object)entityForRole.getOrgEntityType()) || !(userListForRole = pqe.getUserNameListForRole(roleName = entityForRole.getName())).contains(validatee.getName())) continue;
                return true;
            }
            List<OrganizationalEntityDAO> orgEntities = OperationAuthorizationUtil.getUserOrganizationalEntities(role);
            Collections.sort(orgEntities, PeopleQueryComparators.peopleNameComparator());
            if (Collections.binarySearch(orgEntities, validatee, PeopleQueryComparators.peopleNameComparator()) < 0) continue;
            return true;
        }
        return false;
    }

    private static List<OrganizationalEntityDAO> getGroupOrganizationalEntities(GenericHumanRoleDAO role) {
        ArrayList<OrganizationalEntityDAO> groupOrgEntities = new ArrayList<OrganizationalEntityDAO>();
        for (OrganizationalEntityDAO orgEntity : role.getOrgEntities()) {
            if (!OrganizationalEntityDAO.OrganizationalEntityType.GROUP.equals((Object)orgEntity.getOrgEntityType())) continue;
            groupOrgEntities.add(orgEntity);
        }
        return groupOrgEntities;
    }

    private static List<OrganizationalEntityDAO> getUserOrganizationalEntities(GenericHumanRoleDAO role) {
        ArrayList<OrganizationalEntityDAO> userOrgEntities = new ArrayList<OrganizationalEntityDAO>();
        for (OrganizationalEntityDAO orgEntity : role.getOrgEntities()) {
            if (!OrganizationalEntityDAO.OrganizationalEntityType.USER.equals((Object)orgEntity.getOrgEntityType())) continue;
            userOrgEntities.add(orgEntity);
        }
        return userOrgEntities;
    }

    public static boolean authorisedToActivate(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        if (task.getActivationTime() == null || task.getActivationTime().before(new Date())) {
            return false;
        }
        if (CommonTaskUtil.getOrgEntitiesForRole(task, GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS).size() < 1) {
            return false;
        }
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.TASK_INITIATOR);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.STAKEHOLDERS);
        return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
    }

    public static boolean authorisedToUpdateComment(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.STAKEHOLDERS);
        return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
    }

    public static boolean authorisedToSuspend(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        if (!(TaskStatus.IN_PROGRESS.equals((Object)task.getStatus()) || TaskStatus.READY.equals((Object)task.getStatus()) || TaskStatus.RESERVED.equals((Object)task.getStatus()))) {
            return false;
        }
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.STAKEHOLDERS);
        return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
    }

    public static boolean authorisedToStop(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        if (!TaskStatus.IN_PROGRESS.equals((Object)task.getStatus())) {
            return false;
        }
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
    }

    public static boolean authorisedToStart(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        if (TaskStatus.READY.equals((Object)task.getStatus())) {
            ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
            allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS);
            return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
        }
        if (TaskStatus.RESERVED.equals((Object)task.getStatus())) {
            ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
            allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
            return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
        }
        return false;
    }

    public static boolean authorisedToSkip(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        if (!task.isSkipable().booleanValue()) {
            return false;
        }
        if (TaskStatus.CREATED.equals((Object)task.getStatus()) || TaskStatus.READY.equals((Object)task.getStatus()) || TaskStatus.RESERVED.equals((Object)task.getStatus()) || TaskStatus.IN_PROGRESS.equals((Object)task.getStatus())) {
            ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
            allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.TASK_INITIATOR);
            allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
            allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.STAKEHOLDERS);
            return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
        }
        return false;
    }

    public static boolean authorisedToSetPriority(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.STAKEHOLDERS);
        return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
    }

    public static boolean authorisedToSetOutput(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
    }

    public static boolean authorisedToSetFault(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
    }

    public static boolean authorisedToRemove(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        if (!TaskType.NOTIFICATION.equals((Object)task.getType())) {
            return false;
        }
        if (!TaskStatus.READY.equals((Object)task.getStatus())) {
            return false;
        }
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
        return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
    }

    public static boolean authorisedToResume(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        if (!TaskStatus.SUSPENDED.equals((Object)task.getStatus())) {
            return false;
        }
        if (task.getStatusBeforeSuspension() == null) {
            return false;
        }
        if (!(TaskStatus.IN_PROGRESS.equals((Object)task.getStatusBeforeSuspension()) || TaskStatus.READY.equals((Object)task.getStatusBeforeSuspension()) || TaskStatus.RESERVED.equals((Object)task.getStatusBeforeSuspension()))) {
            return false;
        }
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.STAKEHOLDERS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS);
        return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
    }

    public static boolean authorisedToRelease(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        if (TaskStatus.IN_PROGRESS.equals((Object)task.getStatus()) || TaskStatus.RESERVED.equals((Object)task.getStatus())) {
            allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
            return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
        }
        return false;
    }

    public static boolean authorisedToNominate(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        if (!TaskStatus.CREATED.equals((Object)task.getStatus())) {
            return false;
        }
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
        return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
    }

    public static boolean authorisedToGetInput(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.STAKEHOLDERS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.TASK_INITIATOR);
        return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
    }

    public static boolean authorisedToGetDescription(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.STAKEHOLDERS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.TASK_INITIATOR);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.NOTIFICATION_RECIPIENTS);
        return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
    }

    public static boolean authorisedToGetComments(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.STAKEHOLDERS);
        return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
    }

    public static boolean authorisedToForward(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
    }

    public static boolean authorisedToFail(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        if (!TaskStatus.IN_PROGRESS.equals((Object)task.getStatus())) {
            return false;
        }
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
    }

    public static boolean authorisedToExit(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        if (TaskStatus.EXITED.equals((Object)task.getStatus()) || TaskStatus.ERROR.equals((Object)task.getStatus()) || TaskStatus.FAILED.equals((Object)task.getStatus()) || TaskStatus.OBSOLETE.equals((Object)task.getStatus()) || TaskStatus.COMPLETED.equals((Object)task.getStatus())) {
            return false;
        }
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
    }

    public static boolean authorisedToDeleteOutput(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        if (!TaskStatus.IN_PROGRESS.equals((Object)task.getStatus())) {
            return false;
        }
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
    }

    public static boolean authorisedToDeleteComment(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.STAKEHOLDERS);
        return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
    }

    public static boolean authorisedToDeleteFault(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        if (!TaskStatus.IN_PROGRESS.equals((Object)task.getStatus())) {
            return false;
        }
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
    }

    public static boolean authorisedToDelegate(TaskDAO task, OrganizationalEntityDAO operationInvoker, PeopleQueryEvaluator pqe) {
        if (TaskStatus.READY.equals((Object)task.getStatus()) || TaskStatus.IN_PROGRESS.equals((Object)task.getStatus()) || TaskStatus.RESERVED.equals((Object)task.getStatus())) {
            List<String> assignableUsersWithoutActualOwner = CommonTaskUtil.getAssignableUserNameList(task, true);
            if (assignableUsersWithoutActualOwner.size() < 1) {
                return false;
            }
            ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
            allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
            allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
            return OperationAuthorizationUtil.authoriseUser(task, operationInvoker, allowedRoles, pqe);
        }
        return false;
    }

    public static boolean authorisedToComplete(TaskDAO task, OrganizationalEntityDAO operationInvoker, PeopleQueryEvaluator pqe) {
        if (!TaskStatus.IN_PROGRESS.equals((Object)task.getStatus())) {
            return false;
        }
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        return OperationAuthorizationUtil.authoriseUser(task, operationInvoker, allowedRoles, pqe);
    }

    public static boolean authorisedToComment(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.STAKEHOLDERS);
        return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
    }

    public static boolean authorisedToClaim(TaskDAO task, OrganizationalEntityDAO caller, PeopleQueryEvaluator pqe) {
        if (!TaskStatus.READY.equals((Object)task.getStatus())) {
            return false;
        }
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS);
        return OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, pqe);
    }
}

