/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.integration;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.receivers.AbstractMessageReceiver;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bpel.common.WSDLAwareSOAPProcessor;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.humantask.core.engine.HumanTaskEngine;
import org.wso2.carbon.humantask.core.integration.utils.SOAPUtils;

public class AxisHumanTaskMessageReceiver
extends AbstractMessageReceiver {
    private static Log log = LogFactory.getLog(AxisHumanTaskMessageReceiver.class);
    private static Log messageTraceLog = LogFactory.getLog((String)"org.wso2.carbon.humantask.messagetrace");
    private HumanTaskEngine humanTaskEngine;

    protected void invokeBusinessLogic(MessageContext messageContext) throws AxisFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        if (messageTraceLog.isDebugEnabled()) {
            messageTraceLog.debug((Object)("Message received: " + messageContext.getAxisService().getName() + "." + messageContext.getAxisOperation().getName()));
            if (messageTraceLog.isTraceEnabled()) {
                messageTraceLog.trace((Object)("Request message: " + messageContext.getEnvelope()));
            }
        }
        WSDLAwareSOAPProcessor soapProcessor = new WSDLAwareSOAPProcessor(messageContext);
        if (this.hasResponse(messageContext.getAxisOperation())) {
            MessageContext outMessageContext = MessageContextBuilder.createOutMessageContext((MessageContext)messageContext);
            outMessageContext.getOperationContext().addMessageContext(outMessageContext);
            SOAPEnvelope envelope = this.getSOAPFactory(messageContext).getDefaultEnvelope();
            try {
                String taskId = this.humanTaskEngine.invoke(soapProcessor.parseRequest());
                if (taskId != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Task: " + taskId + "successfully created"));
                    }
                    envelope.getBody().addChild((OMNode)this.getFeedbackPayLoad(taskId));
                } else {
                    String reason = "Error occurred while initiating human task. The task ID is not found";
                    this.handleFault(soapProcessor.getSoapFactory(), envelope, reason);
                }
            }
            catch (Exception e) {
                this.handleFault(soapProcessor.getSoapFactory(), envelope, e.getMessage());
                log.error((Object)"Task creation failed.", (Throwable)e);
            }
            outMessageContext.setEnvelope(envelope);
            if (messageTraceLog.isDebugEnabled()) {
                messageTraceLog.debug((Object)("Replied TaskID: " + messageContext.getAxisService().getName() + "." + messageContext.getAxisOperation().getName()));
                if (messageTraceLog.isTraceEnabled()) {
                    messageTraceLog.trace((Object)("Replied TaskID message: " + outMessageContext.getEnvelope()));
                }
            }
            AxisEngine.send((MessageContext)outMessageContext);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Notification request received.");
            }
            try {
                String taskId = this.humanTaskEngine.invoke(soapProcessor.parseRequest());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Notification: " + taskId + "successfully created"));
                }
            }
            catch (Exception e) {
                log.error((Object)"Notification creation failed.", (Throwable)e);
            }
        }
    }

    private void handleFault(SOAPFactory soapFactory, SOAPEnvelope envelope, String reason) {
        SOAPFault fault = SOAPUtils.createSOAPFault(soapFactory, reason);
        envelope.getBody().addFault(fault);
    }

    public void setHumanTaskEngine(HumanTaskEngine humanTaskEngine) {
        this.humanTaskEngine = humanTaskEngine;
    }

    private boolean hasResponse(AxisOperation op) {
        switch (op.getAxisSpecificMEPConstant()) {
            case 12: {
                return true;
            }
            case 14: {
                return true;
            }
            case 17: {
                return true;
            }
            case 15: {
                return true;
            }
        }
        return false;
    }

    private OMElement getFeedbackPayLoad(String taskID) {
        OMFactory fbOMFactory = OMAbstractFactory.getOMFactory();
        OMElement payLoadEle = fbOMFactory.createOMElement("part", null);
        OMElement hiFeedbackEle = fbOMFactory.createOMElement("correlation", fbOMFactory.createOMNamespace("http://docs.oasis-open.org/ns/bpel4people/bpel4people/200803", null), (OMContainer)payLoadEle);
        OMElement taskIDEle = fbOMFactory.createOMElement("taskid", fbOMFactory.createOMNamespace("http://docs.oasis-open.org/ns/bpel4people/bpel4people/200803", null), (OMContainer)hiFeedbackEle);
        taskIDEle.setText(taskID);
        return payLoadEle;
    }
}

