/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.integration;

import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bpel.common.SOAPHelper;
import org.wso2.carbon.bpel.common.config.EndpointConfiguration;
import org.wso2.carbon.humantask.core.CallBackService;
import org.wso2.carbon.humantask.core.deployment.HumanTaskDeploymentException;
import org.wso2.carbon.humantask.core.integration.utils.AxisServiceUtils;
import org.wso2.carbon.humantask.core.integration.utils.ServiceInvocationContext;
import org.wso2.carbon.humantask.core.internal.HumanTaskServiceComponent;
import org.wso2.carbon.unifiedendpoint.core.UnifiedEndpoint;
import org.wso2.carbon.utils.CarbonUtils;

public class CallBackServiceImpl
implements CallBackService {
    private static Log log = LogFactory.getLog(CallBackServiceImpl.class);
    private UnifiedEndpoint uep;
    private int tenantId;
    private QName serviceName;
    private String portName;
    private QName taskName;
    private Binding binding;
    private String operation;

    public CallBackServiceImpl(int tenantId, QName serviceName, String portName, QName taskName, Definition wsdl, String operation, EndpointConfiguration endpointConfig) throws HumanTaskDeploymentException {
        this.tenantId = tenantId;
        this.serviceName = serviceName;
        this.portName = portName;
        this.taskName = taskName;
        this.operation = operation;
        this.inferBindingInformation(wsdl);
        if (endpointConfig != null) {
            try {
                this.uep = endpointConfig.getUnifiedEndpoint();
            }
            catch (AxisFault axisFault) {
                String errMsg = "Error occurred while reading unified endpoint for callback service: " + serviceName + " of port: " + portName;
                log.error((Object)errMsg, (Throwable)axisFault);
                throw new HumanTaskDeploymentException(errMsg, axisFault);
            }
        } else {
            this.uep = new UnifiedEndpoint();
            this.uep.setUepId(this.serviceName.getLocalPart());
            this.uep.setAddressingEnabled(true);
            this.uep.setAddressingVersion("final");
            this.uep.setAddress(CarbonUtils.resolveSystemProperty((String)AxisServiceUtils.getEPRfromWSDL(wsdl, serviceName, portName)));
        }
    }

    public void invoke(OMElement payload, long taskId) throws AxisFault {
        MessageContext mctx = new MessageContext();
        ServiceInvocationContext invocationContext = new ServiceInvocationContext();
        invocationContext.setInMessageContext(mctx);
        invocationContext.setUep(this.uep);
        invocationContext.setService(this.serviceName);
        invocationContext.setPort(this.portName);
        invocationContext.setCaller(this.taskName.getLocalPart());
        invocationContext.setWsdlBindingForCurrentMessageFlow(this.binding);
        invocationContext.setOperationName(this.operation);
        if (mctx.getEnvelope() == null) {
            mctx.setEnvelope(this.getSoapFactory().createSOAPEnvelope());
        }
        if (mctx.getEnvelope().getBody() == null) {
            this.getSoapFactory().createSOAPBody(mctx.getEnvelope());
        }
        if (mctx.getEnvelope().getHeader() == null) {
            this.getSoapFactory().createSOAPHeader(mctx.getEnvelope());
        }
        mctx.getEnvelope().getBody().addChild((OMNode)payload);
        OMNamespace ns = OMAbstractFactory.getSOAP11Factory().createOMNamespace("http://docs.oasis-open.org/ns/bpel4people/bpel4people/200803", "b4p");
        SOAPHeaderBlock header = mctx.getEnvelope().getHeader().addHeaderBlock("correlation", ns);
        header.addAttribute("taskid", Long.toString(taskId), ns);
        AxisServiceUtils.invokeService(invocationContext, HumanTaskServiceComponent.getHumanTaskServer().getTaskStoreManager().getHumanTaskStore(this.tenantId).getConfigContext());
    }

    private void inferBindingInformation(Definition wsdlDefinition) throws HumanTaskDeploymentException {
        Service serviceDef = wsdlDefinition.getService(this.serviceName);
        if (serviceDef == null) {
            throw new HumanTaskDeploymentException("Service element not found for callback service wsdl: " + this.serviceName);
        }
        Port port = serviceDef.getPort(this.portName);
        if (port == null) {
            throw new HumanTaskDeploymentException("Port: " + this.portName + " not found for Service: " + this.serviceName + " in the callback service wsdl");
        }
        this.binding = port.getBinding();
        if (this.binding == null) {
            throw new HumanTaskDeploymentException("Binding not found for port: " + this.portName + " and Service: " + this.serviceName + " in the callback service wsdl");
        }
    }

    public SOAPFactory getSoapFactory() throws AxisFault {
        ExtensibilityElement bindingType = SOAPHelper.getBindingExtension((Binding)this.binding);
        if (!(bindingType instanceof SOAPBinding || bindingType instanceof SOAP12Binding || bindingType instanceof HTTPBinding)) {
            throw new AxisFault("Service binding is not supported for service " + this.serviceName);
        }
        if (bindingType instanceof SOAPBinding) {
            return OMAbstractFactory.getSOAP11Factory();
        }
        return OMAbstractFactory.getSOAP12Factory();
    }
}

