/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.integration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.HumanTaskDAOConnection;
import org.wso2.carbon.humantask.core.dao.OrganizationalEntityDAO;
import org.wso2.carbon.humantask.core.engine.PeopleQueryEvaluator;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskRuntimeException;
import org.wso2.carbon.humantask.core.internal.HumanTaskServiceComponent;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CarbonUserManagerBasedPeopleQueryEvaluator
implements PeopleQueryEvaluator {
    private static Log log = LogFactory.getLog(CarbonUserManagerBasedPeopleQueryEvaluator.class);
    private RegistryService registryService = HumanTaskServiceComponent.getRegistryService();

    @Override
    public boolean isExistingUser(String userName) {
        try {
            return this.getUserRealm().getUserStoreManager().isExistingUser(userName);
        }
        catch (UserStoreException e) {
            throw new HumanTaskRuntimeException("Error occurred while calling to realm service", e);
        }
    }

    @Override
    public boolean isExistingRole(String roleName) {
        try {
            return this.getUserRealm().getUserStoreManager().isExistingRole(roleName);
        }
        catch (UserStoreException e) {
            throw new HumanTaskRuntimeException("Error occurred while calling to realm service for operation isExistingRole", e);
        }
    }

    @Override
    public boolean hasUsersForRole(String roleName) {
        throw new UnsupportedOperationException("TODO Implement me");
    }

    @Override
    public List<String> getUserNameListForRole(String roleName) {
        if (this.isExistingRole(roleName)) {
            try {
                return new ArrayList<String>(Arrays.asList(this.getUserRealm().getUserStoreManager().getUserListOfRole(roleName)));
            }
            catch (UserStoreException e) {
                throw new HumanTaskRuntimeException("Error occurred while calling to realm service for operation isExistingRole", e);
            }
        }
        throw new HumanTaskRuntimeException(String.format("The role name[%s] does not exist.", roleName));
    }

    @Override
    public List<String> getRoleNameListForUser(String userName) {
        String tUserName = userName;
        ArrayList<String> matchingRoleNames = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)tUserName) && this.isExistingUser(tUserName = tUserName.trim())) {
            try {
                matchingRoleNames.addAll(Arrays.asList(this.getUserRealm().getUserStoreManager().getRoleListOfUser(tUserName)));
            }
            catch (UserStoreException ex) {
                throw new HumanTaskRuntimeException("Error occurred while calling to realm service for operation isExistingRole", ex);
            }
        }
        return matchingRoleNames;
    }

    @Override
    public OrganizationalEntityDAO createGroupOrgEntityForRole(String roleName) {
        String tRoleName = roleName.trim();
        if (this.isExistingRole(tRoleName)) {
            return this.getConnection().createNewOrgEntityObject(tRoleName, OrganizationalEntityDAO.OrganizationalEntityType.GROUP);
        }
        throw new HumanTaskRuntimeException(String.format("The role name[%s] does not exist.", tRoleName));
    }

    @Override
    public OrganizationalEntityDAO createUserOrgEntityForName(String userName) {
        if (this.isExistingUser(userName)) {
            return this.getConnection().createNewOrgEntityObject(userName, OrganizationalEntityDAO.OrganizationalEntityType.USER);
        }
        throw new HumanTaskRuntimeException(String.format("The user name[%s] does not exist.", userName));
    }

    @Override
    public GenericHumanRoleDAO createGHRForRoleName(String roleName, GenericHumanRoleDAO.GenericHumanRoleType type) {
        if (this.isExistingRole(roleName)) {
            List<String> userNames = this.getUserNameListForRole(roleName);
            GenericHumanRoleDAO ghr = this.getConnection().createNewGHRObject(type);
            ArrayList<OrganizationalEntityDAO> orgEntities = new ArrayList<OrganizationalEntityDAO>();
            for (String userName : userNames) {
                OrganizationalEntityDAO orgEntity = this.getConnection().createNewOrgEntityObject(userName, OrganizationalEntityDAO.OrganizationalEntityType.USER);
                orgEntity.addGenericHumanRole(ghr);
                orgEntities.add(orgEntity);
            }
            ghr.setOrgEntities(orgEntities);
            return ghr;
        }
        throw new HumanTaskRuntimeException(String.format("The role name[%s] does not exist.", roleName));
    }

    @Override
    public void checkOrgEntitiesExist(List<OrganizationalEntityDAO> orgEntities) {
        if (orgEntities != null) {
            for (OrganizationalEntityDAO orgEntity : orgEntities) {
                this.checkOrgEntityExists(orgEntity);
            }
        }
    }

    @Override
    public void checkOrgEntityExists(OrganizationalEntityDAO orgEntity) {
        if (orgEntity != null) {
            if (OrganizationalEntityDAO.OrganizationalEntityType.USER.equals((Object)orgEntity.getOrgEntityType())) {
                if (!this.isExistingUser(orgEntity.getName())) {
                    throw new HumanTaskRuntimeException(String.format("The user name:[%s] does not exist in the user store!", orgEntity.getName()));
                }
            } else if (OrganizationalEntityDAO.OrganizationalEntityType.GROUP.equals((Object)orgEntity.getOrgEntityType()) && !this.isExistingRole(orgEntity.getName())) {
                throw new HumanTaskRuntimeException(String.format("The group name:[%s] does not exist in the user store!", orgEntity.getName()));
            }
        }
    }

    @Override
    public boolean isOrgEntityInRole(OrganizationalEntityDAO entity, GenericHumanRoleDAO role) {
        boolean isOrgEntityInRole = false;
        for (OrganizationalEntityDAO orgEntity : role.getOrgEntities()) {
            if (OrganizationalEntityDAO.OrganizationalEntityType.USER.equals((Object)orgEntity.getOrgEntityType())) {
                if (orgEntity.getName().equals(entity.getName())) {
                    isOrgEntityInRole = true;
                }
            } else if (OrganizationalEntityDAO.OrganizationalEntityType.GROUP.equals((Object)orgEntity.getOrgEntityType()) && this.getUserNameListForRole(orgEntity.getName()).contains(entity.getName())) {
                isOrgEntityInRole = true;
            }
            if (!isOrgEntityInRole) continue;
            break;
        }
        return isOrgEntityInRole;
    }

    @Override
    public String getLoggedInUser() {
        String userName = null;
        if (StringUtils.isNotEmpty((String)CarbonContext.getCurrentContext().getUsername())) {
            userName = CarbonContext.getCurrentContext().getUsername();
        }
        return userName;
    }

    private HumanTaskDAOConnection getConnection() {
        return HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getDaoConnectionFactory().getConnection();
    }

    private UserRealm getUserRealm() {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        try {
            return this.registryService.getUserRealm(tenantId);
        }
        catch (RegistryException e) {
            throw new HumanTaskRuntimeException("Error occurred while retrieving User Realm for tenant :" + tenantId, e);
        }
    }
}

