/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.integration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.wsdl.xml.WSDLLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;

public class HumanTaskWSDLLocator
implements WSDLLocator {
    private static final Log log = LogFactory.getLog(HumanTaskWSDLLocator.class);
    private URI baseUri;
    private String latest;

    public HumanTaskWSDLLocator(URI baseUri) {
        this.baseUri = baseUri;
    }

    public HumanTaskWSDLLocator() {
        this.baseUri = null;
    }

    public InputSource getBaseInputSource() {
        try {
            InputSource is = new InputSource();
            is.setByteStream(this.openResource(this.baseUri));
            is.setSystemId(this.baseUri.toString());
            return is;
        }
        catch (IOException e) {
            log.error((Object)("Unable to create InputSource for " + this.baseUri), (Throwable)e);
            return null;
        }
    }

    public InputStream openResource(URI uri) throws IOException {
        if (uri.isAbsolute() && uri.getScheme().equals("file")) {
            try {
                return uri.toURL().openStream();
            }
            catch (Exception except) {
                log.error((Object)("openResource: unable to open file URL " + uri + "; " + except.toString()));
                return null;
            }
        }
        URI relative = this.baseUri.relativize(uri);
        if (relative.isAbsolute() && relative.getScheme().equals("http")) {
            try {
                return relative.toURL().openStream();
            }
            catch (Exception except) {
                log.error((Object)("openResource: unable to open http URL " + uri + "; " + except.toString()));
                return null;
            }
        }
        if (relative.isAbsolute() && !relative.getScheme().equals("urn")) {
            log.error((Object)("openResource: invalid scheme (should be urn:)  " + uri));
            return null;
        }
        File f = new File(this.baseUri.getPath(), relative.getPath());
        if (!f.exists()) {
            log.error((Object)("openResource: file not found " + f));
            return null;
        }
        return new FileInputStream(f);
    }

    public InputSource getImportInputSource(String parent, String imprt) {
        URI uri;
        try {
            uri = parent == null ? this.baseUri.resolve(imprt) : new URI(parent).resolve(imprt);
        }
        catch (URISyntaxException e1) {
            log.error((Object)("URI syntax error: parent=" + parent), (Throwable)e1);
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get import:  import=" + imprt + " parent=" + parent));
        }
        InputSource is = new InputSource();
        try {
            is.setByteStream(this.openResource(uri));
        }
        catch (Exception e) {
            log.error((Object)("Unable to open import resource: " + uri), (Throwable)e);
            return null;
        }
        is.setSystemId(uri.toString());
        this.latest = uri.toString();
        return is;
    }

    public String getBaseURI() {
        if (this.baseUri == null) {
            return null;
        }
        return this.baseUri.toString();
    }

    public String getLatestImportURI() {
        return this.latest;
    }

    public void close() {
    }
}

