/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.integration.utils;

import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AnonymousServiceFactory {
    private static Log log = LogFactory.getLog(AnonymousServiceFactory.class);

    private AnonymousServiceFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AxisService getAnonymousService(QName serviceName, String servicePort, AxisConfiguration axisConfig, String caller) {
        String serviceKey = "axis_service_for_" + caller + "#" + serviceName.getLocalPart() + "#" + servicePort;
        try {
            AxisService service = axisConfig.getService(serviceKey);
            if (service != null) return service;
            Class<AnonymousServiceFactory> clazz = AnonymousServiceFactory.class;
            synchronized (AnonymousServiceFactory.class) {
                service = axisConfig.getService(serviceKey);
                if (service == null) return AnonymousServiceFactory.createAnonymousService(axisConfig, serviceKey);
                // ** MonitorExit[var6_7] (shouldn't be in output)
                return service;
            }
        }
        catch (AxisFault axisFault) {
            AnonymousServiceFactory.handleException("Error retrieving service for key " + serviceKey, (Exception)((Object)axisFault));
            return null;
        }
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new RuntimeException(msg, e);
    }

    private static AxisService createAnonymousService(AxisConfiguration axisCfg, String serviceKey) {
        try {
            OutOnlyAxisOperation outOnlyOperation = new OutOnlyAxisOperation(ServiceClient.ANON_OUT_ONLY_OP);
            OutInAxisOperation outInOperation = new OutInAxisOperation(ServiceClient.ANON_OUT_IN_OP);
            AxisService axisAnonymousService = new AxisService(serviceKey);
            axisAnonymousService.addOperation((AxisOperation)outOnlyOperation);
            axisAnonymousService.addOperation((AxisOperation)outInOperation);
            outOnlyOperation.setSoapAction("");
            outInOperation.setSoapAction("");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating Client Service: " + serviceKey));
            }
            axisAnonymousService.setClientSide(true);
            axisCfg.addService(axisAnonymousService);
            return axisAnonymousService;
        }
        catch (AxisFault axisFault) {
            AnonymousServiceFactory.handleException("Adding service to axis configuration failed.", (Exception)((Object)axisFault));
            return null;
        }
    }
}

