/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.integration.utils;

import java.util.Collection;
import java.util.Iterator;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bpel.common.CollectionsX;
import org.wso2.carbon.humantask.core.integration.utils.AnonymousServiceFactory;
import org.wso2.carbon.humantask.core.integration.utils.ServiceInvocationContext;

public final class AxisServiceUtils {
    private static Log log = LogFactory.getLog(AxisServiceUtils.class);
    public static final String WS_ADDRESSING_NS = "http://www.w3.org/2005/08/addressing";
    public static final String WS_ADDRESSING_NS2 = "http://www.w3.org/2006/05/addressing/wsdl";
    public static final String WS_ADDRESSING_NS3 = "http://www.w3.org/2006/02/addressing/wsdl";
    public static final String WS_ADDRESSING_NS4 = "http://schemas.xmlsoap.org/ws/2004/08/addressing";

    private AxisServiceUtils() {
    }

    public static void invokeService(ServiceInvocationContext partnerInvocationContext, ConfigurationContext configContext) throws AxisFault {
        MessageContext mctx = partnerInvocationContext.getInMessageContext();
        OperationClient opClient = AxisServiceUtils.getOperationClient(partnerInvocationContext, configContext);
        mctx.getOptions().setParent(opClient.getOptions());
        opClient.addMessageContext(mctx);
        Options operationOptions = opClient.getOptions();
        if (partnerInvocationContext.getUep().isAddressingEnabled()) {
            String action = AxisServiceUtils.getAction(partnerInvocationContext);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Soap action: " + action));
            }
            operationOptions.setAction(action);
        }
        operationOptions.setTo((EndpointReference)partnerInvocationContext.getUep());
        opClient.execute(true);
    }

    private static OperationClient getOperationClient(ServiceInvocationContext partnerMessageContext, ConfigurationContext clientConfigCtx) throws AxisFault {
        AxisService anonymousService = AnonymousServiceFactory.getAnonymousService(partnerMessageContext.getService(), partnerMessageContext.getPort(), clientConfigCtx.getAxisConfiguration(), partnerMessageContext.getCaller());
        anonymousService.engageModule(clientConfigCtx.getAxisConfiguration().getModule("UEPModule"));
        anonymousService.getParent().addParameter("hiddenService", (Object)"true");
        ServiceGroupContext sgc = new ServiceGroupContext(clientConfigCtx, (AxisServiceGroup)anonymousService.getParent());
        ServiceContext serviceCtx = sgc.getServiceContext(anonymousService);
        AxisOperation axisAnonymousOperation = anonymousService.getOperation(partnerMessageContext.isTwoWay() ? ServiceClient.ANON_OUT_IN_OP : ServiceClient.ANON_OUT_ONLY_OP);
        Options clientOptions = AxisServiceUtils.cloneOptions(partnerMessageContext.getInMessageContext().getOptions());
        clientOptions.setExceptionToBeThrownOnSOAPFault(false);
        clientOptions.setTimeOutInMilliSeconds(60000L);
        return axisAnonymousOperation.createClient(serviceCtx, clientOptions);
    }

    public static String getAction(ServiceInvocationContext partnerMessageContext) {
        String action = AxisServiceUtils.getWSAInputAction(partnerMessageContext);
        if (action == null || "".equals(action)) {
            action = AxisServiceUtils.getSoapAction(partnerMessageContext);
        }
        return action;
    }

    public static String getWSAInputAction(ServiceInvocationContext partnerMessageContext) {
        BindingOperation bop = partnerMessageContext.getWsdlBindingForCurrentMessageFlow().getBindingOperation(partnerMessageContext.getOperationName(), null, null);
        if (bop == null) {
            return "";
        }
        Input input = bop.getOperation().getInput();
        if (input != null) {
            Object action = input.getExtensionAttribute(new QName(WS_ADDRESSING_NS, "Action"));
            if (action instanceof String) {
                return (String)action;
            }
            action = input.getExtensionAttribute(new QName(WS_ADDRESSING_NS2, "Action"));
            if (action instanceof String) {
                return (String)action;
            }
            action = input.getExtensionAttribute(new QName(WS_ADDRESSING_NS3, "Action"));
            if (action instanceof String) {
                return (String)action;
            }
            action = input.getExtensionAttribute(new QName(WS_ADDRESSING_NS4, "Action"));
            if (action instanceof QName) {
                return ((QName)action).getLocalPart();
            }
        }
        return "";
    }

    public static String getSoapAction(ServiceInvocationContext partnerMessageContext) {
        BindingOperation bop = partnerMessageContext.getWsdlBindingForCurrentMessageFlow().getBindingOperation(partnerMessageContext.getOperationName(), null, null);
        if (bop == null) {
            return "";
        }
        if (partnerMessageContext.isSoap12()) {
            Iterator i$ = CollectionsX.filter((Collection)bop.getExtensibilityElements(), SOAP12Operation.class).iterator();
            if (i$.hasNext()) {
                SOAP12Operation soapOp = (SOAP12Operation)i$.next();
                return soapOp.getSoapActionURI();
            }
        } else {
            Iterator i$ = CollectionsX.filter((Collection)bop.getExtensibilityElements(), SOAPOperation.class).iterator();
            if (i$.hasNext()) {
                SOAPOperation soapOp = (SOAPOperation)i$.next();
                return soapOp.getSoapActionURI();
            }
        }
        return "";
    }

    public static Options cloneOptions(Options options) {
        Options clonedOptions = new Options(options.getParent());
        clonedOptions.setCallTransportCleanup(options.isCallTransportCleanup());
        clonedOptions.setExceptionToBeThrownOnSOAPFault(options.isExceptionToBeThrownOnSOAPFault());
        clonedOptions.setManageSession(options.isManageSession());
        clonedOptions.setSoapVersionURI(options.getSoapVersionURI());
        clonedOptions.setTimeOutInMilliSeconds(options.getTimeOutInMilliSeconds());
        clonedOptions.setUseSeparateListener(options.isUseSeparateListener());
        clonedOptions.setListener(options.getListener());
        clonedOptions.setTransportIn(options.getTransportIn());
        clonedOptions.setTransportInProtocol(options.getTransportInProtocol());
        clonedOptions.setTransportOut(clonedOptions.getTransportOut());
        clonedOptions.setUserName(options.getUserName());
        clonedOptions.setPassword(options.getPassword());
        Iterator i$ = options.getProperties().keySet().iterator();
        while (i$.hasNext()) {
            String o;
            String key = o = (String)i$.next();
            clonedOptions.setProperty(key, options.getProperty(key));
        }
        return clonedOptions;
    }

    public static String getEPRfromWSDL(Definition wsdlDef, QName serviceName, String portName) {
        Port portDef;
        Service serviceDef = wsdlDef.getService(serviceName);
        if (serviceDef != null && (portDef = serviceDef.getPort(portName)) != null) {
            for (Object extElmt : portDef.getExtensibilityElements()) {
                if (extElmt instanceof SOAPAddress) {
                    return ((SOAPAddress)extElmt).getLocationURI();
                }
                if (extElmt instanceof HTTPAddress) {
                    return ((HTTPAddress)extElmt).getLocationURI();
                }
                if (!(extElmt instanceof SOAP12Address)) continue;
                return ((SOAP12Address)extElmt).getLocationURI();
            }
        }
        return null;
    }
}

