/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.attachment.mgt.server.AttachmentServerService;
import org.wso2.carbon.datasource.DataSourceInformationRepositoryService;
import org.wso2.carbon.humantask.core.Axis2ConfigurationContextObserverImpl;
import org.wso2.carbon.humantask.core.HumanTaskEngineService;
import org.wso2.carbon.humantask.core.HumanTaskEngineServiceImpl;
import org.wso2.carbon.humantask.core.HumanTaskServer;
import org.wso2.carbon.humantask.core.engine.HumanTaskServerException;
import org.wso2.carbon.humantask.core.internal.HumanTaskServerHolder;
import org.wso2.carbon.humantask.core.internal.HumanTaskUIResourceProvider;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.ui.util.UIResourceProvider;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;

public class HumanTaskServiceComponent {
    private static final Log log = LogFactory.getLog(HumanTaskServiceComponent.class);
    private BundleContext bundleContext;

    protected void activate(ComponentContext ctxt) {
        try {
            this.bundleContext = ctxt.getBundleContext();
            HumanTaskServerHolder htServerHolder = HumanTaskServerHolder.getInstance();
            if (htServerHolder.isDataSourceInfoRepoProvided() && htServerHolder.getRealmService() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Activating the HumanTaskServiceComponent....");
                }
                this.initHumanTaskServer(htServerHolder);
                this.registerAxis2ConfigurationContextObserver();
                this.registerHumanTaskServerService();
                if (HumanTaskServerHolder.getInstance().getHtServer().getServerConfig().isUiRenderingEnabled()) {
                    this.registerHumanTaskUIResourceProvider(htServerHolder);
                }
            } else {
                log.warn((Object)"Couldn't initialize Human Task Server, realmService == null or dataSourceInfoRepo not provided.");
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed to activate the HumanTaskServiceComponent.", t);
        }
    }

    private void initHumanTaskServer(HumanTaskServerHolder htServerHolder) throws HumanTaskServerException {
        htServerHolder.setHtServer(new HumanTaskServer());
        log.info((Object)"Initialising HumanTask Server");
        htServerHolder.getHtServer().init();
    }

    private void registerAxis2ConfigurationContextObserver() {
        log.info((Object)"Registering Axis2ConfigurationContextObserver");
        this.bundleContext.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new Axis2ConfigurationContextObserverImpl(), null);
    }

    private void registerHumanTaskUIResourceProvider(HumanTaskServerHolder htServerHolder) {
        log.info((Object)"Registering HumanTaskUIResourceProvider");
        htServerHolder.setHumanTaskUIResourceProvider(new HumanTaskUIResourceProvider());
        this.bundleContext.registerService(UIResourceProvider.class.getName(), (Object)htServerHolder.getHumanTaskUIResourceProvider(), null);
    }

    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Realm Service");
        }
        HumanTaskServerHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the Realm Service");
        }
        HumanTaskServerHolder.getInstance().setRealmService(null);
    }

    public static RealmService getRealmService() {
        return HumanTaskServerHolder.getInstance().getRealmService();
    }

    protected void setDataSourceInformationRepositoryService(DataSourceInformationRepositoryService dsInformationRepo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"DataSourceInformationRepositoryService bound to HumanTask component");
        }
        HumanTaskServerHolder.getInstance().setDataSourceInfoRepoProvided(true);
    }

    protected void unsetDataSourceInformationRepositoryService(DataSourceInformationRepositoryService dsInformationRepo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"DataSourceInformationRepositoryService unbound from HumanTask component");
        }
        HumanTaskServerHolder.getInstance().setDataSourceInfoRepoProvided(false);
    }

    protected void setRegistryService(RegistryService registrySvc) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService bound to the HumanTask component");
        }
        HumanTaskServerHolder.getInstance().setRegistryService(registrySvc);
    }

    protected void unsetRegistryService(RegistryService registrySvc) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unbound from the HumanTask component");
        }
        HumanTaskServerHolder.getInstance().setRegistryService(null);
    }

    public static RegistryService getRegistryService() {
        return HumanTaskServerHolder.getInstance().getRegistryService();
    }

    public static HumanTaskServer getHumanTaskServer() {
        return HumanTaskServerHolder.getInstance().getHtServer();
    }

    private void registerHumanTaskServerService() {
        this.bundleContext.registerService(HumanTaskEngineService.class.getName(), (Object)new HumanTaskEngineServiceImpl(), null);
    }

    protected void setAttachmentMgtService(AttachmentServerService attMgtService) {
        HumanTaskServerHolder.getInstance().setAttachmentService(attMgtService);
    }

    protected void unsetAttachmentMgtService(AttachmentServerService attMgtService) {
        HumanTaskServerHolder.getInstance().setAttachmentService(null);
    }
}

