/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.mgt.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.humantask.core.HumanTaskServer;
import org.wso2.carbon.humantask.core.dao.TaskPackageStatus;
import org.wso2.carbon.humantask.core.dao.TaskType;
import org.wso2.carbon.humantask.core.deployment.SimpleTaskDefinitionInfo;
import org.wso2.carbon.humantask.core.internal.HumanTaskServiceComponent;
import org.wso2.carbon.humantask.core.store.HumanTaskBaseConfiguration;
import org.wso2.carbon.humantask.core.store.HumanTaskStore;
import org.wso2.carbon.humantask.core.store.NotificationConfiguration;
import org.wso2.carbon.humantask.core.store.TaskConfiguration;
import org.wso2.carbon.humantask.skeleton.mgt.services.HumanTaskPackageManagementSkeletonInterface;
import org.wso2.carbon.humantask.skeleton.mgt.services.PackageManagementException;
import org.wso2.carbon.humantask.skeleton.mgt.services.types.DeployedPackagesPaginated;
import org.wso2.carbon.humantask.skeleton.mgt.services.types.DeployedTaskDefinitionsPaginated;
import org.wso2.carbon.humantask.skeleton.mgt.services.types.HumanTaskDefinition;
import org.wso2.carbon.humantask.skeleton.mgt.services.types.HumanTaskPackageDownloadData;
import org.wso2.carbon.humantask.skeleton.mgt.services.types.TaskDefinitionInfo;
import org.wso2.carbon.humantask.skeleton.mgt.services.types.TaskDefinition_type0;
import org.wso2.carbon.humantask.skeleton.mgt.services.types.TaskInfoType;
import org.wso2.carbon.humantask.skeleton.mgt.services.types.TaskStatusType;
import org.wso2.carbon.humantask.skeleton.mgt.services.types.Task_type0;
import org.wso2.carbon.humantask.skeleton.mgt.services.types.UndeployStatus_type0;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class HumanTaskPackageManagementSkeleton
extends AbstractAdmin
implements HumanTaskPackageManagementSkeletonInterface {
    private static Log log = LogFactory.getLog(HumanTaskPackageManagementSkeleton.class);

    public DeployedPackagesPaginated listDeployedPackagesPaginated(int page) {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        return null;
    }

    public Task_type0[] listTasksInPackage(String packageName) throws PackageManagementException {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        if (StringUtils.isEmpty((String)packageName)) {
            throw new IllegalArgumentException("The provided package name is empty!");
        }
        try {
            List<SimpleTaskDefinitionInfo> taskDefsInPackage = this.getTenantTaskStore().getTaskConfigurationInfoListForPackage(packageName);
            Task_type0[] taskDefArray = new Task_type0[taskDefsInPackage.size()];
            int i = 0;
            for (SimpleTaskDefinitionInfo taskDefinitionInfo : taskDefsInPackage) {
                taskDefArray[i] = this.createTaskTypeObject(taskDefinitionInfo);
                ++i;
            }
            return taskDefArray;
        }
        catch (Exception ex) {
            String errMsg = "listTasksInPackage operation failed";
            log.error((Object)errMsg, (Throwable)ex);
            throw new PackageManagementException(errMsg, (Throwable)ex);
        }
    }

    public DeployedTaskDefinitionsPaginated listDeployedTaskDefinitionsPaginated(int page) throws PackageManagementException {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        int tPage = page;
        try {
            DeployedTaskDefinitionsPaginated paginatedTaskDefs = new DeployedTaskDefinitionsPaginated();
            if (tPage < 0 || tPage == Integer.MAX_VALUE) {
                tPage = 0;
            }
            int itemsPerPage = 10;
            int startIndexForCurrentPage = tPage * itemsPerPage;
            int endIndexForCurrentPage = (tPage + 1) * itemsPerPage;
            List<SimpleTaskDefinitionInfo> taskConfigs = this.getTenantTaskStore().getTaskConfigurationInfoList();
            int taskDefListSize = taskConfigs.size();
            int pages = (int)Math.ceil((double)taskDefListSize / (double)itemsPerPage);
            paginatedTaskDefs.setPages(pages);
            SimpleTaskDefinitionInfo[] taskDefinitionInfoArray = taskConfigs.toArray(new SimpleTaskDefinitionInfo[taskDefListSize]);
            for (int i = startIndexForCurrentPage; i < endIndexForCurrentPage && i < taskDefListSize; ++i) {
                paginatedTaskDefs.addTaskDefinition(this.createTaskDefObject(taskDefinitionInfoArray[i]));
            }
            return paginatedTaskDefs;
        }
        catch (Exception ex) {
            String errMsg = "listDeployedTaskDefinitionsPaginated operation failed";
            log.error((Object)errMsg, (Throwable)ex);
            throw new PackageManagementException(errMsg, (Throwable)ex);
        }
    }

    public TaskInfoType getTaskInfo(QName taskId) throws PackageManagementException {
        int tenentId = CarbonContext.getCurrentContext().getTenantId();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        TaskInfoType taskInfo = null;
        HumanTaskBaseConfiguration taskConf = HumanTaskServiceComponent.getHumanTaskServer().getTaskStoreManager().getHumanTaskStore(tenentId).getTaskConfiguration(taskId);
        if (taskConf != null) {
            taskInfo = new TaskInfoType();
            taskInfo.setTaskId(taskConf.getName());
            taskInfo.setPackageName(taskConf.getPackageName());
            if (TaskPackageStatus.ACTIVE.equals((Object)taskConf.getPackageStatus())) {
                taskInfo.setStatus(TaskStatusType.ACTIVE);
            } else if (TaskPackageStatus.INACTIVE.equals((Object)taskConf.getPackageStatus())) {
                taskInfo.setStatus(TaskStatusType.INACTIVE);
            } else if (TaskPackageStatus.UNDEPLOYING.equals((Object)taskConf.getPackageStatus())) {
                taskInfo.setStatus(TaskStatusType.UNDEPLOYING);
            }
            taskInfo.setDeploymentError(taskConf.getDeploymentError());
            taskInfo.setErroneous(taskConf.isErroneous());
            if (taskConf instanceof TaskConfiguration) {
                taskInfo.setTaskType(org.wso2.carbon.humantask.skeleton.mgt.services.types.TaskType.TASK);
            } else if (taskConf instanceof NotificationConfiguration) {
                taskInfo.setTaskType(org.wso2.carbon.humantask.skeleton.mgt.services.types.TaskType.NOTIFICATION);
            }
            taskInfo.setDefinitionInfo(this.fillTaskDefinitionInfo(taskConf));
        }
        return taskInfo;
    }

    private TaskDefinitionInfo fillTaskDefinitionInfo(HumanTaskBaseConfiguration taskConf) throws PackageManagementException {
        TaskDefinitionInfo taskDefInfo = new TaskDefinitionInfo();
        taskDefInfo.setTaskName(taskConf.getName());
        HumanTaskDefinition taskDefinition = new HumanTaskDefinition();
        taskDefinition.setExtraElement(this.createTaskDefOMElement(taskConf.getHumanTaskDefinitionFile()));
        taskDefInfo.setDefinition(taskDefinition);
        return taskDefInfo;
    }

    private OMElement createTaskDefOMElement(File humanTaskDefFile) throws PackageManagementException {
        OMElement humanTaskDefinition;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(humanTaskDefFile);
            XMLInputFactory xif = XMLInputFactory.newInstance();
            XMLStreamReader reader = xif.createXMLStreamReader(fis);
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            humanTaskDefinition = builder.getDocumentElement();
            humanTaskDefinition.build();
        }
        catch (XMLStreamException e) {
            String errMsg = "XML stream reader exception: " + humanTaskDefFile.getAbsolutePath();
            log.error((Object)errMsg, (Throwable)e);
            throw new PackageManagementException(errMsg, (Throwable)e);
        }
        catch (FileNotFoundException e) {
            String errMsg = "HT File reading exception: " + humanTaskDefFile.getAbsolutePath();
            log.error((Object)errMsg, (Throwable)e);
            throw new PackageManagementException(errMsg, (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    log.warn((Object)"Cannot close file input stream.", (Throwable)e);
                }
            }
        }
        return humanTaskDefinition;
    }

    private TaskDefinition_type0 createTaskDefObject(SimpleTaskDefinitionInfo taskConfiguration) {
        TaskDefinition_type0 taskDef = new TaskDefinition_type0();
        taskDef.setPackageName(taskConfiguration.getPackageName());
        taskDef.setTaskName(taskConfiguration.getTaskName());
        if (TaskPackageStatus.ACTIVE.equals((Object)taskConfiguration.getPackageStatus())) {
            taskDef.setState(TaskStatusType.ACTIVE);
        } else if (TaskPackageStatus.INACTIVE.equals((Object)taskConfiguration.getPackageStatus())) {
            taskDef.setState(TaskStatusType.INACTIVE);
        } else if (TaskPackageStatus.UNDEPLOYING.equals((Object)taskConfiguration.getPackageStatus())) {
            taskDef.setState(TaskStatusType.UNDEPLOYING);
        }
        taskDef.setDeploymentError(taskConfiguration.getDeploymentError());
        taskDef.setErroneous(taskConfiguration.isErroneous());
        if (TaskType.TASK.equals((Object)taskConfiguration.getTaskType())) {
            taskDef.setType(org.wso2.carbon.humantask.skeleton.mgt.services.types.TaskType.TASK);
        } else if (TaskType.NOTIFICATION.equals((Object)taskConfiguration.getTaskType())) {
            taskDef.setType(org.wso2.carbon.humantask.skeleton.mgt.services.types.TaskType.NOTIFICATION);
        }
        return taskDef;
    }

    private Task_type0 createTaskTypeObject(SimpleTaskDefinitionInfo taskConfiguration) {
        Task_type0 task = new Task_type0();
        task.setName(taskConfiguration.getTaskName());
        if (TaskType.TASK.equals((Object)taskConfiguration.getTaskType())) {
            task.setType(org.wso2.carbon.humantask.skeleton.mgt.services.types.TaskType.TASK);
        } else if (TaskType.NOTIFICATION.equals((Object)taskConfiguration.getTaskType())) {
            task.setType(org.wso2.carbon.humantask.skeleton.mgt.services.types.TaskType.NOTIFICATION);
        }
        task.setErroneous(taskConfiguration.isErroneous());
        task.setDeploymentError(taskConfiguration.getDeploymentError());
        return task;
    }

    public HumanTaskPackageDownloadData downloadHumanTaskPackage(String packageName) throws PackageManagementException {
        int tenentId = CarbonContext.getCurrentContext().getTenantId();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        File humanTaskArchive = this.getTenantTaskStore().getHumanTaskArchiveLocation(packageName);
        if (humanTaskArchive != null) {
            FileDataSource dataSource = new FileDataSource(humanTaskArchive);
            DataHandler handler = new DataHandler((DataSource)dataSource);
            HumanTaskPackageDownloadData data = new HumanTaskPackageDownloadData();
            data.setPackageName(humanTaskArchive.getName());
            data.setPackageFileData(handler);
            return data;
        }
        return null;
    }

    public UndeployStatus_type0 undeployHumanTaskPackage(String packageName) {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            this.getTenantTaskStore().deleteHumanTaskArchive(packageName);
            this.getTenantTaskStore().updateTaskStatusForPackage(packageName, TaskPackageStatus.UNDEPLOYING);
        }
        catch (Exception ex) {
            log.error((Object)"undeployHumanTaskPackage operation failed", (Throwable)ex);
            return UndeployStatus_type0.FAILED;
        }
        return UndeployStatus_type0.SUCCESS;
    }

    private HumanTaskStore getTenantTaskStore() {
        ConfigurationContext configContext = this.getConfigContext();
        int tenantId = MultitenantUtils.getTenantId((ConfigurationContext)configContext);
        HumanTaskServer server = HumanTaskServiceComponent.getHumanTaskServer();
        return server.getTaskStoreManager().getHumanTaskStore(tenantId);
    }
}

