/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.scheduler;

import java.text.SimpleDateFormat;
import org.wso2.carbon.humantask.core.dao.HumanTaskJobDAO;
import org.wso2.carbon.humantask.core.internal.HumanTaskServiceComponent;
import org.wso2.carbon.humantask.core.scheduler.Task;

class Job
extends Task {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    HumanTaskJobDAO jobDAO;

    public Job(long jobId) {
        super(0L);
        this.jobDAO = HumanTaskServiceComponent.getHumanTaskServer().getDaoConnectionFactory().getConnection().createHumanTaskJobDao();
        this.jobDAO.setId(jobId);
    }

    public Job(HumanTaskJobDAO job) {
        this(job.getTime(), job);
    }

    public Job(long when, HumanTaskJobDAO job) {
        super(when);
        this.jobDAO = job;
    }

    public int hashCode() {
        return this.jobDAO.getId().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Job && this.jobDAO.getId().equals(((Job)obj).jobDAO.getId());
    }

    public String toString() {
        SimpleDateFormat f = (SimpleDateFormat)DATE_FORMAT.clone();
        return "Job " + this.jobDAO.getId() + " time: " + f.format(this.schedDate) + " transacted: " + this.jobDAO.isTransacted() + " details: " + this.jobDAO.getDetails();
    }

    public long getJobID() {
        return this.jobDAO.getId();
    }
}

