/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.scheduler;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.humantask.TArgument;
import org.wso2.carbon.humantask.TDeadline;
import org.wso2.carbon.humantask.TEscalation;
import org.wso2.carbon.humantask.TToPart;
import org.wso2.carbon.humantask.TToParts;
import org.wso2.carbon.humantask.core.api.scheduler.Scheduler;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.MessageDAO;
import org.wso2.carbon.humantask.core.dao.OrganizationalEntityDAO;
import org.wso2.carbon.humantask.core.dao.TaskCreationContext;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.engine.HumanTaskException;
import org.wso2.carbon.humantask.core.engine.runtime.ExpressionEvaluationContext;
import org.wso2.carbon.humantask.core.engine.runtime.api.EvaluationContext;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskRuntimeException;
import org.wso2.carbon.humantask.core.internal.HumanTaskServerHolder;
import org.wso2.carbon.humantask.core.internal.HumanTaskServiceComponent;
import org.wso2.carbon.humantask.core.store.HumanTaskBaseConfiguration;
import org.wso2.carbon.humantask.core.store.TaskConfiguration;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.UserRealm;

public class JobProcessorImpl
implements Scheduler.JobProcessor {
    private static Log log = LogFactory.getLog(JobProcessorImpl.class);

    public void onScheduledJob(Scheduler.JobInfo jobInfo) throws Scheduler.JobProcessorException {
        log.info((Object)("Executing Deadline: " + jobInfo.getName() + " :: " + jobInfo.getTaskId() + " :: " + jobInfo.getJobId() + " :: " + (Object)((Object)jobInfo.getType())));
        try {
            switch (jobInfo.getType()) {
                case TIMER_DEADLINE: {
                    this.executeDeadline(jobInfo.getTaskId(), jobInfo.getName());
                    break;
                }
                case TIMER_SUSPEND: {
                    this.executeSuspend(jobInfo.getTaskId());
                }
            }
        }
        catch (Exception ex) {
            throw new Scheduler.JobProcessorException(ex);
        }
    }

    private void executeSuspend(long taskId) {
        log.info((Object)("ON SUSPEND: task : " + taskId));
    }

    private void executeDeadline(long taskId, String name) throws HumanTaskException {
        log.info((Object)("ON DEADLINE:  : now: " + new Date()));
        TaskDAO task = HumanTaskServiceComponent.getHumanTaskServer().getDaoConnectionFactory().getConnection().getTask(taskId);
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(task.getTenantId().intValue());
        TaskConfiguration taskConf = (TaskConfiguration)HumanTaskServiceComponent.getHumanTaskServer().getTaskStoreManager().getHumanTaskStore(task.getTenantId()).getTaskConfiguration(QName.valueOf(task.getName()));
        TDeadline deadline = taskConf.getDeadline(name);
        ExpressionEvaluationContext evalCtx = new ExpressionEvaluationContext(task, taskConf);
        ArrayList<TEscalation> validEscalations = new ArrayList<TEscalation>();
        boolean reassingnmentAdded = false;
        for (TEscalation escalation : deadline.getEscalationArray()) {
            if (!escalation.isSetCondition()) {
                if (escalation.isSetReassignment() && !reassingnmentAdded) {
                    reassingnmentAdded = true;
                } else if (escalation.isSetReassignment()) continue;
                validEscalations.add(escalation);
                continue;
            }
            if (!this.evaluateCondition(escalation.getCondition().newCursor().getTextValue(), escalation.getCondition().getExpressionLanguage() == null ? taskConf.getExpressionLanguage() : escalation.getCondition().getExpressionLanguage(), evalCtx)) continue;
            if (escalation.isSetReassignment() && !reassingnmentAdded) {
                reassingnmentAdded = true;
            } else if (escalation.isSetReassignment()) continue;
            validEscalations.add(escalation);
        }
        for (TEscalation escalation : validEscalations) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Escalation: " + escalation.getName()));
            }
            if (escalation.isSetLocalNotification() || escalation.isSetNotification()) {
                QName qName = escalation.isSetLocalNotification() ? escalation.getLocalNotification().getReference() : new QName(taskConf.getName().getNamespaceURI(), escalation.getNotification().getName());
                HumanTaskBaseConfiguration notificationConfiguration = HumanTaskServiceComponent.getHumanTaskServer().getTaskStoreManager().getHumanTaskStore(task.getTenantId()).getTaskConfiguration(qName);
                TaskCreationContext taskContext = new TaskCreationContext();
                taskContext.setTaskConfiguration(notificationConfiguration);
                taskContext.setTenantId(task.getTenantId());
                taskContext.setPeopleQueryEvaluator(HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getPeopleQueryEvaluator());
                HashMap<String, Element> tempBodyParts = new HashMap<String, Element>();
                HashMap<String, Element> tempHeaderParts = new HashMap<String, Element>();
                QName tempName = null;
                TToParts toParts = escalation.getToParts();
                if (toParts == null) {
                    MessageDAO msg = task.getInputMessage();
                    tempName = msg.getName();
                    for (Map.Entry<String, Element> partEntry : msg.getBodyParts().entrySet()) {
                        tempBodyParts.put(partEntry.getKey(), partEntry.getValue());
                    }
                    for (Map.Entry<String, Element> partEntry : msg.getHeaderParts().entrySet()) {
                        tempHeaderParts.put(partEntry.getKey(), partEntry.getValue());
                    }
                    taskContext.setMessageBodyParts(tempBodyParts);
                    taskContext.setMessageHeaderParts(tempHeaderParts);
                    taskContext.setMessageName(tempName);
                } else {
                    for (TToPart toPart : toParts.getToPartArray()) {
                        if (!notificationConfiguration.isValidPart(toPart.getName())) {
                            String errMsg = "The part: " + toPart.getName() + " is not available" + " in the corresponding WSDL message";
                            log.error((Object)errMsg);
                            throw new RuntimeException(errMsg);
                        }
                        String expLang = toPart.getExpressionLanguage() == null ? taskConf.getExpressionLanguage() : toPart.getExpressionLanguage();
                        Node nodePart = HumanTaskServerHolder.getInstance().getHtServer().getTaskEngine().getExpressionLanguageRuntime(expLang).evaluateAsPart(toPart.newCursor().getTextValue(), toPart.getName(), evalCtx);
                        tempBodyParts.put(toPart.getName(), (Element)nodePart);
                    }
                }
                taskContext.setMessageBodyParts(tempBodyParts);
                taskContext.setMessageHeaderParts(tempHeaderParts);
                taskContext.setMessageName(tempName);
                HumanTaskServerHolder.getInstance().getHtServer().getTaskEngine().getDaoConnectionFactory().getConnection().createTask(taskContext);
                continue;
            }
            if (escalation.getReassignment().getPotentialOwners().isSetFrom()) {
                escalation.getReassignment().getPotentialOwners().getFrom().getArgumentArray();
                String roleName = null;
                for (TArgument argument : escalation.getReassignment().getPotentialOwners().getFrom().getArgumentArray()) {
                    if (!"role".equals(argument.getName())) continue;
                    roleName = argument.newCursor().getTextValue().trim();
                }
                if (roleName == null) {
                    String errMsg = "Value for argument name 'role' is expected.";
                    log.error((Object)errMsg);
                    throw new Scheduler.JobProcessorException(errMsg);
                }
                if (!this.isExistingRole(roleName, task.getTenantId())) {
                    log.warn((Object)("Role name " + roleName + " does not exist for tenant id" + task.getTenantId()));
                }
                ArrayList<OrganizationalEntityDAO> orgEntities = new ArrayList<OrganizationalEntityDAO>();
                OrganizationalEntityDAO orgEntity = HumanTaskServiceComponent.getHumanTaskServer().getDaoConnectionFactory().getConnection().createNewOrgEntityObject(roleName, OrganizationalEntityDAO.OrganizationalEntityType.GROUP);
                orgEntities.add(orgEntity);
                task.replaceOrgEntitiesForLogicalPeopleGroup(GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS, orgEntities);
                continue;
            }
            String errMsg = "From element is expected inside the assignment";
            log.error((Object)errMsg);
            throw new Scheduler.JobProcessorException(errMsg);
        }
    }

    private boolean evaluateCondition(String exp, String expLang, EvaluationContext evalCtx) {
        return HumanTaskServerHolder.getInstance().getHtServer().getTaskEngine().getExpressionLanguageRuntime(expLang).evaluateAsBoolean(exp, evalCtx);
    }

    private boolean isExistingRole(String roleName, int tenantId) {
        RegistryService registryService = HumanTaskServiceComponent.getRegistryService();
        try {
            UserRealm userRealm = registryService.getUserRealm(tenantId);
            return userRealm.getUserStoreManager().isExistingRole(roleName);
        }
        catch (Exception e) {
            throw new HumanTaskRuntimeException("Cannot retrieve user realm for tenantId :" + tenantId, e);
        }
    }
}

