/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.scheduler;

import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.wso2.carbon.humantask.core.scheduler.JobComparatorByDate;
import org.wso2.carbon.humantask.core.scheduler.Task;
import org.wso2.carbon.humantask.core.scheduler.TaskRunner;
import org.wso2.carbon.humantask.core.utils.CollectionsX;
import org.wso2.carbon.humantask.core.utils.MemberOfFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SchedulerThread
implements Runnable {
    private static final int TODO_QUEUE_INITIAL_CAPACITY = 200;
    private PriorityBlockingQueue<Task> todo;
    private ReentrantLock lock = new ReentrantLock();
    private Condition activity = this.lock.newCondition();
    private volatile boolean done;
    private TaskRunner taskrunner;
    private Thread thread;

    SchedulerThread(TaskRunner runner) {
        this.todo = new PriorityBlockingQueue<Task>(200, new JobComparatorByDate());
        this.taskrunner = runner;
    }

    void start() {
        if (this.thread != null) {
            return;
        }
        this.done = false;
        this.thread = new Thread((Runnable)this, "HTScheduler");
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        if (this.thread == null) {
            return;
        }
        this.done = true;
        this.lock.lock();
        try {
            this.activity.signal();
        }
        finally {
            this.lock.unlock();
        }
        while (this.thread != null) {
            try {
                this.thread.join();
                this.thread = null;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(Task task) {
        this.lock.lock();
        try {
            this.todo.add(task);
            this.activity.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dequeue(Task task) {
        this.lock.lock();
        try {
            this.todo.remove(task);
            this.activity.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        return this.todo.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.done) {
            this.lock.lock();
            try {
                long nextjob = this.nextJobTime();
                while (nextjob > 0L && !this.done) {
                    this.activity.await(nextjob, TimeUnit.MILLISECONDS);
                    nextjob = this.nextJobTime();
                }
                if (this.done || nextjob != 0L) continue;
                Task task = this.todo.take();
                this.taskrunner.runTask(task);
            }
            catch (InterruptedException interruptedException) {}
            continue;
            finally {
                this.lock.unlock();
            }
        }
    }

    private long nextJobTime() {
        assert (this.lock.isLocked());
        Task job = this.todo.peek();
        if (job == null) {
            return Long.MAX_VALUE;
        }
        return Math.max(0L, job.schedDate - System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTasks(final Class<? extends Task> tasktype) {
        this.lock.lock();
        try {
            CollectionsX.removeIf(this.todo, new MemberOfFunction<Task>(){

                @Override
                public boolean isMember(Task o) {
                    return tasktype.isAssignableFrom(o.getClass());
                }
            });
        }
        finally {
            this.lock.unlock();
        }
    }
}

