/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.scheduler;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.helpers.AbsoluteTimeDateFormat;
import org.wso2.carbon.humantask.core.api.scheduler.InvalidJobsInDbException;
import org.wso2.carbon.humantask.core.api.scheduler.InvalidUpdateRequestException;
import org.wso2.carbon.humantask.core.api.scheduler.Scheduler;
import org.wso2.carbon.humantask.core.dao.HumanTaskDAOConnection;
import org.wso2.carbon.humantask.core.dao.HumanTaskJobDAO;
import org.wso2.carbon.humantask.core.engine.HumanTaskException;
import org.wso2.carbon.humantask.core.internal.HumanTaskServiceComponent;
import org.wso2.carbon.humantask.core.scheduler.Job;
import org.wso2.carbon.humantask.core.scheduler.SchedulerThread;
import org.wso2.carbon.humantask.core.scheduler.Task;
import org.wso2.carbon.humantask.core.scheduler.TaskRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleScheduler
implements Scheduler,
TaskRunner {
    private static Log log = LogFactory.getLog(SimpleScheduler.class);
    private static final long immediateInterval = 30000L;
    private final long nearFutureInterval = 60000L;
    private ExecutorService exec;
    private String nodeId;
    private static final int todoLimit = 10000;
    private volatile Scheduler.JobProcessor jobProcessor;
    private SchedulerThread todo;
    private CopyOnWriteArraySet<String> knownNodes = new CopyOnWriteArraySet();
    private ConcurrentHashMap<String, Long> lastHeartBeat = new ConcurrentHashMap();
    private ConcurrentHashMap<Long, Long> outstandingJobs = new ConcurrentHashMap();
    private ConcurrentHashMap<Long, Long> processedSinceLastLoadTask = new ConcurrentHashMap();
    private boolean running;
    private AtomicLong nextUpgrade = new AtomicLong();
    private TransactionManager transactionManager;

    public SimpleScheduler(String nodeId) {
        this.nodeId = nodeId;
        this.todo = new SchedulerThread(this);
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public void runTask(final Task task) {
        if (task instanceof Job) {
            Job job = (Job)task;
            this.runJob(job);
        } else if (task instanceof SchedulerTask) {
            this.exec.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        ((SchedulerTask)task).run();
                    }
                    catch (Exception ex) {
                        log.error((Object)"Error during SchedulerTask execution", (Throwable)ex);
                    }
                    return null;
                }
            });
        }
    }

    protected void runJob(Job job) {
        this.exec.submit(new RunJob(job, this.jobProcessor));
    }

    @Override
    public boolean isTransacted() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doLoadImmediate() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"LOAD IMMEDIATE started");
        }
        if (this.outstandingJobs.size() > 5000) {
            return true;
        }
        ArrayList<Job> jobs = new ArrayList<Job>();
        try {
            int tps = 100;
            final int batch = Math.min((int)(30000L * (long)tps / 1000L), 10000 - this.outstandingJobs.size());
            if (batch <= 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Max capacity reached: " + this.outstandingJobs.size() + " jobs dispacthed i.e. queued or being executed"));
                }
                boolean bl = true;
                return bl;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Started loading " + batch + " jobs from db"));
            }
            List<HumanTaskJobDAO> htJobs = this.execTransaction(new Callable<List<HumanTaskJobDAO>>(){

                @Override
                public List<HumanTaskJobDAO> call() throws Exception {
                    return SimpleScheduler.this.getConnection().dequeueImmediate(SimpleScheduler.this.nodeId, System.currentTimeMillis() + 30000L, batch);
                }
            });
            for (HumanTaskJobDAO htJob : htJobs) {
                jobs.add(new Job(htJob));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("loaded " + jobs.size() + " jobs from db"));
            }
            long warningDelay = 0L;
            long delayedTime = System.currentTimeMillis() - warningDelay;
            int delayedCount = 0;
            AbsoluteTimeDateFormat f = new AbsoluteTimeDateFormat();
            for (Job j : jobs) {
                boolean runningLate;
                if (this.outstandingJobs.size() >= 10000) {
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("Max capacity reached: " + this.outstandingJobs.size() + " jobs dispacthed i.e. queued or being executed"));
                    break;
                }
                boolean bl = runningLate = j.schedDate <= delayedTime;
                if (runningLate) {
                    ++delayedCount;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("todo.enqueue job from db: " + j.getJobID() + " for " + j.schedDate + "(" + f.format((Object)j.schedDate) + ") " + (runningLate ? " delayed=true" : "")));
                }
                this.enqueue(j);
            }
            if (delayedCount > 0) {
                log.warn((Object)("Dispatching jobs with more than " + warningDelay / 60000L + " minutes delay. Either the server was down for some time or the job " + "load is greater than available capacity"));
            }
            this.processedSinceLastLoadTask.clear();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            log.error((Object)"Error loading immediate jobs from database.", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)"LOAD IMMEDIATE complete");
            }
        }
    }

    void enqueue(Job job) {
        if (this.processedSinceLastLoadTask.get(job.getJobID()) == null) {
            if (this.outstandingJobs.putIfAbsent(job.getJobID(), job.schedDate) == null) {
                if (job.schedDate <= System.currentTimeMillis()) {
                    this.runTask(job);
                } else {
                    this.todo.enqueue(job);
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Job " + job.getJobID() + " is being processed (outstanding job)"));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Job " + job.getJobID() + " is being processed (processed since last load)"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doUpgrade() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UPGRADE started");
        }
        final ArrayList<String> nodes = new ArrayList<String>(this.knownNodes);
        nodes.add(this.nodeId);
        Collections.sort(nodes);
        final long maxtime = System.currentTimeMillis() + 60000L;
        try {
            final int numNodes = nodes.size();
            boolean bl = this.execTransaction(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    for (int i = 0; i < numNodes; ++i) {
                        String node = (String)nodes.get(i);
                        SimpleScheduler.this.getConnection().updateAssignToNode(node, i, numNodes, maxtime);
                    }
                    return true;
                }
            });
            return bl;
        }
        catch (Exception ex) {
            log.error((Object)"Database error upgrading jobs.", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)"UPGRADE complete");
            }
        }
    }

    @Override
    public void setJobProcessor(Scheduler.JobProcessor processor) {
        this.jobProcessor = processor;
    }

    private void addTodoList(Job job) {
        this.enqueue(job);
    }

    @Override
    public void start() {
        if (this.running) {
            return;
        }
        if (Boolean.parseBoolean(System.getProperty("org.wso2.carbon.humantask.scheduler.deleteJobsOnStart", "false"))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"DeleteJobsOnStart");
            }
            try {
                this.execTransaction(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        return SimpleScheduler.this.getConnection().deleteAllJobs();
                    }
                });
            }
            catch (Exception ex) {
                log.error((Object)"", (Throwable)ex);
                throw new RuntimeException("", ex);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"no DeleteJobsOnStart");
        }
        if (this.exec == null) {
            this.exec = Executors.newCachedThreadPool();
        }
        this.todo.clearTasks(UpgradeJobsTask.class);
        this.todo.clearTasks(LoadImmediateTask.class);
        this.processedSinceLastLoadTask.clear();
        this.outstandingJobs.clear();
        this.knownNodes.clear();
        try {
            List<String> nodeList = this.execTransaction(new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    return SimpleScheduler.this.getConnection().getNodeIds();
                }
            });
            this.knownNodes.addAll(nodeList);
        }
        catch (Exception ex) {
            log.error((Object)"Error retrieving node list.", (Throwable)ex);
            throw new RuntimeException("Error retrieving node list.", ex);
        }
        long now = System.currentTimeMillis();
        for (String s : this.knownNodes) {
            this.lastHeartBeat.put(s, now);
        }
        this.todo.enqueue(new UpgradeJobsTask(now));
        this.todo.enqueue(new LoadImmediateTask(now + 1000L));
        this.todo.start();
        this.running = true;
    }

    @Override
    public void stop() {
        if (!this.running) {
            return;
        }
        this.todo.stop();
        this.todo.clearTasks(UpgradeJobsTask.class);
        this.todo.clearTasks(LoadImmediateTask.class);
        this.processedSinceLastLoadTask.clear();
        this.outstandingJobs.clear();
        this.running = false;
    }

    @Override
    public void shutdown() {
        this.stop();
        this.jobProcessor = null;
        this.todo = null;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.exec = executorService;
    }

    @Override
    public long scheduleJob(long now, long scheduledTime, Scheduler.JobType type, String details, long taskId, String name) {
        boolean immediate = scheduledTime <= now + 30000L;
        boolean nearfuture = !immediate && scheduledTime <= now + 60000L;
        HumanTaskJobDAO tempJob = HumanTaskServiceComponent.getHumanTaskServer().getDaoConnectionFactory().getConnection().createHumanTaskJobDao();
        tempJob.setTime(scheduledTime);
        tempJob.setTransacted(false);
        tempJob.setDetails(details);
        tempJob.setTaskId(taskId);
        tempJob.setName(name);
        tempJob.setType(type.toString());
        if (immediate) {
            tempJob.setNodeId(this.nodeId);
            tempJob.setScheduled(true);
            this.getEntityManager().persist((Object)tempJob);
            if (this.outstandingJobs.size() < 10000) {
                this.addTodoList(new Job(tempJob));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("scheduled immediate job: " + tempJob.getId()));
            }
        } else if (nearfuture) {
            tempJob.setNodeId(this.nodeId);
            tempJob.setScheduled(false);
            this.getEntityManager().persist((Object)tempJob);
            if (log.isDebugEnabled()) {
                log.debug((Object)("scheduled near-future job: " + tempJob.getId()));
            }
        } else {
            tempJob.setNodeId(null);
            tempJob.setScheduled(false);
            this.getEntityManager().persist((Object)tempJob);
            if (log.isDebugEnabled()) {
                log.debug((Object)("scheduled far-future job: " + tempJob.getId()));
            }
        }
        return tempJob.getId();
    }

    public void cancelJob(long jobId) {
        this.todo.dequeue(new Job(jobId));
        this.outstandingJobs.remove(jobId);
    }

    @Override
    public void cancelJobsForTask(long taskId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cancelling jobs for task: " + taskId));
        }
        List<Long> jobIds = this.getConnection().deleteJobsForTask(taskId);
        for (Long jobId : jobIds) {
            this.cancelJob(jobId);
        }
    }

    @Override
    public void updateJob(Long taskId, String name, Long scheduledTime) throws InvalidJobsInDbException, InvalidUpdateRequestException {
        long now = System.currentTimeMillis();
        if (now > scheduledTime) {
            String errMessage = "Current time: " + now + " > request time: " + scheduledTime;
            throw new InvalidUpdateRequestException(errMessage);
        }
        boolean immediate = scheduledTime <= now + 30000L;
        boolean nearfuture = !immediate && scheduledTime <= now + 60000L;
        Long jobId = this.getConnection().updateJob(taskId, name, immediate, nearfuture, this.nodeId, scheduledTime);
        if (jobId > -1L) {
            this.todo.dequeue(new Job(jobId));
            this.outstandingJobs.remove(jobId);
            ParameterizedType genericSuperClass = (ParameterizedType)this.getConnection().getClass().getGenericSuperclass();
            Class entityClass = (Class)genericSuperClass.getActualTypeArguments()[0];
            HumanTaskJobDAO updatedJob = (HumanTaskJobDAO)this.getEntityManager().find(entityClass, (Object)jobId);
            this.getEntityManager().refresh((Object)updatedJob);
            if (immediate) {
                this.addTodoList(new Job(updatedJob));
            } else if (nearfuture) {
                this.todo.clearTasks(LoadImmediateTask.class);
                this.todo.dequeue(new Job(jobId));
                this.outstandingJobs.remove(jobId);
                this.todo.enqueue(new LoadImmediateTask(System.currentTimeMillis() + 1000L));
            } else {
                this.todo.clearTasks(UpgradeJobsTask.class);
                this.todo.enqueue(new UpgradeJobsTask(System.currentTimeMillis() + 1000L));
            }
        }
    }

    private EntityManager getEntityManager() {
        return this.getConnection().getEntityManager();
    }

    private HumanTaskDAOConnection getConnection() {
        return HumanTaskServiceComponent.getHumanTaskServer().getDaoConnectionFactory().getConnection();
    }

    @Override
    public <T> T execTransaction(Callable<T> transaction) throws Exception {
        return this.execTransaction(transaction, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public <T> T execTransaction(Callable<T> transaction, int timeout) throws Exception {
        boolean existingTransaction;
        TransactionManager txm = this.transactionManager;
        if (txm == null) {
            throw new HumanTaskException("Cannot locate the transaction manager; the server might be shutting down.");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout must be positive, received: " + timeout);
        }
        try {
            existingTransaction = txm.getTransaction() != null;
        }
        catch (Exception ex) {
            String errMsg = "Internal Error, could not get current transaction.";
            throw new HumanTaskException(errMsg, ex);
        }
        if (existingTransaction) {
            return transaction.call();
        }
        Exception ex = null;
        this.transactionManager.setTransactionTimeout(timeout);
        if (log.isDebugEnabled() && timeout != 0) {
            log.debug((Object)("Custom transaction timeout: " + timeout));
        }
        try {
            T e2222;
            block32: {
                block30: {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Beginning a new transaction");
                        }
                        txm.begin();
                    }
                    catch (Exception e2222) {
                        String errMsg = "Internal Error, could not begin transaction.";
                        throw new HumanTaskException(errMsg, e2222);
                    }
                    ex = null;
                    e2222 = transaction.call();
                    if (ex != null) break block30;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Committing on " + txm + "..."));
                    }
                    try {
                        txm.commit();
                    }
                    catch (Exception e23) {
                        ex = e23;
                    }
                    break block32;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Rollbacking on " + txm + "..."));
                }
                txm.rollback();
            }
            return e2222;
            catch (Exception e3) {
                try {
                    ex = e3;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ex == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Committing on " + txm + "..."));
                        }
                        try {
                            txm.commit();
                        }
                        catch (Exception e24) {
                            ex = e24;
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Rollbacking on " + txm + "..."));
                        }
                        txm.rollback();
                    }
                }
            }
        }
        finally {
            this.transactionManager.setTransactionTimeout(0);
        }
        throw ex;
    }

    private class UpgradeJobsTask
    extends SchedulerTask {
        UpgradeJobsTask(long schedDate) {
            super(schedDate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long ctime = System.currentTimeMillis();
            long ntime = SimpleScheduler.this.nextUpgrade.get();
            if (log.isDebugEnabled()) {
                log.debug((Object)("UPGRADE task for time: " + this.schedDate + " fired at " + ctime));
            }
            if (SimpleScheduler.this.nextUpgrade.get() > System.currentTimeMillis()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("UPGRADE skipped -- wait another " + (ntime - ctime) + "ms"));
                }
                SimpleScheduler.this.todo.enqueue(new UpgradeJobsTask(ntime));
                return;
            }
            boolean success = false;
            try {
                success = SimpleScheduler.this.doUpgrade();
            }
            catch (Throwable throwable) {
                long future = System.currentTimeMillis() + (success ? 30000L : 1000L);
                SimpleScheduler.this.nextUpgrade.set(future);
                SimpleScheduler.this.todo.enqueue(new UpgradeJobsTask(future));
                log.debug((Object)("UPGRADE completed, success = " + success + "; next time in " + (future - ctime) + "ms"));
                throw throwable;
            }
            long future = System.currentTimeMillis() + (success ? 30000L : 1000L);
            SimpleScheduler.this.nextUpgrade.set(future);
            SimpleScheduler.this.todo.enqueue(new UpgradeJobsTask(future));
            log.debug((Object)("UPGRADE completed, success = " + success + "; next time in " + (future - ctime) + "ms"));
        }
    }

    private class LoadImmediateTask
    extends SchedulerTask {
        LoadImmediateTask(long schedDate) {
            super(schedDate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean success = false;
            try {
                success = SimpleScheduler.this.doLoadImmediate();
            }
            finally {
                if (success) {
                    SimpleScheduler.this.todo.enqueue(new LoadImmediateTask(System.currentTimeMillis() + 27000L));
                } else {
                    SimpleScheduler.this.todo.enqueue(new LoadImmediateTask(System.currentTimeMillis() + 1000L));
                }
            }
        }
    }

    private abstract class SchedulerTask
    extends Task
    implements Runnable {
        SchedulerTask(long schedDate) {
            super(schedDate);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RunJob
    implements Callable<Void> {
        private final Job job;
        private final Scheduler.JobProcessor processor;

        RunJob(Job job, Scheduler.JobProcessor processor) {
            this.job = job;
            this.processor = processor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                final Scheduler.JobInfo jobInfo = new Scheduler.JobInfo(this.job.getJobID(), this.job.jobDAO.getTime(), this.job.jobDAO.getTaskId(), this.job.jobDAO.getName(), this.job.jobDAO.getType());
                try {
                    SimpleScheduler.this.execTransaction(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            ((RunJob)RunJob.this).job.jobDAO = (HumanTaskJobDAO)SimpleScheduler.this.getConnection().getEntityManager().find(((RunJob)RunJob.this).job.jobDAO.getClass(), (Object)((RunJob)RunJob.this).job.jobDAO.getId());
                            SimpleScheduler.this.getConnection().getEntityManager().remove((Object)((RunJob)RunJob.this).job.jobDAO);
                            RunJob.this.processor.onScheduledJob(jobInfo);
                            return null;
                        }
                    });
                }
                catch (Exception ex) {
                    log.error((Object)("Error while processing a persisted job" + this.job), (Throwable)ex);
                }
                Void void_ = null;
                return void_;
            }
            finally {
                SimpleScheduler.this.processedSinceLastLoadTask.put(this.job.getJobID(), this.job.schedDate);
                SimpleScheduler.this.outstandingJobs.remove(this.job.getJobID());
            }
        }
    }
}

