/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.store;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.axis2.engine.AxisConfiguration;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.wso2.carbon.bpel.common.config.EndpointConfiguration;
import org.wso2.carbon.humantask.HumanInteractionsDocument;
import org.wso2.carbon.humantask.TDeadlines;
import org.wso2.carbon.humantask.TPresentationElements;
import org.wso2.carbon.humantask.TPriorityExpr;
import org.wso2.carbon.humantask.core.dao.TaskPackageStatus;
import org.wso2.carbon.humantask.core.utils.HumanTaskNamespaceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HumanTaskBaseConfiguration {
    private String targetNamespace;
    private Definition wsdl;
    private HumanInteractionsDocument humanInteractionsDocument;
    private String defaultExpressionLanguage = "urn:wsht:sublang:xpath2.0";
    private HumanTaskNamespaceContext namespaceContext = new HumanTaskNamespaceContext();
    private String humanTaskArtifactName;
    private boolean task;
    private AxisConfiguration tenantAxisConf;
    private String packageName;
    private File humanTaskDefinitionFile;
    private List<EndpointConfiguration> endpointConfigs = new ArrayList<EndpointConfiguration>();
    private TaskPackageStatus packageStatus = TaskPackageStatus.ACTIVE;
    private boolean isErroneous = false;
    private String deploymentError = "NONE";

    public HumanTaskBaseConfiguration() {
    }

    public HumanTaskBaseConfiguration(HumanInteractionsDocument humanInteractionsDocument, String targetNamespace, String humanTaskArtifactName, AxisConfiguration tenantAxisConf, boolean task, String packageName, File humanTaskDefinitionFile) {
        this.humanInteractionsDocument = humanInteractionsDocument;
        this.targetNamespace = targetNamespace;
        this.humanTaskArtifactName = humanTaskArtifactName;
        this.task = task;
        this.tenantAxisConf = tenantAxisConf;
        this.packageName = packageName;
        this.humanTaskDefinitionFile = humanTaskDefinitionFile;
        this.packageStatus = TaskPackageStatus.ACTIVE;
        if (humanInteractionsDocument.getHumanInteractions().getExpressionLanguage() != null) {
            this.defaultExpressionLanguage = humanInteractionsDocument.getHumanInteractions().getExpressionLanguage().trim();
        }
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getExpressionLanguage() {
        return this.defaultExpressionLanguage;
    }

    public HumanTaskNamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public void setNamespaceContext(HumanTaskNamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    public Definition getWSDL() {
        return this.wsdl;
    }

    public void setWSDL(Definition wsdl) {
        this.wsdl = wsdl;
    }

    public boolean isTask() {
        return this.task;
    }

    public abstract QName getPortType();

    public abstract String getOperation();

    public abstract QName getName();

    public abstract QName getServiceName();

    public abstract String getPortName();

    public abstract TPriorityExpr getPriorityExpression();

    protected Definition findWSDLDefinition(List<Definition> wsdls, QName portType, String operation) {
        for (Definition wsdlDef : wsdls) {
            PortType port = wsdlDef.getPortType(portType);
            if (port == null || port.getOperation(operation, null, null) == null) continue;
            return wsdlDef;
        }
        return null;
    }

    public static void populateNamespace(Element root, HumanTaskNamespaceContext nsCtx) {
        if (root == null) {
            throw new IllegalArgumentException("Task element cannot be null.");
        }
        if (root.getParentNode() != null && root.getParentNode().getNodeType() == 1) {
            HumanTaskBaseConfiguration.populateNamespace((Element)root.getParentNode(), nsCtx);
        }
        NamedNodeMap attributes = root.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            if (!attribute.getName().startsWith("xmlns:")) continue;
            String prefix = attribute.getLocalName();
            String uri = attribute.getValue();
            nsCtx.register(prefix, uri);
        }
        Attr defaultNs = root.getAttributeNode("xmlns");
        if (defaultNs != null) {
            nsCtx.register("", defaultNs.getTextContent());
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    public abstract TPresentationElements getPresentationElements();

    public abstract TDeadlines getDeadlines();

    public abstract ConfigurationType getConfigurationType();

    public boolean isValidPart(String partName) {
        return this.wsdl.getPortType(this.getPortType()).getOperation(this.getOperation(), null, null).getInput().getMessage().getPart(partName) != null;
    }

    public File getHumanTaskDefinitionFile() {
        return this.humanTaskDefinitionFile;
    }

    public void setHumanTaskDefinitionFile(File humanTaskDefinitionFile) {
        this.humanTaskDefinitionFile = humanTaskDefinitionFile;
    }

    public TaskPackageStatus getPackageStatus() {
        return this.packageStatus;
    }

    public void setPackageStatus(TaskPackageStatus packageStatus) {
        this.packageStatus = packageStatus;
    }

    public boolean isErroneous() {
        return this.isErroneous;
    }

    public void setErroneous(boolean erroneous) {
        this.isErroneous = erroneous;
    }

    public String getDeploymentError() {
        return this.deploymentError;
    }

    public void setDeploymentError(String deploymentError) {
        this.deploymentError = deploymentError;
    }

    public EndpointConfiguration getEndpointConfiguration(String serviceName, String portName) {
        for (EndpointConfiguration endpointConfig : this.endpointConfigs) {
            if (!serviceName.equals(endpointConfig.getServiceName()) || !portName.equals(endpointConfig.getServicePort())) continue;
            return endpointConfig;
        }
        return null;
    }

    public void addEndpointConfiguration(EndpointConfiguration endpointConfig) {
        this.endpointConfigs.add(endpointConfig);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConfigurationType {
        TASK,
        NOTIFICATION;

    }
}

