/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.store;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import javax.wsdl.Definition;
import javax.wsdl.OperationType;
import javax.wsdl.xml.WSDLLocator;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.wso2.carbon.bpel.common.ServiceConfigurationUtil;
import org.wso2.carbon.bpel.common.config.EndpointConfiguration;
import org.wso2.carbon.humantask.TNotification;
import org.wso2.carbon.humantask.TTask;
import org.wso2.carbon.humantask.core.dao.TaskPackageStatus;
import org.wso2.carbon.humantask.core.deployment.DeploymentUtil;
import org.wso2.carbon.humantask.core.deployment.HumanTaskDeploymentException;
import org.wso2.carbon.humantask.core.deployment.HumanTaskDeploymentUnit;
import org.wso2.carbon.humantask.core.deployment.SimpleTaskDefinitionInfo;
import org.wso2.carbon.humantask.core.engine.HumanTaskEngine;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskRuntimeException;
import org.wso2.carbon.humantask.core.integration.AxisHumanTaskMessageReceiver;
import org.wso2.carbon.humantask.core.integration.CallBackServiceImpl;
import org.wso2.carbon.humantask.core.integration.HumanTaskSchemaURIResolver;
import org.wso2.carbon.humantask.core.integration.HumanTaskWSDLLocator;
import org.wso2.carbon.humantask.core.internal.HumanTaskServiceComponent;
import org.wso2.carbon.humantask.core.store.HumanTaskBaseConfiguration;
import org.wso2.carbon.humantask.core.store.NotificationConfiguration;
import org.wso2.carbon.humantask.core.store.TaskConfiguration;
import org.wso2.carbon.utils.FileManipulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HumanTaskStore {
    private static final Log log = LogFactory.getLog(HumanTaskStore.class);
    private int tenantId;
    private ConfigurationContext configContext;
    private List<HumanTaskBaseConfiguration> taskConfigurations = new ArrayList<HumanTaskBaseConfiguration>();
    private File humanTaskDeploymentRepo;

    public HumanTaskStore(int tenantId, ConfigurationContext configContext) {
        this.tenantId = tenantId;
        this.configContext = configContext;
    }

    public void deploy(HumanTaskDeploymentUnit humanTaskDU) throws HumanTaskDeploymentException {
        TNotification[] notifications;
        TTask[] tasks = humanTaskDU.getTasks();
        if (tasks != null) {
            for (TTask task : tasks) {
                QName taskQName = new QName(humanTaskDU.getNamespace(), task.getName());
                TaskConfiguration taskConf = new TaskConfiguration(task, humanTaskDU.getTaskServiceInfo(taskQName), humanTaskDU.getHumanInteractionsDefinition(), humanTaskDU.getWSDLs(), humanTaskDU.getNamespace(), humanTaskDU.getName(), this.getTenantAxisConfig(), humanTaskDU.getName(), humanTaskDU.getHumanTaskDefinitionFile());
                this.taskConfigurations.add(taskConf);
                if (taskConf.isErroneous()) continue;
                this.deploy(taskConf);
                this.createCallBackService(taskConf);
            }
        }
        if ((notifications = humanTaskDU.getNotifications()) != null) {
            for (TNotification notification : notifications) {
                QName notificationQName = new QName(humanTaskDU.getNamespace(), notification.getName());
                NotificationConfiguration notificationConf = new NotificationConfiguration(notification, humanTaskDU.getNotificationServiceInfo(notificationQName), humanTaskDU.getHumanInteractionsDefinition(), humanTaskDU.getWSDLs(), humanTaskDU.getNamespace(), humanTaskDU.getName(), this.getTenantAxisConfig(), humanTaskDU.getName(), humanTaskDU.getHumanTaskDefinitionFile());
                this.taskConfigurations.add(notificationConf);
                if (notificationConf.isErroneous()) continue;
                this.deploy(notificationConf);
            }
        }
        for (TNotification inlineNotification : humanTaskDU.getInlineNotifications()) {
            QName notificationQName = new QName(humanTaskDU.getNamespace(), inlineNotification.getName());
            NotificationConfiguration notificationConf = new NotificationConfiguration(inlineNotification, humanTaskDU.getNotificationServiceInfo(notificationQName), humanTaskDU.getHumanInteractionsDefinition(), humanTaskDU.getWSDLs(), humanTaskDU.getNamespace(), humanTaskDU.getName(), this.getTenantAxisConfig(), humanTaskDU.getName(), humanTaskDU.getHumanTaskDefinitionFile());
            this.taskConfigurations.add(notificationConf);
        }
    }

    private void createCallBackService(TaskConfiguration taskConf) throws HumanTaskDeploymentException {
        EndpointConfiguration endpointConfig = taskConf.getEndpointConfiguration(taskConf.getCallbackServiceName().getLocalPart(), taskConf.getCallbackPortName());
        CallBackServiceImpl callbackService = new CallBackServiceImpl(this.tenantId, taskConf.getCallbackServiceName(), taskConf.getCallbackPortName(), taskConf.getName(), taskConf.getResponseWSDL(), taskConf.getResponseOperation(), endpointConfig);
        taskConf.setCallBackService(callbackService);
    }

    private void deploy(HumanTaskBaseConfiguration taskConfig) throws HumanTaskDeploymentException {
        if (taskConfig != null) {
            Definition wsdlDef = taskConfig.getWSDL();
            if (taskConfig instanceof TaskConfiguration) {
                wsdlDef.getPortType(taskConfig.getPortType()).getOperation(taskConfig.getOperation(), null, null).setStyle(OperationType.REQUEST_RESPONSE);
            } else {
                wsdlDef.getPortType(taskConfig.getPortType()).getOperation(taskConfig.getOperation(), null, null).setStyle(OperationType.ONE_WAY);
            }
            WSDL11ToAxisServiceBuilder serviceBuilder = this.createAxisServiceBuilder(taskConfig, wsdlDef);
            try {
                AxisService axisService = this.createAxisService(serviceBuilder);
                ServiceConfigurationUtil.configureService((AxisService)axisService, (EndpointConfiguration)taskConfig.getEndpointConfiguration(taskConfig.getServiceName().getLocalPart(), taskConfig.getPortName()), (ConfigurationContext)this.getConfigContext());
                ArrayList<AxisService> serviceList = new ArrayList<AxisService>();
                serviceList.add(axisService);
                DeploymentEngine.addServiceGroup((AxisServiceGroup)this.createServiceGroupForService(axisService), serviceList, null, null, (AxisConfiguration)this.getTenantAxisConfig());
            }
            catch (AxisFault axisFault) {
                String errMsg = "Error populating the service";
                log.error((Object)errMsg);
                throw new HumanTaskDeploymentException(errMsg, axisFault);
            }
        }
    }

    private WSDL11ToAxisServiceBuilder createAxisServiceBuilder(HumanTaskBaseConfiguration taskConfig, Definition wsdlDef) {
        WSDL11ToAxisServiceBuilder serviceBuilder = new WSDL11ToAxisServiceBuilder(wsdlDef, taskConfig.getServiceName(), taskConfig.getPortName());
        String wsdlBaseURI = wsdlDef.getDocumentBaseURI();
        serviceBuilder.setBaseUri(wsdlBaseURI);
        serviceBuilder.setCustomResolver((URIResolver)new HumanTaskSchemaURIResolver());
        serviceBuilder.setCustomWSDLResolver((WSDLLocator)new HumanTaskWSDLLocator());
        serviceBuilder.setServerSide(true);
        return serviceBuilder;
    }

    private AxisService createAxisService(WSDL11ToAxisServiceBuilder serviceBuilder) throws AxisFault {
        AxisService axisService = serviceBuilder.populateService();
        axisService.setParent((AxisDescription)this.getTenantAxisConfig());
        axisService.setWsdlFound(true);
        axisService.setCustomWsdl(true);
        axisService.setClassLoader(this.getTenantAxisConfig().getServiceClassLoader());
        Utils.setEndpointsToAllUsedBindings((AxisService)axisService);
        axisService.addParameter(new Parameter("modifyUserWSDLPortAddress", (Object)"true"));
        axisService.addParameter("serviceType", (Object)"humantask");
        axisService.addParameter(new Parameter("preserveServiceHistory", (Object)"true"));
        Iterator operations = axisService.getOperations();
        AxisHumanTaskMessageReceiver msgReceiver = new AxisHumanTaskMessageReceiver();
        msgReceiver.setHumanTaskEngine(HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine());
        while (operations.hasNext()) {
            AxisOperation operation = (AxisOperation)operations.next();
            operation.setMessageReceiver((MessageReceiver)msgReceiver);
            this.getTenantAxisConfig().getPhasesInfo().setOperationPhases(operation);
        }
        ArrayList<String> transports = new ArrayList<String>();
        transports.add("https");
        transports.add("http");
        axisService.setExposedTransports(transports);
        return axisService;
    }

    private AxisServiceGroup createServiceGroupForService(AxisService svc) throws AxisFault {
        AxisServiceGroup svcGroup = new AxisServiceGroup();
        svcGroup.setServiceGroupName(svc.getName());
        svcGroup.addService(svc);
        svcGroup.addParameter(new Parameter("preserveServiceHistory", (Object)"true"));
        return svcGroup;
    }

    public HumanTaskBaseConfiguration getTaskConfiguration(QName portType, String operation) {
        for (HumanTaskBaseConfiguration taskConf : this.taskConfigurations) {
            if (!taskConf.getPortType().equals(portType) || !taskConf.getOperation().equals(operation)) continue;
            return taskConf;
        }
        return null;
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public AxisConfiguration getTenantAxisConfig() {
        return this.configContext.getAxisConfiguration();
    }

    public File getHumanTaskDeploymentRepo() {
        return this.humanTaskDeploymentRepo;
    }

    public void setHumanTaskDeploymentRepo(File humanTaskDeploymentRepo) {
        this.humanTaskDeploymentRepo = humanTaskDeploymentRepo;
    }

    public List<HumanTaskBaseConfiguration> getTaskConfigurations() {
        return this.taskConfigurations;
    }

    public List<SimpleTaskDefinitionInfo> getTaskConfigurationInfoListForPackage(String packageName) {
        ArrayList<SimpleTaskDefinitionInfo> matchingTaskDefinitions = new ArrayList<SimpleTaskDefinitionInfo>();
        for (HumanTaskBaseConfiguration taskBaseConfiguration : this.taskConfigurations) {
            if (!taskBaseConfiguration.getPackageName().equals(packageName)) continue;
            matchingTaskDefinitions.add(DeploymentUtil.getSimpleTaskDefinitionInfo(taskBaseConfiguration));
        }
        return matchingTaskDefinitions;
    }

    public List<SimpleTaskDefinitionInfo> getTaskConfigurationInfoList() {
        return DeploymentUtil.getTaskConfigurationsInfoList(this.getTaskConfigurations());
    }

    public void unDeploy(String packageName) {
        boolean matchingPackageFound = this.removeMatchingPackageAfterTaskObsoletion(packageName);
        if (!matchingPackageFound) {
            throw new HumanTaskRuntimeException("There are no matching packages in the repository with name " + packageName);
        }
        this.deleteHumanTaskPackageFromRepo(packageName);
    }

    public HumanTaskBaseConfiguration getTaskConfiguration(QName taskName) {
        HumanTaskBaseConfiguration matchingTaskConfiguration = null;
        for (HumanTaskBaseConfiguration taskConfig : this.taskConfigurations) {
            if (!taskConfig.getName().equals(taskName)) continue;
            matchingTaskConfiguration = taskConfig;
            break;
        }
        return matchingTaskConfiguration;
    }

    private boolean removeMatchingPackageAfterTaskObsoletion(String packageName) {
        final HumanTaskEngine taskEngine = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine();
        boolean matchingPackagesFound = false;
        final int tId = this.tenantId;
        ArrayList<HumanTaskBaseConfiguration> matchingTaskConfigurations = new ArrayList<HumanTaskBaseConfiguration>();
        for (final HumanTaskBaseConfiguration configuration : this.getTaskConfigurations()) {
            if (!configuration.getPackageName().equals(packageName)) continue;
            matchingTaskConfigurations.add(configuration);
            try {
                taskEngine.getScheduler().execTransaction(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        taskEngine.getDaoConnectionFactory().getConnection().obsoleteTasks(configuration.getName().toString(), tId);
                        return null;
                    }
                });
            }
            catch (Exception e) {
                String errMsg = "Error occurred while making tasks obsolete";
                log.error((Object)errMsg);
                throw new HumanTaskRuntimeException(errMsg, e);
            }
            this.removeAxisServiceForTaskConfiguration(configuration);
            matchingPackagesFound = true;
        }
        for (HumanTaskBaseConfiguration removableConfiguration : matchingTaskConfigurations) {
            this.getTaskConfigurations().remove(removableConfiguration);
        }
        return matchingPackagesFound;
    }

    public void removeAxisServiceForTaskConfiguration(HumanTaskBaseConfiguration removableConfiguration) {
        try {
            if (removableConfiguration.getServiceName() != null && StringUtils.isNotEmpty((String)removableConfiguration.getServiceName().getLocalPart())) {
                String axisServiceName = removableConfiguration.getServiceName().getLocalPart();
                AxisService axisService = this.getTenantAxisConfig().getService(axisServiceName);
                if (axisService != null) {
                    axisService.releaseSchemaList();
                    this.getTenantAxisConfig().stopService(axisServiceName);
                    this.getTenantAxisConfig().removeServiceGroup(axisServiceName);
                } else {
                    log.warn((Object)("Could not find matching AxisService in Tenant AxisConfiguration for service name :" + axisServiceName));
                }
            } else {
                log.warn((Object)String.format("Could not find a associated service name for [%s] configuration [%s]", new Object[]{removableConfiguration.getConfigurationType(), removableConfiguration.getName().toString()}));
            }
        }
        catch (AxisFault axisFault) {
            String error = "Error occurred while removing the axis service " + removableConfiguration.getServiceName();
            log.error((Object)error);
            throw new HumanTaskRuntimeException(error, axisFault);
        }
    }

    public void deleteHumanTaskArchive(String packageName) {
        File humanTaskArchive = this.getHumanTaskArchiveLocation(packageName);
        log.info((Object)("UnDeploying HumanTask package " + packageName + ". Deleting HumanTask archive " + humanTaskArchive.getName() + "...."));
        if (humanTaskArchive.exists()) {
            if (!humanTaskArchive.delete()) {
                humanTaskArchive.deleteOnExit();
            }
        } else {
            log.warn((Object)("HumanTask archive [" + humanTaskArchive.getAbsolutePath() + "] not found. This can happen if you delete " + "the HumanTask archive from the file system."));
        }
    }

    public File getHumanTaskArchiveLocation(String packageName) {
        int length;
        String repoPath = this.getTenantAxisConfig().getRepository().getPath();
        String lastChar = repoPath.substring((length = repoPath.length()) - 1);
        if (!File.separator.equals(lastChar)) {
            repoPath = repoPath + File.separator;
        }
        String htArchiveLocation = repoPath + "humantasks" + File.separator + packageName + "." + "zip";
        return new File(htArchiveLocation);
    }

    public ConfigurationContext getConfigContext() {
        return this.configContext;
    }

    private void deleteHumanTaskPackageFromRepo(String packageName) {
        String humanTaskPackageLocation = this.humanTaskDeploymentRepo.getAbsolutePath() + File.separator + this.tenantId + File.separator + packageName;
        File humanTaskPackageDirectory = new File(humanTaskPackageLocation);
        log.info((Object)("UnDeploying HumanTask package. Deleting " + humanTaskPackageDirectory + " HumanTask package"));
        if (humanTaskPackageDirectory.exists()) {
            FileManipulator.deleteDir((File)humanTaskPackageDirectory);
        } else {
            log.warn((Object)("HumanTask package " + humanTaskPackageDirectory.getAbsolutePath() + " not found. This can happen if you delete " + "the HumanTask package from the file system."));
        }
    }

    public void updateTaskStatusForPackage(String packageName, TaskPackageStatus status) {
        for (HumanTaskBaseConfiguration taskBaseConfiguration : this.taskConfigurations) {
            if (!taskBaseConfiguration.getPackageName().equals(packageName)) continue;
            taskBaseConfiguration.setPackageStatus(status);
        }
    }
}

