/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.store;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.humantask.core.store.HumanTaskBaseConfiguration;
import org.wso2.carbon.humantask.core.store.HumanTaskStore;
import org.wso2.carbon.utils.CarbonUtils;

public class HumanTaskStoreManager {
    private Map<Integer, HumanTaskStore> tenantTaskStoreMap = new ConcurrentHashMap<Integer, HumanTaskStore>();

    public HumanTaskStore createHumanTaskStoreForTenant(int tenantId, ConfigurationContext configContext) {
        HumanTaskStore taskStore = new HumanTaskStore(tenantId, configContext);
        taskStore.setHumanTaskDeploymentRepo(new File(CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "humantasks"));
        this.tenantTaskStoreMap.put(tenantId, taskStore);
        return taskStore;
    }

    public HumanTaskStore getHumanTaskStore(int tenantId) {
        return this.tenantTaskStoreMap.get(tenantId);
    }

    public void unloadTenantTaskStore(int tenantId) {
        if (this.tenantTaskStoreMap.get(tenantId) != null) {
            HumanTaskStore taskStore = this.tenantTaskStoreMap.get(tenantId);
            for (HumanTaskBaseConfiguration taskBaseConfig : taskStore.getTaskConfigurations()) {
                taskStore.removeAxisServiceForTaskConfiguration(taskBaseConfig);
            }
            this.tenantTaskStoreMap.remove(tenantId);
        }
    }
}

