/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.store;

import java.io.File;
import java.util.List;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.wso2.carbon.bpel.common.config.EndpointConfiguration;
import org.wso2.carbon.humantask.HumanInteractionsDocument;
import org.wso2.carbon.humantask.TDeadlines;
import org.wso2.carbon.humantask.TNotification;
import org.wso2.carbon.humantask.TPresentationElements;
import org.wso2.carbon.humantask.TPriorityExpr;
import org.wso2.carbon.humantask.core.deployment.HumanTaskDeploymentException;
import org.wso2.carbon.humantask.core.deployment.config.THTDeploymentConfig;
import org.wso2.carbon.humantask.core.deployment.config.TPublish;
import org.wso2.carbon.humantask.core.store.HumanTaskBaseConfiguration;
import org.wso2.carbon.humantask.core.utils.HumanTaskNamespaceContext;
import org.wso2.carbon.humantask.core.utils.HumanTaskStoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationConfiguration
extends HumanTaskBaseConfiguration {
    private static Log log = LogFactory.getLog(NotificationConfiguration.class);
    private TNotification notificationDefinition;
    private THTDeploymentConfig.Notification notificationDeploymentConfiguration;

    public NotificationConfiguration(TNotification notification, THTDeploymentConfig.Notification notificationDeploymentConfiguration, HumanInteractionsDocument humanInteractionsDocument, List<Definition> wsdls, String targetNamespace, String humanTaskArtifactName, AxisConfiguration tenantAxisConfig, String packageName, File humanTaskDefinitionFile) throws HumanTaskDeploymentException {
        super(humanInteractionsDocument, targetNamespace, humanTaskArtifactName, tenantAxisConfig, false, packageName, humanTaskDefinitionFile);
        this.notificationDefinition = notification;
        this.notificationDeploymentConfiguration = notificationDeploymentConfiguration;
        try {
            Definition notificationWSDL = this.findWSDLDefinition(wsdls, this.getPortType(), this.getOperation());
            if (notificationWSDL == null) {
                throw new HumanTaskDeploymentException("Cannot find WSDL definition for notification: " + notification.getName());
            }
            this.setWSDL(notificationWSDL);
            HumanTaskNamespaceContext nsContext = new HumanTaskNamespaceContext();
            NotificationConfiguration.populateNamespace(notification.getDomNode().getNodeType() == 1 ? (Element)notification.getDomNode() : null, nsContext);
            this.setNamespaceContext(nsContext);
            this.initEndpointConfigs();
        }
        catch (HumanTaskDeploymentException depEx) {
            this.setErroneous(true);
            this.setDeploymentError(depEx.getMessage());
            log.error((Object)depEx);
        }
    }

    private void initEndpointConfigs() throws HumanTaskDeploymentException {
        TPublish.Service service = this.notificationDeploymentConfiguration.getPublish().getService();
        OMElement serviceEle = HumanTaskStoreUtils.getOMElement(service.toString());
        EndpointConfiguration endpointConfig = HumanTaskStoreUtils.getEndpointConfig(serviceEle);
        if (endpointConfig != null) {
            endpointConfig.setServiceName(service.getName().getLocalPart());
            endpointConfig.setServicePort(service.getPort());
            endpointConfig.setServiceNS(service.getName().getNamespaceURI());
            endpointConfig.setBasePath(this.getHumanTaskDefinitionFile().getParentFile().getAbsolutePath());
            this.addEndpointConfiguration(endpointConfig);
        }
    }

    public TNotification getNotificationDefinition() {
        return this.notificationDefinition;
    }

    public void setNotificationDefinition(TNotification notificationDefinition) {
        this.notificationDefinition = notificationDefinition;
    }

    public THTDeploymentConfig.Notification getNotificationDeploymentConfiguration() {
        return this.notificationDeploymentConfiguration;
    }

    public void setNotificatioDeploymentConfiguration(THTDeploymentConfig.Notification notificationDeploymentConfiguration) {
        this.notificationDeploymentConfiguration = notificationDeploymentConfiguration;
    }

    @Override
    public QName getPortType() {
        return this.notificationDefinition.getInterface().getPortType();
    }

    @Override
    public String getOperation() {
        return this.notificationDefinition.getInterface().getOperation();
    }

    @Override
    public QName getName() {
        return new QName(this.getTargetNamespace(), this.notificationDefinition.getName());
    }

    @Override
    public QName getServiceName() {
        if (this.notificationDeploymentConfiguration != null && this.notificationDeploymentConfiguration.getPublish() != null && this.notificationDeploymentConfiguration.getPublish().getService() != null) {
            return this.notificationDeploymentConfiguration.getPublish().getService().getName();
        }
        return null;
    }

    @Override
    public String getPortName() {
        if (this.notificationDeploymentConfiguration != null && this.notificationDeploymentConfiguration.getPublish() != null && this.notificationDeploymentConfiguration.getPublish().getService() != null) {
            return this.notificationDeploymentConfiguration.getPublish().getService().getPort();
        }
        return null;
    }

    @Override
    public TPriorityExpr getPriorityExpression() {
        return this.notificationDefinition.getPriority();
    }

    @Override
    public TPresentationElements getPresentationElements() {
        return this.notificationDefinition.getPresentationElements();
    }

    @Override
    public HumanTaskBaseConfiguration.ConfigurationType getConfigurationType() {
        return HumanTaskBaseConfiguration.ConfigurationType.NOTIFICATION;
    }

    @Override
    public TDeadlines getDeadlines() {
        return null;
    }
}

