/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.store;

import java.io.File;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.wso2.carbon.bpel.common.config.EndpointConfiguration;
import org.wso2.carbon.humantask.HumanInteractionsDocument;
import org.wso2.carbon.humantask.TDeadline;
import org.wso2.carbon.humantask.TDeadlines;
import org.wso2.carbon.humantask.TPresentationElements;
import org.wso2.carbon.humantask.TPriorityExpr;
import org.wso2.carbon.humantask.TTask;
import org.wso2.carbon.humantask.core.CallBackService;
import org.wso2.carbon.humantask.core.dao.TaskPackageStatus;
import org.wso2.carbon.humantask.core.deployment.HumanTaskDeploymentException;
import org.wso2.carbon.humantask.core.deployment.config.TCallback;
import org.wso2.carbon.humantask.core.deployment.config.THTDeploymentConfig;
import org.wso2.carbon.humantask.core.deployment.config.TPublish;
import org.wso2.carbon.humantask.core.store.HumanTaskBaseConfiguration;
import org.wso2.carbon.humantask.core.utils.HumanTaskNamespaceContext;
import org.wso2.carbon.humantask.core.utils.HumanTaskStoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskConfiguration
extends HumanTaskBaseConfiguration {
    private static Log log = LogFactory.getLog(TaskConfiguration.class);
    private TTask task;
    private THTDeploymentConfig.Task taskDeploymentConfiguration;
    private Definition responseWSDL;
    private boolean useOneWSDL = false;
    private CallBackService callBackService;

    public TaskConfiguration(TTask task, THTDeploymentConfig.Task taskDeploymentConfiguration, HumanInteractionsDocument humanInteractionsDocument, List<Definition> wsdls, String targetNamespace, String humanTaskArtifactName, AxisConfiguration tenatAxisConf, String packageName, File humanTaskDefinitionFile) {
        super(humanInteractionsDocument, targetNamespace, humanTaskArtifactName, tenatAxisConf, true, packageName, humanTaskDefinitionFile);
        this.task = task;
        this.taskDeploymentConfiguration = taskDeploymentConfiguration;
        try {
            Definition taskWSDL = this.findWSDLDefinition(wsdls, this.getPortType(), this.getOperation());
            if (taskWSDL == null) {
                throw new HumanTaskDeploymentException("Cannot find WSDL definition for task: " + task.getName());
            }
            this.setWSDL(taskWSDL);
            HumanTaskNamespaceContext nsContext = new HumanTaskNamespaceContext();
            TaskConfiguration.populateNamespace(task.getDomNode().getNodeType() == 1 ? (Element)task.getDomNode() : null, nsContext);
            this.setNamespaceContext(nsContext);
            PortType portType = this.getWSDL().getPortType(this.getResponsePortType());
            if (portType != null && portType.getOperation(this.getResponseOperation(), null, null) != null) {
                this.useOneWSDL = true;
            }
            if (!this.useOneWSDL) {
                this.responseWSDL = this.findWSDLDefinition(wsdls, this.getResponsePortType(), this.getResponseOperation());
            }
            this.initEndpointConfigs();
        }
        catch (HumanTaskDeploymentException depEx) {
            this.setPackageStatus(TaskPackageStatus.INACTIVE);
            this.setErroneous(true);
            this.setDeploymentError(depEx.getMessage());
            log.error((Object)depEx);
        }
    }

    private void initEndpointConfigs() throws HumanTaskDeploymentException {
        if (this.taskDeploymentConfiguration == null) {
            throw new HumanTaskDeploymentException("Cannot find task deployment configuration.");
        }
        if (this.taskDeploymentConfiguration.getPublish() == null || this.taskDeploymentConfiguration.getPublish().getService() == null) {
            throw new HumanTaskDeploymentException("Cannot find publish element in the htconfig.xml file.");
        }
        TPublish.Service service = this.taskDeploymentConfiguration.getPublish().getService();
        OMElement serviceEle = HumanTaskStoreUtils.getOMElement(service.toString());
        EndpointConfiguration endpointConfig = HumanTaskStoreUtils.getEndpointConfig(serviceEle);
        if (endpointConfig != null) {
            endpointConfig.setServiceName(service.getName().getLocalPart());
            endpointConfig.setServicePort(service.getPort());
            endpointConfig.setServiceNS(service.getName().getNamespaceURI());
            endpointConfig.setBasePath(this.getHumanTaskDefinitionFile().getParentFile().getAbsolutePath());
            this.addEndpointConfiguration(endpointConfig);
        }
        if (this.taskDeploymentConfiguration.getCallback() == null || this.taskDeploymentConfiguration.getCallback().getService() == null) {
            throw new HumanTaskDeploymentException("Cannot find callback element in the htconfig.xml file.");
        }
        TCallback.Service cbService = this.taskDeploymentConfiguration.getCallback().getService();
        serviceEle = HumanTaskStoreUtils.getOMElement(cbService.toString());
        endpointConfig = HumanTaskStoreUtils.getEndpointConfig(serviceEle);
        if (endpointConfig != null) {
            endpointConfig.setServiceName(cbService.getName().getLocalPart());
            endpointConfig.setServicePort(cbService.getPort());
            endpointConfig.setServiceNS(cbService.getName().getNamespaceURI());
            endpointConfig.setBasePath(this.getHumanTaskDefinitionFile().getParentFile().getAbsolutePath());
            this.addEndpointConfiguration(endpointConfig);
        }
    }

    public TTask getTask() {
        return this.task;
    }

    public void setTask(TTask task) {
        this.task = task;
    }

    public Definition getResponseWSDL() {
        if (!this.useOneWSDL) {
            return this.responseWSDL;
        }
        return this.getWSDL();
    }

    public QName getResponsePortType() {
        return this.task.getInterface().getResponsePortType();
    }

    public String getResponseOperation() {
        return this.task.getInterface().getResponseOperation();
    }

    @Override
    public QName getPortType() {
        return this.task.getInterface().getPortType();
    }

    @Override
    public String getOperation() {
        return this.task.getInterface().getOperation();
    }

    @Override
    public QName getName() {
        return new QName(this.getTargetNamespace(), this.task.getName());
    }

    @Override
    public QName getServiceName() {
        return this.taskDeploymentConfiguration.getPublish().getService().getName();
    }

    @Override
    public String getPortName() {
        return this.taskDeploymentConfiguration.getPublish().getService().getPort();
    }

    public QName getCallbackServiceName() {
        return this.taskDeploymentConfiguration.getCallback().getService().getName();
    }

    public String getCallbackPortName() {
        return this.taskDeploymentConfiguration.getCallback().getService().getPort();
    }

    @Override
    public TPriorityExpr getPriorityExpression() {
        return this.task.getPriority();
    }

    @Override
    public TPresentationElements getPresentationElements() {
        return this.task.getPresentationElements();
    }

    @Override
    public TDeadlines getDeadlines() {
        return this.task.getDeadlines();
    }

    public TDeadline getDeadline(String name) {
        TDeadlines deadlines = this.getDeadlines();
        for (TDeadline deadline : deadlines.getStartDeadlineArray()) {
            if (!deadline.getName().equals(name)) continue;
            return deadline;
        }
        for (TDeadline deadline : deadlines.getCompletionDeadlineArray()) {
            if (!deadline.getName().equals(name)) continue;
            return deadline;
        }
        return null;
    }

    public CallBackService getCallBackService() {
        return this.callBackService;
    }

    @Override
    public HumanTaskBaseConfiguration.ConfigurationType getConfigurationType() {
        return HumanTaskBaseConfiguration.ConfigurationType.TASK;
    }

    public void setCallBackService(CallBackService callBackService) {
        this.callBackService = callBackService;
    }
}

