/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.utils;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.DOMOutputImpl;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xml.serialize.DOMSerializerImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.ls.LSOutput;
import org.wso2.carbon.humantask.core.utils.SAXLoggingErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DOMUtils {
    private static ThreadLocal<DocumentBuilder> builders = new ThreadLocal();
    private static final DocumentBuilderFactory documentBuilderFactory = new DocumentBuilderFactoryImpl();
    private static Log log = LogFactory.getLog(DOMUtils.class);
    public static final String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";

    private DOMUtils() {
    }

    private static void initDocumentBuilderFactory() {
        documentBuilderFactory.setNamespaceAware(true);
    }

    public static Document newDocument() {
        DocumentBuilder db = DOMUtils.getBuilder();
        return db.newDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentBuilder getBuilder() {
        DocumentBuilder builder = builders.get();
        if (builder == null) {
            DocumentBuilderFactory documentBuilderFactory = DOMUtils.documentBuilderFactory;
            synchronized (documentBuilderFactory) {
                try {
                    builder = DOMUtils.documentBuilderFactory.newDocumentBuilder();
                    builder.setErrorHandler(new SAXLoggingErrorHandler());
                }
                catch (ParserConfigurationException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            builders.set(builder);
        }
        return builder;
    }

    public static String domToString(Node node) {
        String value;
        if (node == null) {
            throw new IllegalArgumentException("Cannot stringify null Node!");
        }
        short nodeType = node.getNodeType();
        if (nodeType == 1 || nodeType == 9) {
            String parentEncoding;
            DOMSerializerImpl ser = new DOMSerializerImpl();
            ser.setParameter("namespaces", (Object)Boolean.TRUE);
            ser.setParameter("well-formed", (Object)Boolean.FALSE);
            ser.setParameter("validate", (Object)Boolean.FALSE);
            String usedEncoding = "UTF-8";
            Document parent = node.getOwnerDocument();
            if (parent != null && (parentEncoding = parent.getXmlEncoding()) != null) {
                usedEncoding = parentEncoding;
            }
            DOMOutputImpl out = new DOMOutputImpl();
            out.setEncoding(usedEncoding);
            StringWriter writer = new StringWriter(4096);
            out.setCharacterStream((Writer)writer);
            ser.write(node, (LSOutput)out);
            writer.flush();
            value = writer.toString();
        } else {
            value = node.getNodeValue();
        }
        return value;
    }

    public static Element stringToDOM(String s) throws SAXException, IOException {
        return DOMUtils.parse(new InputSource(new StringReader(s))).getDocumentElement();
    }

    public static Document parse(InputSource inputSource) throws SAXException, IOException {
        DocumentBuilder db = DOMUtils.getBuilder();
        return db.parse(inputSource);
    }

    public static Element getElementFromObject(Object data) {
        Element dataElement = null;
        try {
            dataElement = (Element)data;
        }
        catch (Exception e) {
            log.warn((Object)"Object is not an Element. Trying to create the Element explicitly.", (Throwable)e);
            try {
                DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
                Document doc = docBuilder.newDocument();
                dataElement = doc.createElement("data");
                doc.appendChild(dataElement);
                Text text = doc.createTextNode("no data provided");
                if (data != null) {
                    text = doc.createTextNode(data.toString());
                }
                dataElement.appendChild(text);
            }
            catch (Exception ex) {
                log.error((Object)"Error while creating the element.", (Throwable)ex);
            }
        }
        return dataElement;
    }

    static {
        DOMUtils.initDocumentBuilderFactory();
    }
}

