/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.utils;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Duration {
    static final Pattern PATTERN = Pattern.compile("P(\\d+Y)?(\\d+M)?(\\d+D)?(T(\\d+H)?(\\d+M)?((\\d+\\.?\\d*|\\.\\d+)S)?)?");
    static final int YEAR_MG = 1;
    static final int MONTH_MG = 2;
    static final int DAY_MG = 3;
    static final int HOUR_MG = 5;
    static final int MIN_MG = 6;
    static final int SEC_MG = 8;
    private int years;
    private int months;
    private int days;
    private int hours;
    private int minutes;
    private BigDecimal seconds;
    private boolean addition = true;

    public Duration(String duration) {
        Matcher m;
        String tDuration = duration;
        if (tDuration.startsWith("-")) {
            this.addition = false;
            tDuration = tDuration.substring(1);
        }
        if (!(m = PATTERN.matcher(tDuration)).matches()) {
            throw new IllegalArgumentException("Invalid duration: " + tDuration);
        }
        this.years = Duration.parseInt(m.group(1));
        this.months = Duration.parseInt(m.group(2));
        this.days = Duration.parseInt(m.group(3));
        this.hours = Duration.parseInt(m.group(5));
        this.minutes = Duration.parseInt(m.group(6));
        this.seconds = m.group(8) == null ? null : new BigDecimal(m.group(8));
    }

    public void addTo(Calendar calendar) {
        calendar.add(1, this.addition ? this.years : 0 - this.years);
        calendar.add(2, this.addition ? this.months : 0 - this.months);
        calendar.add(5, this.addition ? this.days : 0 - this.days);
        calendar.add(10, this.addition ? this.hours : 0 - this.hours);
        calendar.add(12, this.addition ? this.minutes : 0 - this.minutes);
        calendar.add(13, this.seconds == null ? 0 : (this.addition ? this.seconds.intValue() : 0 - this.seconds.intValue()));
        if (this.seconds != null) {
            BigDecimal fraction = this.seconds.subtract(this.seconds.setScale(0, 1));
            int millisec = fraction.movePointRight(3).intValue();
            calendar.add(14, this.addition ? millisec : 0 - millisec);
        }
    }

    private static int parseInt(String value) {
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(value.substring(0, value.length() - 1));
    }

    public static boolean isValidExpression(String exp) {
        String tExp = exp;
        if (tExp.startsWith("-")) {
            tExp = tExp.substring(1);
        }
        Matcher m = PATTERN.matcher(tExp);
        return m.matches();
    }
}

