/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.utils;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtils {
    private FileUtils() {
    }

    public static List<File> directoryEntriesInPath(File rootDirectory, FileFilter filter) {
        if (rootDirectory == null) {
            throw new IllegalArgumentException("File must not be null!");
        }
        if (!rootDirectory.exists()) {
            throw new IllegalArgumentException("File does not exist!");
        }
        ArrayList<File> collectedFiles = new ArrayList<File>(32);
        if (rootDirectory.isFile()) {
            if (filter == null || filter.accept(rootDirectory)) {
                collectedFiles.add(rootDirectory);
            }
            return collectedFiles;
        }
        FileUtils.directoryEntriesInPath(collectedFiles, rootDirectory, filter);
        return collectedFiles;
    }

    private static void directoryEntriesInPath(List<File> collectedFiles, File parentDir, FileFilter filter) {
        File[] allFiles;
        if (filter == null || filter.accept(parentDir)) {
            collectedFiles.add(parentDir);
        }
        if ((allFiles = parentDir.listFiles()) != null) {
            TreeSet<File> dirs = new TreeSet<File>();
            TreeSet<File> acceptedFiles = new TreeSet<File>();
            for (File f : allFiles) {
                if (f.isDirectory()) {
                    dirs.add(f);
                    continue;
                }
                if (filter != null && !filter.accept(f)) continue;
                acceptedFiles.add(f);
            }
            collectedFiles.addAll(acceptedFiles);
            for (File currentFile : dirs) {
                FileUtils.directoryEntriesInPath(collectedFiles, currentFile, filter);
            }
        }
    }
}

