/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.utils;

import java.io.Serializable;
import java.math.BigInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.humantask.core.utils.ProcessMutex;

public final class GUID
implements Cloneable,
Comparable,
Serializable {
    static final long serialVersionUID = -7977671257884186039L;
    private static Log log = LogFactory.getLog(GUID.class);
    private static String propertyPort = "org.wso2.carbon.humantask.uid.port";
    private static int port = Integer.getInteger(propertyPort, 33666);
    private static final byte[] ipadd = new byte[]{127, 0, 0, 1};
    private static byte[] baseId = GUID.getSystemUniqId();
    private static short cnt = Short.MIN_VALUE;
    private final byte[] id;
    private transient String guidstring = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GUID() {
        Class<GUID> clazz = GUID.class;
        synchronized (GUID.class) {
            short c = cnt = (short)(cnt + 1);
            byte[] b = baseId;
            if (cnt == Short.MAX_VALUE) {
                cnt = Short.MIN_VALUE;
                baseId = GUID.getSystemUniqId();
            }
            // ** MonitorExit[var3_1] (shouldn't be in output)
            this.id = new byte[]{ipadd[0], ipadd[1], ipadd[2], ipadd[3], b[7], b[6], b[5], b[4], b[3], b[2], b[1], b[0], (byte)(c >>> 8 & 0xFF), (byte)(c & 0xFF)};
            return;
        }
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        GUID o1 = (GUID)o;
        for (int i = 0; i < this.id.length; i = (int)((short)(i + 1))) {
            if (o1.id[i] < this.id[i]) {
                return -1;
            }
            if (o1.id[i] <= this.id[i]) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof GUID && this.compareTo(o) == 0;
    }

    public int hashCode() {
        int ret = 0;
        for (int i = 0; i < this.id.length; i = (int)((short)(i + 1))) {
            ret ^= this.id[i] << i % 4;
        }
        return ret;
    }

    public String toString() {
        if (this.guidstring == null) {
            this.guidstring = this.mapBytesToChars();
        }
        return this.guidstring;
    }

    private static byte[] getSystemUniqId() {
        ProcessMutex pm = new ProcessMutex(port);
        try {
            pm.lock();
        }
        catch (InterruptedException ie) {
            log.error((Object)("ERROR: Could not establish unique starttime using\n       TCP port " + port + " for synchronization. \n" + "       Perhaps this port is used by anotherprocess? \n" + "       Check the '" + propertyPort + "' JAVA system property. \n"), (Throwable)ie);
            throw new RuntimeException("GUID.getSystemUniqId() FAILED!!!", ie);
        }
        long uid = System.currentTimeMillis();
        pm.unlock();
        return new byte[]{(byte)(uid & 0xFFL), (byte)(uid >>> 8 & 0xFFL), (byte)(uid >>> 16 & 0xFFL), (byte)(uid >>> 24 & 0xFFL), (byte)(uid >>> 32 & 0xFFL), (byte)(uid >>> 40 & 0xFFL), (byte)(uid >>> 48 & 0xFFL), (byte)(uid >>> 56 & 0xFFL)};
    }

    private String mapBytesToChars() {
        BigInteger bigInt = new BigInteger(this.id);
        return bigInt.toString(34);
    }
}

