/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HumanTaskNamespaceContext
implements NamespaceContext {
    private static final Log log = LogFactory.getLog(HumanTaskNamespaceContext.class);
    private Map<String, String> prefixToUriMap = new HashMap<String, String>();

    public String getNamespaceURI(String prefix) {
        return this.prefixToUriMap.get(prefix == null ? "" : prefix);
    }

    public String getPrefix(String namespaceURI) {
        for (String s : this.prefixToUriMap.keySet()) {
            if (!this.prefixToUriMap.get(s).equals(namespaceURI)) continue;
            return s;
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Namespace URI null.");
        }
        ArrayList<String> matchedObjs = new ArrayList<String>();
        for (String s : this.prefixToUriMap.keySet()) {
            if (!this.prefixToUriMap.get(s).equals(namespaceURI)) continue;
            matchedObjs.add(s);
        }
        return matchedObjs.iterator();
    }

    public void register(String prefix, String nsUri) {
        String tPrefix = prefix;
        String tNsUri = nsUri;
        if (tPrefix == null) {
            tPrefix = "";
        }
        if (tNsUri == null) {
            tNsUri = "";
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Registering Namespace: Prefix pair - " + tNsUri + ":" + tPrefix));
        }
        this.prefixToUriMap.put(tPrefix, tNsUri);
    }
}

