/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.utils;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bpel.common.config.EndpointConfiguration;
import org.wso2.carbon.humantask.core.deployment.HumanTaskDeploymentException;

public final class HumanTaskStoreUtils {
    private static Log log = LogFactory.getLog(HumanTaskStoreUtils.class);

    public static OMElement getOMElement(String elementString) throws HumanTaskDeploymentException {
        OMElement serviceEle;
        try {
            serviceEle = AXIOMUtil.stringToOM((String)elementString);
        }
        catch (XMLStreamException e) {
            String errMsg = "Error occurred while converting string: " + elementString + " to OMElement";
            log.error((Object)errMsg, (Throwable)e);
            throw new HumanTaskDeploymentException(errMsg, e);
        }
        return serviceEle;
    }

    public static EndpointConfiguration getEndpointConfig(OMElement serviceEle) {
        OMElement endpointEle = serviceEle.getFirstElement();
        if (endpointEle == null || !endpointEle.getQName().equals(new QName("http://wso2.org/bps/bpel/endpoint/config", "endpoint"))) {
            return null;
        }
        String serviceDescLocation = endpointEle.getAttributeValue(new QName(null, "serviceDescriptionReference"));
        if (StringUtils.isNotEmpty((String)serviceDescLocation)) {
            EndpointConfiguration endpointConfig = new EndpointConfiguration();
            endpointConfig.setServiceDescriptionAvailable(true);
            endpointConfig.setServiceDescriptionLocation(serviceDescLocation.trim());
            return endpointConfig;
        }
        String endpointRef = endpointEle.getAttributeValue(new QName(null, "endpointReference"));
        if (StringUtils.isNotEmpty((String)endpointRef)) {
            EndpointConfiguration endpointConfig = new EndpointConfiguration();
            endpointConfig.setUnifiedEndPointReference(endpointRef.trim());
            return endpointConfig;
        }
        return null;
    }
}

