/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class ISO8601DateParser {
    private ISO8601DateParser() {
    }

    public static Date parse(String date) throws ParseException {
        String pattern;
        StringBuilder buffer = new StringBuilder(date.trim());
        boolean timezoned = false;
        switch (buffer.length()) {
            case 4: {
                pattern = "yyyy";
                break;
            }
            case 7: {
                pattern = "yyyy-MM";
                break;
            }
            case 10: {
                pattern = "yyyy-MM-dd";
                break;
            }
            default: {
                pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS";
                if (buffer.length() == 16) {
                    buffer.append(":00");
                }
                if (buffer.length() > 16 && buffer.charAt(16) != ':') {
                    buffer.insert(16, ":00");
                }
                if (buffer.length() == 19) {
                    buffer.append(".000");
                }
                if (buffer.length() > 19 && buffer.charAt(19) != '.') {
                    buffer.insert(19, ".000");
                }
                if (buffer.charAt(19) == '.' && (buffer.length() < 22 || buffer.lastIndexOf("-") < 23 && buffer.lastIndexOf("-") > 19 || buffer.lastIndexOf("+") < 23 && buffer.lastIndexOf("+") > 0)) {
                    buffer.insert(20, "0");
                }
                if (buffer.charAt(19) == '.' && (buffer.length() < 22 || buffer.lastIndexOf("-") < 23 && buffer.lastIndexOf("-") > 19 || buffer.lastIndexOf("+") < 23 && buffer.lastIndexOf("+") > 0)) {
                    buffer.insert(20, "0");
                }
                if (buffer.length() > 23) {
                    pattern = pattern + "Z";
                    timezoned = true;
                }
                if (buffer.length() == 24 && buffer.charAt(23) == 'Z') {
                    buffer.replace(23, 24, "+0000");
                }
                if (buffer.length() != 29 || buffer.charAt(26) != ':') break;
                buffer.deleteCharAt(26);
            }
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        if (timezoned) {
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        return format.parse(buffer.toString());
    }

    public static Calendar parseCal(String date) throws ParseException {
        Date d = ISO8601DateParser.parse(date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal;
    }

    public static String format(Date date) {
        TimeZone timeZone = TimeZone.getDefault();
        boolean utc = TimeZone.getTimeZone("UTC").equals(timeZone) || TimeZone.getTimeZone("GMT").equals(timeZone);
        String pattern = utc ? "yyyy-MM-dd'T'HH:mm:ss'Z'" : "yyyy-MM-dd'T'HH:mm:ssZ";
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        format.setTimeZone(timeZone);
        StringBuilder buffer = new StringBuilder(format.format(date));
        if (!utc) {
            buffer.insert(buffer.length() - 2, ':');
        }
        return buffer.toString();
    }
}

