/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SAXLoggingErrorHandler
implements ErrorHandler {
    private static final Log defaultLog = LogFactory.getLog(SAXLoggingErrorHandler.class);
    private Log log;
    private static final String WARNING = "WARNING";
    private static final String ERROR = "ERROR";
    private static final String FATAL = "FATAL";

    public SAXLoggingErrorHandler() {
        this.log = defaultLog;
    }

    public SAXLoggingErrorHandler(Log log) {
        this.log = log;
    }

    public void warning(SAXParseException exception) throws SAXException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.formatMessage(WARNING, exception));
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.formatMessage(ERROR, exception));
        }
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.formatMessage(FATAL, exception));
        }
    }

    private String formatMessage(String level, SAXParseException spe) {
        StringBuffer sb = new StringBuffer(64);
        if (spe.getSystemId() != null) {
            sb.append(spe.getSystemId());
        }
        sb.append(':');
        sb.append(spe.getLineNumber());
        sb.append(':');
        sb.append(spe.getColumnNumber());
        sb.append(':');
        sb.append(level);
        sb.append(':');
        sb.append(spe.getMessage());
        return sb.toString();
    }
}

