/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sequences.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.wso2.carbon.sequences.to.SequenceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceInfoFactory {
    public static SequenceInfo createSequenceInfo(SequenceMediator sequenceMediator) {
        SequenceInfo sequenceInfo = new SequenceInfo();
        sequenceInfo.setName(sequenceMediator.getName());
        if (sequenceMediator.getStatisticsState() == 1) {
            sequenceInfo.setEnableStatistics(true);
        } else {
            sequenceInfo.setEnableStatistics(false);
        }
        if (sequenceMediator.getTraceState() == 1) {
            sequenceInfo.setEnableTracing(true);
        } else {
            sequenceInfo.setEnableTracing(false);
        }
        return sequenceInfo;
    }

    public static SequenceInfo[] getSortedSequenceInfoArray(Collection<SequenceMediator> sequenceMediators) {
        ArrayList<SequenceInfo> sequenceInfos = new ArrayList<SequenceInfo>();
        for (SequenceMediator sequenceMediator : sequenceMediators) {
            sequenceInfos.add(SequenceInfoFactory.createSequenceInfo(sequenceMediator));
        }
        Collections.sort(sequenceInfos, new Comparator<SequenceInfo>(){

            @Override
            public int compare(SequenceInfo info1, SequenceInfo info2) {
                return info1.getName().compareToIgnoreCase(info2.getName());
            }
        });
        return sequenceInfos.toArray(new SequenceInfo[sequenceInfos.size()]);
    }
}

