/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sequences.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.MediatorFactoryFinder;
import org.apache.synapse.config.xml.MediatorSerializerFinder;
import org.apache.synapse.config.xml.SynapseXMLConfigurationFactory;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.wso2.carbon.mediation.utils.AbstractMediationAdmin;
import org.wso2.carbon.sequences.SequenceEditorException;
import org.wso2.carbon.sequences.factory.SequenceInfoFactory;
import org.wso2.carbon.sequences.to.SequenceInfo;

public class SequenceAdmin
extends AbstractMediationAdmin {
    private static final Log log = LogFactory.getLog(SequenceAdmin.class);

    public SequenceInfo[] getSequences() throws SequenceEditorException {
        Collection<SequenceMediator> sequences = null;
        try {
            sequences = this.getSynapseConfiguration().getDefinedSequences().values();
        }
        catch (AxisFault fault) {
            this.handleException("Couldn't get the Synapse Configuration to get the available sequences", fault);
        }
        return SequenceInfoFactory.getSortedSequenceInfoArray(sequences);
    }

    public void deleteSequence(String sequenceName) throws SequenceEditorException {
        try {
            SynapseConfiguration synCfg = this.getSynapseConfiguration();
            if (synCfg.getSequence(sequenceName) != null) {
                synCfg.removeSequence(sequenceName);
            } else {
                this.handleException("No defined sequence with name " + sequenceName + " found to delete in the Synapse configuration");
            }
        }
        catch (AxisFault fault) {
            this.handleException("Couldn't get the Synapse Configuration to delete the sequence", fault);
        }
    }

    public OMElement getSequence(String sequenceName) throws SequenceEditorException {
        try {
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            if (synapseConfiguration.getSequence(sequenceName) != null) {
                return MediatorSerializerFinder.getInstance().getSerializer(synapseConfiguration.getSequence(sequenceName)).serializeMediator(null, synapseConfiguration.getSequence(sequenceName));
            }
            this.handleException("Sequence with the name " + sequenceName + " does not exist");
        }
        catch (SynapseException syne) {
            this.handleException("Unable to get the sequence : " + sequenceName, syne);
        }
        catch (AxisFault fault) {
            this.handleException("Couldn't get the Synapse Configuration to get the sequence", fault);
        }
        return null;
    }

    public void addSequence(OMElement sequenceElement) throws SequenceEditorException {
        try {
            if (sequenceElement.getLocalName().equals(XMLConfigConstants.SEQUENCE_ELT.getLocalPart())) {
                String sequenceName = sequenceElement.getAttributeValue(new QName("name"));
                SynapseConfiguration config = this.getSynapseConfiguration();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding sequence : " + sequenceName + " to the configuration"));
                }
                if (config.getLocalRegistry().get(sequenceName) != null) {
                    this.handleException("The name '" + sequenceName + "' is already used within the configuration");
                } else {
                    Mediator seq;
                    SynapseXMLConfigurationFactory.defineSequence((SynapseConfiguration)config, (OMElement)sequenceElement);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Added sequence : " + sequenceName + " to the configuration"));
                    }
                    if ((seq = config.getSequence(sequenceName)) != null && seq instanceof ManagedLifecycle) {
                        ((ManagedLifecycle)seq).init(this.getSynapseEnvironment());
                        ((AbstractMediator)seq).init(this.getConfigContext());
                    }
                }
            } else {
                this.handleException("Error adding sequence. Invalid definition");
            }
        }
        catch (SynapseException syne) {
            this.handleException("Error adding sequence : " + syne.getMessage(), syne);
        }
        catch (AxisFault fault) {
            this.handleException("Couldn't get the Synapse Configuration to add the sequence", fault);
        }
    }

    public void saveSequence(OMElement sequenceElement) throws SequenceEditorException {
        try {
            if (sequenceElement != null && sequenceElement.getLocalName().equals(XMLConfigConstants.SEQUENCE_ELT.getLocalPart())) {
                String sequenceName = sequenceElement.getAttributeValue(new QName("name"));
                SynapseConfiguration config = this.getSynapseConfiguration();
                log.debug((Object)("Saving sequence : " + sequenceName));
                if (config.getSequence(sequenceName) == null) {
                    this.handleException("Unable to save sequence " + sequenceName + ". Does not exist");
                } else {
                    config.removeSequence(sequenceName);
                    config.addSequence(sequenceName, MediatorFactoryFinder.getInstance().getMediator(sequenceElement));
                    log.debug((Object)("Saved sequence : " + sequenceName + " to the configuration"));
                    Mediator seq = config.getSequence(sequenceName);
                    if (seq != null && seq instanceof ManagedLifecycle) {
                        ((ManagedLifecycle)seq).init(this.getSynapseEnvironment());
                        ((AbstractMediator)seq).init(this.getConfigContext());
                    }
                }
            } else {
                this.handleException("Unable to save sequence. Invalid definition");
            }
        }
        catch (SynapseException syne) {
            this.handleException("Unable to save the sequence", syne);
        }
        catch (AxisFault fault) {
            this.handleException("Couldn't get the Synapse Configuration to save the sequence", fault);
        }
    }

    public String enableStatistics(String sequenceName) throws SequenceEditorException {
        try {
            SequenceMediator sequence = (SequenceMediator)this.getSynapseConfiguration().getSequence(sequenceName);
            if (sequence != null) {
                sequence.setStatisticsState(1);
                return sequenceName;
            }
            this.handleException("No defined sequence with name " + sequenceName + " found to enable statistics in the Synapse configuration");
        }
        catch (AxisFault fault) {
            this.handleException("Couldn't get the Synapse Configuration to enable statistics of the sequence", fault);
        }
        return null;
    }

    public String disableStatistics(String sequenceName) throws SequenceEditorException {
        try {
            SequenceMediator sequence = (SequenceMediator)this.getSynapseConfiguration().getSequence(sequenceName);
            if (sequence != null) {
                sequence.setStatisticsState(0);
                return sequenceName;
            }
            this.handleException("No defined sequence with name " + sequenceName + " found to disable statistics in the Synapse configuration");
        }
        catch (AxisFault fault) {
            this.handleException("Couldn't get the Synapse Configuration to disable statistics of the sequence", fault);
        }
        return null;
    }

    public String enableTracing(String sequenceName) throws SequenceEditorException {
        try {
            SequenceMediator sequence = (SequenceMediator)this.getSynapseConfiguration().getSequence(sequenceName);
            if (sequence != null) {
                sequence.setTraceState(1);
                return sequenceName;
            }
            this.handleException("No defined sequence with name " + sequenceName + " found to enable tracing in the Synapse configuration");
        }
        catch (AxisFault fault) {
            this.handleException("Couldn't get the Synapse Configuration to enable tracing of the sequence", fault);
        }
        return null;
    }

    public String disableTracing(String sequenceName) throws SequenceEditorException {
        try {
            SequenceMediator sequence = (SequenceMediator)this.getSynapseConfiguration().getSequence(sequenceName);
            if (sequence != null) {
                sequence.setTraceState(0);
                return sequenceName;
            }
            this.handleException("No defined sequence with name " + sequenceName + " found to disable tracing in the Synapse configuration");
        }
        catch (AxisFault fault) {
            this.handleException("Couldn't get the Synapse Configuration to disable tracing of the sequence", fault);
        }
        return null;
    }

    private void handleException(String message, Throwable cause) throws SequenceEditorException {
        log.error((Object)message, cause);
        throw new SequenceEditorException(message, cause);
    }

    private void handleException(String message) throws SequenceEditorException {
        log.error((Object)message);
        throw new SequenceEditorException(message);
    }

    public String getEntryNamesString() throws SequenceEditorException {
        try {
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            Map globalEntriesMap = synapseConfiguration.getLocalRegistry();
            ArrayList<String> sequenceList = new ArrayList<String>();
            ArrayList<String> endpointList = new ArrayList<String>();
            ArrayList<String> entryList = new ArrayList<String>();
            StringBuffer entrySb = new StringBuffer();
            StringBuffer endpointSb = new StringBuffer();
            StringBuffer sequenceSb = new StringBuffer();
            for (Object entryValue : globalEntriesMap.values()) {
                String key;
                Entry entry;
                String name;
                if (entryValue instanceof Endpoint) {
                    Endpoint endpoint = (Endpoint)entryValue;
                    name = endpoint.getName();
                    if (name == null) continue;
                    endpointList.add(name);
                    continue;
                }
                if (entryValue instanceof SequenceMediator) {
                    SequenceMediator sequenceMediator = (SequenceMediator)entryValue;
                    name = sequenceMediator.getName();
                    if (name == null) continue;
                    sequenceList.add(name);
                    continue;
                }
                if (!(entryValue instanceof Entry) || (entry = (Entry)entryValue).isDynamic() || entry.isRemote() || SynapseConstants.SERVER_IP.equals(key = entry.getKey()) || SynapseConstants.SERVER_HOST.equals(key)) continue;
                entryList.add(key);
            }
            if (!sequenceList.isEmpty()) {
                Collections.sort(sequenceList, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                });
                for (String name : sequenceList) {
                    if (name == null) continue;
                    sequenceSb.append("[Sequence]-").append(name).append(" ");
                }
            }
            if (!entryList.isEmpty()) {
                Collections.sort(entryList, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                });
                for (String name : entryList) {
                    if (name == null) continue;
                    entrySb.append("[Entry]-").append(name).append(" ");
                }
            }
            if (!endpointList.isEmpty()) {
                Collections.sort(endpointList, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                });
                for (String name : endpointList) {
                    if (name == null) continue;
                    endpointSb.append("[Enpoint]-").append(name).append(" ");
                }
            }
            return endpointSb.toString() + entrySb.toString() + sequenceSb.toString();
        }
        catch (AxisFault axisFault) {
            this.handleException("Error during retrieving local registry", axisFault);
            return "";
        }
    }
}

