/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sequences;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediation.initializer.services.SynapseConfigurationService;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.sequences.util.ConfigHolder;
import org.wso2.carbon.utils.ConfigurationContextService;

public class SequenceEditorServiceComponent {
    private static final Log log = LogFactory.getLog(SequenceEditorServiceComponent.class);

    protected void setConfigurationContextService(ConfigurationContextService cfgCtxService) {
        ConfigHolder.getInstance().setAxisConfiguration(cfgCtxService.getServerConfigContext().getAxisConfiguration());
    }

    protected void unsetConfigurationContextService(ConfigurationContextService cfgCtxService) {
        ConfigHolder.getInstance().setAxisConfiguration(null);
    }

    protected void setSynapseConfigurationService(SynapseConfigurationService synapseConfigurationService) {
        ConfigHolder.getInstance().setSynapseConfiguration(synapseConfigurationService.getSynapseConfiguration());
    }

    protected void unsetSynapseConfigurationService(SynapseConfigurationService synapseConfigurationService) {
        ConfigHolder.getInstance().setSynapseConfiguration(null);
    }

    protected void setSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        ConfigHolder.getInstance().setSynapseEnvironment(synapseEnvironmentService.getSynapseEnvironment());
    }

    protected void unsetSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        ConfigHolder.getInstance().setSynapseEnvironment(null);
    }

    protected void setRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService bound to the ESB initialization process");
        }
        try {
            ConfigHolder.getInstance().setRegistry(regService.getSystemRegistry());
        }
        catch (RegistryException e) {
            log.error((Object)"Couldn't retrieve the registry from the registry service");
        }
    }

    protected void unsetRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unbound from the ESB environment");
        }
        ConfigHolder.getInstance().setRegistry(null);
    }
}

