/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sequences.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.MediatorFactoryFinder;
import org.apache.synapse.config.xml.MediatorSerializerFinder;
import org.apache.synapse.config.xml.SynapseXMLConfigurationFactory;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.registry.Registry;
import org.wso2.carbon.mediation.initializer.persistence.SequenceRegistryStore;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.ws.utils.CommonUtil;
import org.wso2.carbon.sequences.common.ISequenceAdmin;
import org.wso2.carbon.sequences.common.SequenceEditorException;
import org.wso2.carbon.sequences.common.factory.SequenceInfoFactory;
import org.wso2.carbon.sequences.common.to.SequenceInfo;
import org.wso2.carbon.sequences.util.ConfigHolder;
import org.wso2.carbon.utils.CarbonUtils;

public class SequenceAdmin
implements ISequenceAdmin {
    private static final Log log = LogFactory.getLog(SequenceAdmin.class);
    public static final String WSO2_SEQUENCE_MEDIA_TYPE = "application/vnd+wso2.sequence";

    public SequenceInfo[] getSequences() throws SequenceEditorException {
        Collection sequences = null;
        try {
            sequences = ConfigHolder.getInstance().getSynapseConfiguration().getDefinedSequences().values();
        }
        catch (Exception fault) {
            this.handleException("Couldn't get the Synapse Configuration to get the available sequences", fault);
        }
        return SequenceInfoFactory.getSortedSequenceInfoArray(sequences);
    }

    public SequenceInfo[] getDynamicSequences() throws SequenceEditorException {
        SequenceInfo[] info = null;
        if (CarbonUtils.isRegistryReadOnly()) {
            log.warn((Object)"Editing registry sequences disabled when registry is in READ-ONLY mode");
            return null;
        }
        try {
            UserRegistry registry = CommonUtil.getRegistry();
            String sql1 = "SELECT REG_PATH_ID, REG_NAME FROM REG_RESOURCE WHERE REG_MEDIA_TYPE = ?";
            Resource q1 = registry.newResource();
            q1.setContent((Object)sql1);
            q1.setMediaType("application/vnd.sql.query");
            q1.addProperty("resultType", "Resource");
            registry.put("/esb-resources/mime-type-query", q1);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("1", WSO2_SEQUENCE_MEDIA_TYPE);
            org.wso2.carbon.registry.core.Collection result = registry.executeQuery("/esb-resources/mime-type-query", parameters);
            String[] paths = (String[])result.getContent();
            info = new SequenceInfo[paths.length];
            for (int i = 0; i < info.length; ++i) {
                SequenceInfo seq = new SequenceInfo();
                seq.setName(paths[i]);
                info[i] = seq;
            }
            registry.delete("/esb-resources/mime-type-query");
        }
        catch (RegistryException e) {
            return null;
        }
        return info;
    }

    public void deleteSequence(String sequenceName) throws SequenceEditorException {
        try {
            SynapseConfiguration synCfg = ConfigHolder.getInstance().getSynapseConfiguration();
            if (synCfg.getSequence(sequenceName) != null) {
                synCfg.removeSequence(sequenceName);
                SequenceRegistryStore store = new SequenceRegistryStore(ConfigHolder.getInstance().getRegistry());
                store.deleteElement(sequenceName);
            } else {
                this.handleException("No defined sequence with name " + sequenceName + " found to delete in the Synapse configuration");
            }
        }
        catch (Exception fault) {
            this.handleException("Couldn't get the Synapse Configuration to delete the sequence", fault);
        }
    }

    public OMElement getSequence(String sequenceName) throws SequenceEditorException {
        try {
            SynapseConfiguration synapseConfiguration = ConfigHolder.getInstance().getSynapseConfiguration();
            if (synapseConfiguration.getSequence(sequenceName) != null) {
                return MediatorSerializerFinder.getInstance().getSerializer(synapseConfiguration.getSequence(sequenceName)).serializeMediator(null, synapseConfiguration.getSequence(sequenceName));
            }
            this.handleException("Sequence with the name " + sequenceName + " does not exist");
        }
        catch (SynapseException syne) {
            this.handleException("Unable to get the sequence : " + sequenceName, syne);
        }
        catch (Exception fault) {
            this.handleException("Couldn't get the Synapse Configuration to get the sequence", fault);
        }
        return null;
    }

    public void addSequence(OMElement sequenceElement) throws SequenceEditorException {
        try {
            if (sequenceElement.getLocalName().equals(XMLConfigConstants.SEQUENCE_ELT.getLocalPart())) {
                String sequenceName = sequenceElement.getAttributeValue(new QName("name"));
                SynapseConfiguration config = ConfigHolder.getInstance().getSynapseConfiguration();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding sequence : " + sequenceName + " to the configuration"));
                }
                if (config.getLocalRegistry().get(sequenceName) != null) {
                    this.handleException("The name '" + sequenceName + "' is already used within the configuration");
                } else {
                    Mediator seq;
                    SynapseXMLConfigurationFactory.defineSequence((SynapseConfiguration)config, (OMElement)sequenceElement);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Added sequence : " + sequenceName + " to the configuration"));
                    }
                    if ((seq = config.getSequence(sequenceName)) != null && seq instanceof ManagedLifecycle) {
                        ((ManagedLifecycle)seq).init(ConfigHolder.getInstance().getSynapseEnvironment());
                    }
                    this.persistSequence((SequenceMediator)seq);
                }
            } else {
                this.handleException("Invalid sequence definition");
            }
        }
        catch (Exception fault) {
            this.handleException("Error adding sequence : " + fault.getMessage(), fault);
        }
        catch (Error error) {
            throw new SequenceEditorException("Unexpected error occured while adding the sequence : " + error.getMessage(), (Throwable)error);
        }
    }

    public void saveSequence(OMElement sequenceElement) throws SequenceEditorException {
        try {
            if (sequenceElement != null && sequenceElement.getLocalName().equals(XMLConfigConstants.SEQUENCE_ELT.getLocalPart())) {
                String sequenceName = sequenceElement.getAttributeValue(new QName("name"));
                SynapseConfiguration config = ConfigHolder.getInstance().getSynapseConfiguration();
                log.debug((Object)("Saving sequence : " + sequenceName));
                if (config.getSequence(sequenceName) == null) {
                    this.handleException("Unable to save sequence " + sequenceName + ". Does not exist");
                } else {
                    Mediator mediator = MediatorFactoryFinder.getInstance().getMediator(sequenceElement);
                    SequenceMediator preSeq = (SequenceMediator)config.getSequence(sequenceName);
                    boolean statisticsEnable = preSeq != null && preSeq.isStatisticsEnable();
                    config.removeSequence(sequenceName);
                    if (statisticsEnable && mediator instanceof SequenceMediator) {
                        ((SequenceMediator)mediator).enableStatistics();
                    }
                    config.addSequence(sequenceName, mediator);
                    log.debug((Object)("Saved sequence : " + sequenceName + " to the configuration"));
                    Mediator seq = config.getSequence(sequenceName);
                    if (seq != null && seq instanceof ManagedLifecycle) {
                        ((ManagedLifecycle)seq).init(ConfigHolder.getInstance().getSynapseEnvironment());
                    }
                    this.persistSequence((SequenceMediator)seq);
                }
            } else {
                this.handleException("Unable to save sequence. Invalid definition");
            }
        }
        catch (Exception fault) {
            this.handleException("Unable to save the Sequence : " + fault.getMessage(), fault);
        }
    }

    public String enableStatistics(String sequenceName) throws SequenceEditorException {
        try {
            SequenceMediator sequence = (SequenceMediator)ConfigHolder.getInstance().getSynapseConfiguration().getSequence(sequenceName);
            if (sequence != null) {
                sequence.enableStatistics();
                this.persistSequence(sequence);
                return sequenceName;
            }
            this.handleException("No defined sequence with name " + sequenceName + " found to enable statistics in the Synapse configuration");
        }
        catch (Exception fault) {
            this.handleException("Couldn't enable statistics of the sequence " + sequenceName + " : " + fault.getMessage(), fault);
        }
        return null;
    }

    public String disableStatistics(String sequenceName) throws SequenceEditorException {
        try {
            SequenceMediator sequence = (SequenceMediator)ConfigHolder.getInstance().getSynapseConfiguration().getSequence(sequenceName);
            if (sequence != null) {
                sequence.disableStatistics();
                this.persistSequence(sequence);
                return sequenceName;
            }
            this.handleException("No defined sequence with name " + sequenceName + " found to disable statistics in the Synapse configuration");
        }
        catch (Exception fault) {
            this.handleException("Couldn't disable statistics of the sequence " + sequenceName + " : " + fault.getMessage(), fault);
        }
        return null;
    }

    public String enableTracing(String sequenceName) throws SequenceEditorException {
        try {
            SequenceMediator sequence = (SequenceMediator)ConfigHolder.getInstance().getSynapseConfiguration().getSequence(sequenceName);
            if (sequence != null) {
                sequence.setTraceState(1);
                this.persistSequence(sequence);
                return sequenceName;
            }
            this.handleException("No defined sequence with name " + sequenceName + " found to enable tracing in the Synapse configuration");
        }
        catch (Exception fault) {
            this.handleException("Couldn't enable tracing of the sequence " + sequenceName + " : " + fault.getMessage(), fault);
        }
        return null;
    }

    public String disableTracing(String sequenceName) throws SequenceEditorException {
        try {
            SequenceMediator sequence = (SequenceMediator)ConfigHolder.getInstance().getSynapseConfiguration().getSequence(sequenceName);
            if (sequence != null) {
                sequence.setTraceState(0);
                this.persistSequence(sequence);
                return sequenceName;
            }
            this.handleException("No defined sequence with name " + sequenceName + " found to disable tracing in the Synapse configuration");
        }
        catch (Exception fault) {
            this.handleException("Couldn't disable tracing of the sequence " + sequenceName + " : " + fault.getMessage(), fault);
        }
        return null;
    }

    private void handleException(String message, Throwable cause) throws SequenceEditorException {
        log.error((Object)message, cause);
        throw new SequenceEditorException(message, cause);
    }

    private void handleException(String message) throws SequenceEditorException {
        log.error((Object)message);
        throw new SequenceEditorException(message);
    }

    public String getEntryNamesString() throws SequenceEditorException {
        try {
            SynapseConfiguration synapseConfiguration = ConfigHolder.getInstance().getSynapseConfiguration();
            Map globalEntriesMap = synapseConfiguration.getLocalRegistry();
            ArrayList<String> sequenceList = new ArrayList<String>();
            ArrayList<String> endpointList = new ArrayList<String>();
            ArrayList<String> entryList = new ArrayList<String>();
            StringBuffer entrySb = new StringBuffer();
            StringBuffer endpointSb = new StringBuffer();
            StringBuffer sequenceSb = new StringBuffer();
            for (Object entryValue : globalEntriesMap.values()) {
                String key;
                Entry entry;
                String name;
                if (entryValue instanceof Endpoint) {
                    Endpoint endpoint = (Endpoint)entryValue;
                    name = endpoint.getName();
                    if (name == null) continue;
                    endpointList.add(name);
                    continue;
                }
                if (entryValue instanceof SequenceMediator) {
                    SequenceMediator sequenceMediator = (SequenceMediator)entryValue;
                    name = sequenceMediator.getName();
                    if (name == null) continue;
                    sequenceList.add(name);
                    continue;
                }
                if (!(entryValue instanceof Entry) || (entry = (Entry)entryValue).isDynamic() || entry.isRemote() || "SERVER_IP".equals(key = entry.getKey()) || "SERVER_HOST".equals(key)) continue;
                entryList.add(key);
            }
            if (!sequenceList.isEmpty()) {
                Collections.sort(sequenceList, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                });
                for (String name : sequenceList) {
                    if (name == null) continue;
                    sequenceSb.append("[Sequence]-").append(name).append(" ");
                }
            }
            if (!entryList.isEmpty()) {
                Collections.sort(entryList, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                });
                for (String name : entryList) {
                    if (name == null) continue;
                    entrySb.append("[Entry]-").append(name).append(" ");
                }
            }
            if (!endpointList.isEmpty()) {
                Collections.sort(endpointList, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                });
                for (String name : endpointList) {
                    if (name == null) continue;
                    endpointSb.append("[Enpoint]-").append(name).append(" ");
                }
            }
            return endpointSb.toString() + entrySb.toString() + sequenceSb.toString();
        }
        catch (Exception axisFault) {
            this.handleException("Error during retrieving local registry", axisFault);
            return "";
        }
    }

    public void addDynamicSequence(String key, OMElement sequence) throws SequenceEditorException {
        try {
            UserRegistry registry = CommonUtil.getRegistry();
            if (!registry.resourceExists(key)) {
                Resource resource = registry.newResource();
                resource.setMediaType(WSO2_SEQUENCE_MEDIA_TYPE);
                resource.setContent((Object)sequence.toString());
                registry.put(key, resource);
            } else {
                this.handleException("Resource is already exists");
            }
        }
        catch (RegistryException e) {
            this.handleException("WSO2 Registry Exception", e);
        }
    }

    public void deleteDynamicSequence(String key) throws SequenceEditorException {
        SynapseConfiguration synConfig = ConfigHolder.getInstance().getSynapseConfiguration();
        Registry registry = synConfig.getRegistry();
        if (registry != null) {
            if (registry.getRegistryEntry(key).getType() == null) {
                this.handleException("The key '" + key + "' cannot be found within the configuration");
            } else {
                registry.delete(key);
            }
        } else {
            this.handleException("Unable to access the registry instance for the ESB");
        }
    }

    public void updateDynamicSequence(String key, OMElement omElement) throws SequenceEditorException {
        this.deleteDynamicSequence(key);
        this.addDynamicSequence(key, omElement);
    }

    public OMElement getDynamicSequence(String key) throws SequenceEditorException {
        SynapseConfiguration synConfig = ConfigHolder.getInstance().getSynapseConfiguration();
        Registry registry = synConfig.getRegistry();
        if (registry != null) {
            if (registry.getRegistryEntry(key).getType() == null) {
                this.handleException("No resource is available by the key '" + key + "'");
            }
        } else {
            this.handleException("Unable to access the registry instance for the ESB");
        }
        OMElement ret = null;
        try {
            ret = (OMElement)registry.getResource(new Entry(key));
        }
        catch (Exception e) {
            log.warn((Object)("Unable to construct sequence from registry enrty " + key));
        }
        return ret;
    }

    public void saveDynamicSequence(String key, OMElement sequence) throws SequenceEditorException {
        try {
            UserRegistry registry = CommonUtil.getRegistry();
            Resource resource = registry.newResource();
            resource.setMediaType("application/endpoint");
            resource.setContent((Object)sequence);
            registry.put(key, resource);
        }
        catch (RegistryException e) {
            this.handleException("WSO2 Registry Exception", e);
        }
    }

    private void persistSequence(SequenceMediator sequence) throws SequenceEditorException {
        SequenceRegistryStore store = new SequenceRegistryStore(ConfigHolder.getInstance().getRegistry());
        store.persistElement(sequence.getName(), MediatorSerializerFinder.getInstance().getSerializer((Mediator)sequence).serializeMediator(null, (Mediator)sequence));
    }
}

