/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sequences;

import java.io.File;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.deployers.SynapseArtifactDeploymentStore;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.mediation.dependency.mgt.services.DependencyManagementService;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.services.SynapseConfigurationService;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.sequences.SequenceDeployer;
import org.wso2.carbon.sequences.common.ISequenceAdmin;
import org.wso2.carbon.sequences.common.SequenceEditorException;
import org.wso2.carbon.sequences.services.SequenceAdmin;
import org.wso2.carbon.sequences.util.ConfigHolder;
import org.wso2.carbon.utils.ConfigurationContextService;

public class SequenceEditorServiceComponent {
    private static final Log log = LogFactory.getLog(SequenceEditorServiceComponent.class);

    protected void activate(ComponentContext ctxt) {
        try {
            BundleContext bc = ctxt.getBundleContext();
            bc.registerService(ISequenceAdmin.class.getName(), (Object)new SequenceAdmin(), null);
            this.registerDeployer();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Sequence Admin bundle is activated ");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate Sequence Admin bundle ", e);
        }
    }

    protected void deactivate(ComponentContext context) {
        try {
            AxisConfiguration axisConfig = ConfigHolder.getInstance().getAxisConfiguration();
            if (axisConfig != null) {
                DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
                String synapseConfigPath = ServiceBusUtils.getSynapseConfigAbsPath();
                String sequencesDirPath = synapseConfigPath + File.separator + "sequences";
                deploymentEngine.removeDeployer(sequencesDirPath, "xml");
            }
        }
        catch (SequenceEditorException e) {
            log.warn((Object)"Couldn't remove the SequenceDeployer");
        }
    }

    private void registerDeployer() throws SequenceEditorException {
        AxisConfiguration axisConfig = ConfigHolder.getInstance().getAxisConfiguration();
        SynapseConfiguration synCfg = ConfigHolder.getInstance().getSynapseConfiguration();
        DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
        SynapseArtifactDeploymentStore deploymentStore = SynapseArtifactDeploymentStore.getInstance();
        String synapseConfigPath = ServiceBusUtils.getSynapseConfigAbsPath();
        String sequenceDirPath = synapseConfigPath + File.separator + "sequences";
        for (SequenceMediator seq : synCfg.getDefinedSequences().values()) {
            if (seq.getFileName() == null) continue;
            deploymentStore.addRestoredArtifact(sequenceDirPath + File.separator + seq.getFileName());
        }
        deploymentEngine.addDeployer((Deployer)new SequenceDeployer(), sequenceDirPath, "xml");
    }

    protected void setConfigurationContextService(ConfigurationContextService cfgCtxService) {
        ConfigHolder.getInstance().setAxisConfiguration(cfgCtxService.getServerConfigContext().getAxisConfiguration());
    }

    protected void unsetConfigurationContextService(ConfigurationContextService cfgCtxService) {
        ConfigHolder.getInstance().setAxisConfiguration(null);
    }

    protected void setSynapseConfigurationService(SynapseConfigurationService synapseConfigurationService) {
        ConfigHolder.getInstance().setSynapseConfiguration(synapseConfigurationService.getSynapseConfiguration());
    }

    protected void unsetSynapseConfigurationService(SynapseConfigurationService synapseConfigurationService) {
        ConfigHolder.getInstance().setSynapseConfiguration(null);
    }

    protected void setSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        ConfigHolder.getInstance().setSynapseEnvironment(synapseEnvironmentService.getSynapseEnvironment());
    }

    protected void unsetSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        ConfigHolder.getInstance().setSynapseEnvironment(null);
    }

    protected void setRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService bound to the ESB initialization process");
        }
        try {
            ConfigHolder.getInstance().setConfigRegistry(regService.getConfigSystemRegistry());
            ConfigHolder.getInstance().setGovernanceRegistry(regService.getGovernanceSystemRegistry());
        }
        catch (RegistryException e) {
            log.error((Object)"Couldn't retrieve the registry from the registry service");
        }
    }

    protected void unsetRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unbound from the ESB environment");
        }
        ConfigHolder.getInstance().setConfigRegistry(null);
    }

    protected void setDependencyManager(DependencyManagementService dependencyMgr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Dependency management service bound to the endpoint component");
        }
        ConfigHolder.getInstance().setDependencyManager(dependencyMgr);
    }

    protected void unsetDependencyManager(DependencyManagementService dependencyMgr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Dependency management service unbound from the endpoint component");
        }
        ConfigHolder.getInstance().setDependencyManager(null);
    }
}

