/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sequences.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.MediatorFactoryFinder;
import org.apache.synapse.config.xml.MediatorSerializerFinder;
import org.apache.synapse.config.xml.SynapseXMLConfigurationFactory;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.registry.Registry;
import org.wso2.carbon.mediation.dependency.mgt.services.DependencyManagementService;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.sequences.common.ISequenceAdmin;
import org.wso2.carbon.sequences.common.SequenceEditorException;
import org.wso2.carbon.sequences.common.factory.SequenceInfoFactory;
import org.wso2.carbon.sequences.common.to.ConfigurationObject;
import org.wso2.carbon.sequences.common.to.SequenceInfo;
import org.wso2.carbon.sequences.util.ConfigHolder;

public class SequenceAdmin
implements ISequenceAdmin {
    private static final Log log = LogFactory.getLog(SequenceAdmin.class);
    public static final String WSO2_SEQUENCE_MEDIA_TYPE = "application/vnd+wso2.sequence";

    public SequenceInfo[] getSequences(int pageNumber, int sequencePerPage) throws SequenceEditorException {
        Collection sequences = null;
        try {
            sequences = ConfigHolder.getInstance().getSynapseConfiguration().getDefinedSequences().values();
        }
        catch (Exception fault) {
            this.handleException("Couldn't get the Synapse Configuration to get the available sequences", fault);
        }
        SequenceInfo[] info = SequenceInfoFactory.getSortedSequenceInfoArray(sequences);
        SequenceInfo[] ret = info.length >= sequencePerPage * pageNumber + sequencePerPage ? new SequenceInfo[sequencePerPage] : new SequenceInfo[info.length - sequencePerPage * pageNumber];
        for (int i = 0; i < sequencePerPage; ++i) {
            if (ret.length <= i) continue;
            ret[i] = info[sequencePerPage * pageNumber + i];
        }
        return ret;
    }

    public int getSequencesCount() throws SequenceEditorException {
        try {
            return ConfigHolder.getInstance().getSynapseConfiguration().getDefinedSequences().values().size();
        }
        catch (Exception e) {
            this.handleException("Couldn't get the Synapse Configuration to get Sequence count", e);
            return 0;
        }
    }

    public SequenceInfo[] getDynamicSequences(int pageNumber, int sequencePerPage) throws SequenceEditorException {
        SequenceInfo[] ret;
        try {
            UserRegistry registry = ConfigHolder.getInstance().getConfigRegistry();
            if (registry.getRegistryContext().isReadOnly()) {
                log.warn((Object)"Editing registry sequences disabled when registry is in READ-ONLY mode");
                return null;
            }
            String[] configInfo = this.getMimeTypeResult(ConfigHolder.getInstance().getConfigRegistry());
            String[] govInfo = this.getMimeTypeResult(ConfigHolder.getInstance().getGovernanceRegistry());
            String[] info = new String[configInfo.length + govInfo.length];
            int ptr = 0;
            for (String aConfigInfo : configInfo) {
                info[ptr] = "conf:" + aConfigInfo;
                ++ptr;
            }
            for (String aGovInfo : govInfo) {
                info[ptr] = "gov:" + aGovInfo;
                ++ptr;
            }
            ret = info.length >= sequencePerPage * pageNumber + sequencePerPage ? new SequenceInfo[sequencePerPage] : new SequenceInfo[info.length - sequencePerPage * pageNumber];
            for (int i = 0; i < sequencePerPage; ++i) {
                if (ret.length <= i) continue;
                SequenceInfo seq = new SequenceInfo();
                seq.setName(info[sequencePerPage * pageNumber + i]);
                ret[i] = seq;
            }
        }
        catch (Exception e) {
            this.handleException("Unable to get Dynamic Sequence Info", e);
            return null;
        }
        return ret;
    }

    public int getDynamicSequenceCount() throws SequenceEditorException {
        try {
            UserRegistry registry = ConfigHolder.getInstance().getConfigRegistry();
            if (registry.getRegistryContext().isReadOnly()) {
                log.warn((Object)"Editing registry sequences disabled when registry is in READ-ONLY mode");
                return 0;
            }
            String[] govList = this.getMimeTypeResult(ConfigHolder.getInstance().getGovernanceRegistry());
            String[] confList = this.getMimeTypeResult(ConfigHolder.getInstance().getConfigRegistry());
            return confList.length + govList.length;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private String[] getMimeTypeResult(UserRegistry targetRegistry) throws Exception {
        UserRegistry registry = ConfigHolder.getInstance().getConfigRegistry();
        String sql = "SELECT REG_PATH_ID, REG_NAME FROM REG_RESOURCE WHERE REG_MEDIA_TYPE = ?";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("query", sql);
        parameters.put("1", WSO2_SEQUENCE_MEDIA_TYPE);
        org.wso2.carbon.registry.core.Collection result = targetRegistry.executeQuery(null, parameters);
        return (String[])result.getContent();
    }

    public void deleteSequence(String sequenceName) throws SequenceEditorException {
        try {
            SynapseConfiguration synCfg = ConfigHolder.getInstance().getSynapseConfiguration();
            SequenceMediator sequence = (SequenceMediator)synCfg.getDefinedSequences().get(sequenceName);
            if (sequence != null) {
                synCfg.removeSequence(sequenceName);
                MediationPersistenceManager pm = MediationPersistenceManager.getInstance();
                pm.deleteItem(sequenceName, sequence.getFileName(), 1);
            } else {
                this.handleException("No defined sequence with name " + sequenceName + " found to delete in the Synapse configuration");
            }
        }
        catch (Exception fault) {
            this.handleException("Couldn't get the Synapse Configuration to delete the sequence", fault);
        }
    }

    public OMElement getSequence(String sequenceName) throws SequenceEditorException {
        try {
            SynapseConfiguration synapseConfiguration = ConfigHolder.getInstance().getSynapseConfiguration();
            if (synapseConfiguration.getSequence(sequenceName) != null) {
                return MediatorSerializerFinder.getInstance().getSerializer(synapseConfiguration.getSequence(sequenceName)).serializeMediator(null, synapseConfiguration.getSequence(sequenceName));
            }
            this.handleException("Sequence with the name " + sequenceName + " does not exist");
        }
        catch (SynapseException syne) {
            this.handleException("Unable to get the sequence : " + sequenceName, syne);
        }
        catch (Exception fault) {
            this.handleException("Couldn't get the Synapse Configuration to get the sequence", fault);
        }
        return null;
    }

    public void addSequence(OMElement sequenceElement) throws SequenceEditorException {
        try {
            if (sequenceElement.getLocalName().equals(XMLConfigConstants.SEQUENCE_ELT.getLocalPart())) {
                String sequenceName = sequenceElement.getAttributeValue(new QName("name"));
                SynapseConfiguration config = ConfigHolder.getInstance().getSynapseConfiguration();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding sequence : " + sequenceName + " to the configuration"));
                }
                if (config.getLocalRegistry().get(sequenceName) != null) {
                    this.handleException("The name '" + sequenceName + "' is already used within the configuration");
                } else {
                    SynapseXMLConfigurationFactory.defineSequence((SynapseConfiguration)config, (OMElement)sequenceElement);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Added sequence : " + sequenceName + " to the configuration"));
                    }
                    SequenceMediator seq = (SequenceMediator)config.getDefinedSequences().get(sequenceName);
                    seq.setFileName(MediationPersistenceManager.generateFileName((String)sequenceName));
                    if (seq != null && seq instanceof ManagedLifecycle) {
                        seq.init(ConfigHolder.getInstance().getSynapseEnvironment());
                    }
                    this.persistSequence(seq);
                }
            } else {
                this.handleException("Invalid sequence definition");
            }
        }
        catch (Exception fault) {
            this.handleException("Error adding sequence : " + fault.getMessage(), fault);
        }
        catch (Error error) {
            throw new SequenceEditorException("Unexpected error occured while adding the sequence : " + error.getMessage(), (Throwable)error);
        }
    }

    public void saveSequence(OMElement sequenceElement) throws SequenceEditorException {
        try {
            if (sequenceElement != null && sequenceElement.getLocalName().equals(XMLConfigConstants.SEQUENCE_ELT.getLocalPart())) {
                String sequenceName = sequenceElement.getAttributeValue(new QName("name"));
                SynapseConfiguration config = ConfigHolder.getInstance().getSynapseConfiguration();
                log.debug((Object)("Saving sequence : " + sequenceName));
                if (config.getDefinedSequences().get(sequenceName) == null) {
                    this.handleException("Unable to save sequence " + sequenceName + ". Does not exist");
                } else {
                    Mediator mediator = MediatorFactoryFinder.getInstance().getMediator(sequenceElement);
                    SequenceMediator preSeq = (SequenceMediator)config.getDefinedSequences().get(sequenceName);
                    boolean statisticsEnable = preSeq != null && preSeq.isStatisticsEnable();
                    config.removeSequence(sequenceName);
                    if (mediator instanceof SequenceMediator) {
                        if (statisticsEnable) {
                            ((SequenceMediator)mediator).enableStatistics();
                        }
                        ((SequenceMediator)mediator).setFileName(preSeq.getFileName());
                    }
                    config.addSequence(sequenceName, mediator);
                    log.debug((Object)("Saved sequence : " + sequenceName + " to the configuration"));
                    SequenceMediator seq = (SequenceMediator)config.getDefinedSequences().get(sequenceName);
                    if (seq != null && seq instanceof ManagedLifecycle) {
                        seq.init(ConfigHolder.getInstance().getSynapseEnvironment());
                    }
                    this.persistSequence(seq);
                }
            } else {
                this.handleException("Unable to save sequence. Invalid definition");
            }
        }
        catch (Exception fault) {
            this.handleException("Unable to save the Sequence : " + fault.getMessage(), fault);
        }
    }

    public String enableStatistics(String sequenceName) throws SequenceEditorException {
        try {
            SequenceMediator sequence = (SequenceMediator)ConfigHolder.getInstance().getSynapseConfiguration().getSequence(sequenceName);
            if (sequence != null) {
                sequence.enableStatistics();
                this.persistSequence(sequence);
                return sequenceName;
            }
            this.handleException("No defined sequence with name " + sequenceName + " found to enable statistics in the Synapse configuration");
        }
        catch (Exception fault) {
            this.handleException("Couldn't enable statistics of the sequence " + sequenceName + " : " + fault.getMessage(), fault);
        }
        return null;
    }

    public String disableStatistics(String sequenceName) throws SequenceEditorException {
        try {
            SequenceMediator sequence = (SequenceMediator)ConfigHolder.getInstance().getSynapseConfiguration().getSequence(sequenceName);
            if (sequence != null) {
                sequence.disableStatistics();
                this.persistSequence(sequence);
                return sequenceName;
            }
            this.handleException("No defined sequence with name " + sequenceName + " found to disable statistics in the Synapse configuration");
        }
        catch (Exception fault) {
            this.handleException("Couldn't disable statistics of the sequence " + sequenceName + " : " + fault.getMessage(), fault);
        }
        return null;
    }

    public String enableTracing(String sequenceName) throws SequenceEditorException {
        try {
            SequenceMediator sequence = (SequenceMediator)ConfigHolder.getInstance().getSynapseConfiguration().getSequence(sequenceName);
            if (sequence != null) {
                sequence.setTraceState(1);
                this.persistSequence(sequence);
                return sequenceName;
            }
            this.handleException("No defined sequence with name " + sequenceName + " found to enable tracing in the Synapse configuration");
        }
        catch (Exception fault) {
            this.handleException("Couldn't enable tracing of the sequence " + sequenceName + " : " + fault.getMessage(), fault);
        }
        return null;
    }

    public String disableTracing(String sequenceName) throws SequenceEditorException {
        try {
            SequenceMediator sequence = (SequenceMediator)ConfigHolder.getInstance().getSynapseConfiguration().getSequence(sequenceName);
            if (sequence != null) {
                sequence.setTraceState(0);
                this.persistSequence(sequence);
                return sequenceName;
            }
            this.handleException("No defined sequence with name " + sequenceName + " found to disable tracing in the Synapse configuration");
        }
        catch (Exception fault) {
            this.handleException("Couldn't disable tracing of the sequence " + sequenceName + " : " + fault.getMessage(), fault);
        }
        return null;
    }

    private void handleException(String message, Throwable cause) throws SequenceEditorException {
        log.error((Object)message, cause);
        throw new SequenceEditorException(message, cause);
    }

    private void handleException(String message) throws SequenceEditorException {
        log.error((Object)message);
        throw new SequenceEditorException(message);
    }

    public String getEntryNamesString() throws SequenceEditorException {
        try {
            SynapseConfiguration synapseConfiguration = ConfigHolder.getInstance().getSynapseConfiguration();
            Map globalEntriesMap = synapseConfiguration.getLocalRegistry();
            ArrayList<String> sequenceList = new ArrayList<String>();
            ArrayList<String> endpointList = new ArrayList<String>();
            ArrayList<String> entryList = new ArrayList<String>();
            StringBuffer entrySb = new StringBuffer();
            StringBuffer endpointSb = new StringBuffer();
            StringBuffer sequenceSb = new StringBuffer();
            for (Object entryValue : globalEntriesMap.values()) {
                String key;
                Entry entry;
                String name;
                if (entryValue instanceof Endpoint) {
                    Endpoint endpoint = (Endpoint)entryValue;
                    name = endpoint.getName();
                    if (name == null) continue;
                    endpointList.add(name);
                    continue;
                }
                if (entryValue instanceof SequenceMediator) {
                    SequenceMediator sequenceMediator = (SequenceMediator)entryValue;
                    name = sequenceMediator.getName();
                    if (name == null) continue;
                    sequenceList.add(name);
                    continue;
                }
                if (!(entryValue instanceof Entry) || (entry = (Entry)entryValue).isDynamic() || entry.isRemote() || "SERVER_IP".equals(key = entry.getKey()) || "SERVER_HOST".equals(key)) continue;
                entryList.add(key);
            }
            if (!sequenceList.isEmpty()) {
                Collections.sort(sequenceList, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                });
                for (String name : sequenceList) {
                    if (name == null) continue;
                    sequenceSb.append("[Sequence]-").append(name).append(" ");
                }
            }
            if (!entryList.isEmpty()) {
                Collections.sort(entryList, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                });
                for (String name : entryList) {
                    if (name == null) continue;
                    entrySb.append("[Entry]-").append(name).append(" ");
                }
            }
            if (!endpointList.isEmpty()) {
                Collections.sort(endpointList, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                });
                for (String name : endpointList) {
                    if (name == null) continue;
                    endpointSb.append("[Endpoint]-").append(name).append(" ");
                }
            }
            return endpointSb.toString() + entrySb.toString() + sequenceSb.toString();
        }
        catch (Exception axisFault) {
            this.handleException("Error during retrieving local registry", axisFault);
            return "";
        }
    }

    public void updateDynamicSequence(String key, OMElement omElement) throws SequenceEditorException {
        this.deleteDynamicSequence(key);
        this.addDynamicSequence(key, omElement);
    }

    public void deleteDynamicSequence(String key) throws SequenceEditorException {
        SynapseConfiguration synConfig = ConfigHolder.getInstance().getSynapseConfiguration();
        Registry registry = synConfig.getRegistry();
        if (registry != null) {
            if (registry.getRegistryEntry(key).getType() == null) {
                this.handleException("The key '" + key + "' cannot be found within the configuration");
            } else {
                registry.delete(key);
            }
        } else {
            this.handleException("Unable to access the registry instance for the ESB");
        }
    }

    public void addDynamicSequence(String key, OMElement sequence) throws SequenceEditorException {
        try {
            UserRegistry registry;
            if (key.startsWith("conf:")) {
                registry = ConfigHolder.getInstance().getConfigRegistry();
                key = key.replace("conf:", "");
            } else {
                registry = ConfigHolder.getInstance().getGovernanceRegistry();
                key = key.replace("gov:", "");
            }
            if (registry.resourceExists(key)) {
                this.handleException("Resource is already exists");
            }
            Resource resource = registry.newResource();
            resource.setMediaType(WSO2_SEQUENCE_MEDIA_TYPE);
            resource.setContent((Object)sequence.toString());
            registry.put(key, resource);
        }
        catch (RegistryException e) {
            this.handleException("WSO2 Registry Exception", e);
        }
    }

    public OMElement getDynamicSequence(String key) throws SequenceEditorException {
        SynapseConfiguration synConfig = ConfigHolder.getInstance().getSynapseConfiguration();
        Registry registry = synConfig.getRegistry();
        if (registry != null) {
            if (registry.getRegistryEntry(key).getType() == null) {
                this.handleException("No resource is available by the key '" + key + "'");
            }
            return (OMElement)registry.getResource(new Entry(key));
        }
        this.handleException("Unable to access the registry instance for the ESB");
        return null;
    }

    public void saveDynamicSequence(String key, OMElement sequence) throws SequenceEditorException {
        SynapseConfiguration synConfig = ConfigHolder.getInstance().getSynapseConfiguration();
        Registry registry = synConfig.getRegistry();
        if (registry != null) {
            if (registry.getRegistryEntry(key).getType() == null) {
                this.handleException("Unable to save the sequence. No resource is available by the key '" + key + "'");
            }
            registry.updateResource(key, (Object)sequence);
        } else {
            this.handleException("Unable to access the registry instance for the ESB");
        }
    }

    public ConfigurationObject[] getDependents(String sequence) {
        org.wso2.carbon.mediation.dependency.mgt.ConfigurationObject[] tempDependents;
        DependencyManagementService dependencyMgr = ConfigHolder.getInstance().getDependencyManager();
        if (dependencyMgr != null && (tempDependents = dependencyMgr.getDependents(1, sequence)) != null) {
            ConfigurationObject[] dependents = new ConfigurationObject[tempDependents.length];
            for (int i = 0; i < dependents.length; ++i) {
                dependents[i] = new ConfigurationObject(tempDependents[i].getType(), tempDependents[i].getId());
            }
            return dependents;
        }
        return null;
    }

    private void persistSequence(SequenceMediator sequence) throws SequenceEditorException {
        MediationPersistenceManager pm = MediationPersistenceManager.getInstance();
        pm.saveItem(sequence.getName(), 1);
    }
}

