/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.startup;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Startup;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.startup.quartz.SimpleQuartzFactory;
import org.apache.synapse.task.TaskDescription;
import org.apache.synapse.task.TaskDescriptionRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartupManager {
    private static final Log log = LogFactory.getLog(StartupManager.class);
    private static final StartupManager OUR_INSTANCE = new StartupManager();
    private SynapseConfiguration synapseConfiguration;
    private SynapseEnvironment synapseEnvironment;
    private TaskDescriptionRepository repository;
    private ConfigurationContext configurationContext;

    public static StartupManager getInstance() {
        return OUR_INSTANCE;
    }

    private StartupManager() {
    }

    public void init(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
        Parameter synapseEnvironmentParameter = configurationContext.getAxisConfiguration().getParameter("synapse.env");
        if (synapseEnvironmentParameter != null) {
            this.init((SynapseEnvironment)synapseEnvironmentParameter.getValue());
        }
    }

    private void reload() {
        Parameter synapseEnvironmentParameter = this.configurationContext.getAxisConfiguration().getParameter("synapse.env");
        if (synapseEnvironmentParameter == null) {
            StartupManager.handleException("Unable to find the Synapse Environment from the loaded Axis2 configuration");
        }
        this.init((SynapseEnvironment)synapseEnvironmentParameter.getValue());
    }

    private void init(SynapseEnvironment synapseEnvironment) {
        this.synapseEnvironment = synapseEnvironment;
        this.synapseConfiguration = synapseEnvironment.getSynapseConfiguration();
        this.repository = this.synapseConfiguration.getTaskDescriptionRepository();
    }

    public void addStartup(OMElement startupElement) {
        this.reload();
        SimpleQuartzFactory factory = new SimpleQuartzFactory();
        Startup startup = factory.createStartup(startupElement);
        if (startup == null) {
            StartupManager.handleException("Startup is null");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding a Startup : " + startup));
        }
        this.synapseConfiguration.addStartup(startup);
        startup.init(this.synapseEnvironment);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added Startup : " + startup + " from the configuration"));
        }
    }

    public void deleteStartup(String name) {
        Startup st;
        this.reload();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting Startup : " + name));
        }
        if ((st = this.synapseConfiguration.getStartup(name)) != null) {
            st.destroy();
        }
        this.synapseConfiguration.removeStartup(name);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleted Startup : " + name + " from the configuration"));
        }
    }

    public TaskDescription getTaskDescription(String name) {
        TaskDescription taskDescription;
        this.reload();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Returning a Startup : " + name + " from the configuration"));
        }
        if ((taskDescription = this.repository.getTaskDescription(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning a TaskDescription : " + taskDescription));
            }
            return taskDescription;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("There is no  Startup with name :" + name));
        }
        return null;
    }

    public Iterator<TaskDescription> getAllTaskDescriptions() {
        this.reload();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Returning a All Startups from the configuration");
        }
        return this.repository.getAllTaskDescriptions();
    }

    public boolean isContains(String name) {
        this.reload();
        return !this.repository.isUnique(name);
    }

    public void shutDown() {
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new IllegalArgumentException(msg);
    }
}

