/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.startup.internal;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.wso2.carbon.startup.StartupManager;
import org.wso2.carbon.utils.ConfigurationContextService;

public class ConfigurationContextServiceCustomizer
implements ServiceTrackerCustomizer {
    private static final Log log = LogFactory.getLog(ConfigurationContextServiceCustomizer.class);
    private BundleContext bundleContext;

    public ConfigurationContextServiceCustomizer(BundleContext context) {
        this.bundleContext = context;
    }

    public Object addingService(ServiceReference serviceReference) {
        Object configObject = this.bundleContext.getService(serviceReference);
        if (!(configObject instanceof ConfigurationContextService)) {
            throw new IllegalArgumentException("");
        }
        ConfigurationContextService configurationContextService = (ConfigurationContextService)configObject;
        ConfigurationContext configurationContext = configurationContextService.getServerConfigContext();
        if (configurationContext == null) {
            ConfigurationContextServiceCustomizer.handleException("ConfigurationContext is null.");
        }
        StartupManager startupManager = StartupManager.getInstance();
        startupManager.init(configurationContext);
        return configurationContextService;
    }

    public void modifiedService(ServiceReference serviceReference, Object o) {
    }

    public void removedService(ServiceReference serviceReference, Object o) {
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new IllegalArgumentException(msg);
    }
}

