/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.startup;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Startup;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.StartupFinder;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.startup.quartz.SimpleQuartzFactory;
import org.apache.synapse.task.TaskDescription;
import org.apache.synapse.task.TaskDescriptionRepository;
import org.wso2.carbon.mediation.initializer.persistence.StartupRegistryStore;
import org.wso2.carbon.registry.core.session.UserRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartupManager {
    private static final Log log = LogFactory.getLog(StartupManager.class);
    private static final StartupManager OUR_INSTANCE = new StartupManager();
    private SynapseConfiguration synapseConfiguration;
    private SynapseEnvironment synapseEnvironment;
    private TaskDescriptionRepository repository;
    private UserRegistry registry;

    public static StartupManager getInstance() {
        return OUR_INSTANCE;
    }

    private StartupManager() {
    }

    public void init(SynapseEnvironment synapseEnvironment, TaskDescriptionRepository repository, UserRegistry registry) {
        this.repository = repository;
        this.synapseEnvironment = synapseEnvironment;
        this.synapseConfiguration = synapseEnvironment.getSynapseConfiguration();
        this.registry = registry;
    }

    public void addStartup(OMElement startupElement) {
        SimpleQuartzFactory factory = new SimpleQuartzFactory();
        Startup startup = factory.createStartup(startupElement);
        if (startup == null) {
            StartupManager.handleException("Startup is null");
        } else {
            this.synapseConfiguration.addStartup(startup);
            startup.init(this.synapseEnvironment);
            this.persistStartup(startup);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added Startup : " + startup + " from the configuration"));
            }
        }
    }

    public void deleteStartup(String name) {
        Startup st = this.synapseConfiguration.getStartup(name);
        if (st != null) {
            st.destroy();
            this.synapseConfiguration.removeStartup(name);
            StartupRegistryStore store = new StartupRegistryStore(this.registry);
            store.deleteElement(name);
        } else {
            log.warn((Object)("Cannot delete the startup named " + name + ", it doesn't exists in the SynapseConfiguration"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleted Startup : " + name + " from the configuration"));
        }
    }

    public TaskDescription getTaskDescription(String name) {
        TaskDescription taskDescription;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Returning a Startup : " + name + " from the configuration"));
        }
        if ((taskDescription = this.repository.getTaskDescription(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning a TaskDescription : " + taskDescription));
            }
            return taskDescription;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("There is no  Startup with name :" + name));
        }
        return null;
    }

    public Iterator<TaskDescription> getAllTaskDescriptions() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Returning a All Startups from the configuration");
        }
        return this.repository.getAllTaskDescriptions();
    }

    public boolean isContains(String name) {
        return !this.repository.isUnique(name);
    }

    public void shutDown() {
    }

    private void persistStartup(Startup startup) {
        StartupRegistryStore store = new StartupRegistryStore(this.registry);
        store.persistElement(startup.getName(), StartupFinder.getInstance().serializeStartup(null, startup));
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new IllegalArgumentException(msg);
    }
}

