/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.startup.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.task.service.TaskManagementService;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.startup.StartupAdminService;
import org.wso2.carbon.startup.StartupJobMetaDataProviderService;
import org.wso2.carbon.startup.StartupManager;
import org.wso2.carbon.startup.util.ConfigHolder;
import org.wso2.carbon.task.services.JobMetaDataProviderService;
import org.wso2.carbon.task.services.TaskDescriptionRepositoryService;

public class StartupAdminServiceComponent {
    private static final Log log = LogFactory.getLog(StartupAdminServiceComponent.class);
    private SynapseEnvironmentService synEnvSvc;
    private TaskDescriptionRepositoryService repositoryService;
    private UserRegistry registry;

    public void activate(ComponentContext context) throws Exception {
        if (this.synEnvSvc != null && this.repositoryService != null) {
            StartupManager startupManager = StartupManager.getInstance();
            ConfigHolder configHolder = ConfigHolder.getInstance();
            configHolder.setRegistry(this.registry);
            configHolder.setRepository(this.repositoryService.getTaskDescriptionRepository());
            configHolder.setSynapseEnvironment(this.synEnvSvc.getSynapseEnvironment());
            context.getBundleContext().registerService(TaskManagementService.class.getName(), (Object)new StartupAdminService(), null);
            context.getBundleContext().registerService(JobMetaDataProviderService.class.getName(), (Object)new StartupJobMetaDataProviderService(), null);
        } else {
            log.error((Object)"Couldn't initialize the StartupManager, SynapseEnvironment service and/or TaskDescriptionRepositoryService not found");
        }
    }

    public void deactivate(ComponentContext context) throws Exception {
        StartupManager startupManager = StartupManager.getInstance();
        startupManager.shutDown();
    }

    protected void setSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        this.synEnvSvc = synapseEnvironmentService;
        ConfigHolder.getInstance().setSynapseEnvironment(synapseEnvironmentService.getSynapseEnvironment());
    }

    protected void unsetSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        this.synEnvSvc = null;
        ConfigHolder.getInstance().setSynapseEnvironment(null);
    }

    protected void setTaskDescriptionRepositoryService(TaskDescriptionRepositoryService repositoryService) {
        this.repositoryService = repositoryService;
        ConfigHolder.getInstance().setRepository(repositoryService.getTaskDescriptionRepository());
    }

    protected void unsetTaskDescriptionRepositoryService(TaskDescriptionRepositoryService repositoryService) {
        this.repositoryService = null;
        ConfigHolder.getInstance().setRepository(null);
    }

    protected void setRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService bound to the ESB initialization process");
        }
        try {
            this.registry = regService.getSystemRegistry();
            ConfigHolder.getInstance().setRegistry(regService.getSystemRegistry());
        }
        catch (RegistryException e) {
            log.error((Object)"Couldn't retrieve the registry from the registry service");
        }
    }

    protected void unsetRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unbound from the ESB environment");
        }
        ConfigHolder.getInstance().setRegistry(null);
    }
}

