/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.startup;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.task.TaskDescription;
import org.apache.synapse.task.TaskDescriptionSerializer;
import org.apache.synapse.task.service.TaskManagementService;
import org.wso2.carbon.startup.StartupManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartupAdminService
implements TaskManagementService {
    private static Log log = LogFactory.getLog(StartupAdminService.class);
    private StartupManager startupManager = StartupManager.getInstance();

    public void addTaskDescription(TaskDescription taskDescription) {
        StartupAdminService.validateTaskDescription(taskDescription);
        OMElement taskElement = TaskDescriptionSerializer.serializeTaskDescription((OMNamespace)SynapseConstants.SYNAPSE_OMNAMESPACE, (TaskDescription)taskDescription);
        StartupAdminService.validateTaskElement(taskElement);
        this.startupManager.addStartup(taskElement);
    }

    public void deleteTaskDescription(String taskName) {
        StartupAdminService.validateName(taskName);
        this.startupManager.deleteStartup(taskName);
    }

    public void editTaskDescription(TaskDescription taskDescription) {
        StartupAdminService.validateTaskDescription(taskDescription);
        OMElement taskElement = TaskDescriptionSerializer.serializeTaskDescription((OMNamespace)SynapseConstants.SYNAPSE_OMNAMESPACE, (TaskDescription)taskDescription);
        StartupAdminService.validateTaskElement(taskElement);
        this.startupManager.updateStartup(taskDescription.getName(), taskElement);
    }

    public List<TaskDescription> getAllTaskDescriptions() {
        ArrayList<TaskDescription> taskDescriptions = new ArrayList<TaskDescription>();
        Iterator<TaskDescription> iterator = this.startupManager.getAllTaskDescriptions();
        while (iterator.hasNext()) {
            TaskDescription taskDescription = iterator.next();
            if (taskDescription == null) continue;
            taskDescriptions.add(taskDescription);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("All available Task based Startup " + taskDescriptions));
        }
        return taskDescriptions;
    }

    public TaskDescription getTaskDescription(String taskName) {
        StartupAdminService.validateName(taskName);
        return this.startupManager.getTaskDescription(taskName);
    }

    public boolean isContains(String taskName) {
        StartupAdminService.validateName(taskName);
        return this.startupManager.isContains(taskName);
    }

    public List<String> getPropertyNames(String taskClass) {
        ArrayList<String> names = new ArrayList<String>();
        try {
            Class<?> clazz = Class.forName(taskClass.trim());
            Method[] methods = clazz.getMethods();
            Field[] fields = clazz.getDeclaredFields();
            block2: for (Method method : methods) {
                String methodName;
                if (method == null || (methodName = method.getName()) == null || !methodName.startsWith("set") || "setTraceState".equals(methodName)) continue;
                for (Field field : fields) {
                    if (!field.getName().equalsIgnoreCase(methodName.substring(3))) continue;
                    names.add(field.getName());
                    continue block2;
                }
            }
        }
        catch (ClassNotFoundException e) {
            StartupAdminService.handleException("Class " + taskClass + " not found in the path", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Task class '" + taskClass + "' contains property Names : " + names));
        }
        return names;
    }

    private static void validateTaskDescription(TaskDescription description) {
        if (description == null) {
            StartupAdminService.handleException("Task Description can not be found.");
        }
    }

    private static void validateTaskElement(OMElement taskElement) {
        if (taskElement == null) {
            StartupAdminService.handleException("Task Description OMElement can not be found.");
        }
    }

    private static void validateName(String name) {
        if (name == null || "".equals(name)) {
            StartupAdminService.handleException("Name is null or empty");
        }
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new IllegalArgumentException(msg);
    }

    private static void handleException(String msg, Throwable throwable) {
        log.error((Object)msg, throwable);
        throw new RuntimeException(msg);
    }
}

