/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.startup.internal;

import java.io.File;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Startup;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.deployers.SynapseArtifactDeploymentStore;
import org.apache.synapse.task.service.TaskManagementService;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.startup.StartupAdminService;
import org.wso2.carbon.startup.StartupJobMetaDataProviderService;
import org.wso2.carbon.startup.StartupManager;
import org.wso2.carbon.startup.StartupTaskDeployer;
import org.wso2.carbon.startup.util.ConfigHolder;
import org.wso2.carbon.task.services.JobMetaDataProviderService;
import org.wso2.carbon.task.services.TaskDescriptionRepositoryService;

public class StartupAdminServiceComponent {
    private static final Log log = LogFactory.getLog(StartupAdminServiceComponent.class);
    private SynapseEnvironmentService synEnvSvc;
    private TaskDescriptionRepositoryService repositoryService;
    private UserRegistry registry;

    protected void activate(ComponentContext context) throws Exception {
        if (this.synEnvSvc != null && this.repositoryService != null) {
            ConfigHolder configHolder = ConfigHolder.getInstance();
            configHolder.setRegistry(this.registry);
            configHolder.setRepository(this.repositoryService.getTaskDescriptionRepository());
            configHolder.setSynapseEnvironment(this.synEnvSvc.getSynapseEnvironment());
            context.getBundleContext().registerService(TaskManagementService.class.getName(), (Object)new StartupAdminService(), null);
            context.getBundleContext().registerService(JobMetaDataProviderService.class.getName(), (Object)new StartupJobMetaDataProviderService(), null);
            this.registerDeployer();
        } else {
            log.error((Object)"Couldn't initialize the StartupManager, SynapseEnvironment service and/or TaskDescriptionRepositoryService not found");
        }
    }

    protected void deactivate(ComponentContext context) throws Exception {
        AxisConfiguration axisConfig = ConfigHolder.getInstance().getSynapseConfiguration().getAxisConfiguration();
        if (axisConfig != null) {
            DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
            String synapseConfigPath = ServiceBusUtils.getSynapseConfigAbsPath();
            String taskDirPath = synapseConfigPath + File.separator + "tasks";
            deploymentEngine.removeDeployer(taskDirPath, "xml");
        }
        StartupManager startupManager = StartupManager.getInstance();
        startupManager.shutDown();
    }

    private void registerDeployer() {
        SynapseConfiguration synCfg = ConfigHolder.getInstance().getSynapseConfiguration();
        AxisConfiguration axisConfig = synCfg.getAxisConfiguration();
        DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
        SynapseArtifactDeploymentStore deploymentStore = SynapseArtifactDeploymentStore.getInstance();
        String synapseConfigPath = ServiceBusUtils.getSynapseConfigAbsPath();
        String taskDirDirPath = synapseConfigPath + File.separator + "tasks";
        for (Startup stp : synCfg.getStartups()) {
            if (stp.getFileName() == null) continue;
            deploymentStore.addRestoredArtifact(taskDirDirPath + File.separator + stp.getFileName());
        }
        deploymentEngine.addDeployer((Deployer)new StartupTaskDeployer(), taskDirDirPath, "xml");
    }

    protected void setSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        this.synEnvSvc = synapseEnvironmentService;
        ConfigHolder.getInstance().setSynapseEnvironment(synapseEnvironmentService.getSynapseEnvironment());
    }

    protected void unsetSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        this.synEnvSvc = null;
        ConfigHolder.getInstance().setSynapseEnvironment(null);
    }

    protected void setTaskDescriptionRepositoryService(TaskDescriptionRepositoryService repositoryService) {
        this.repositoryService = repositoryService;
        ConfigHolder.getInstance().setRepository(repositoryService.getTaskDescriptionRepository());
    }

    protected void unsetTaskDescriptionRepositoryService(TaskDescriptionRepositoryService repositoryService) {
        this.repositoryService = null;
        ConfigHolder.getInstance().setRepository(null);
    }

    protected void setRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService bound to the ESB initialization process");
        }
        try {
            this.registry = regService.getConfigSystemRegistry();
            ConfigHolder.getInstance().setRegistry(regService.getConfigSystemRegistry());
        }
        catch (RegistryException e) {
            log.error((Object)"Couldn't retrieve the registry from the registry service");
        }
    }

    protected void unsetRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unbound from the ESB environment");
        }
        ConfigHolder.getInstance().setRegistry(null);
    }
}

