/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.startup;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Startup;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.startup.AbstractStartup;
import org.apache.synapse.startup.quartz.SimpleQuartzFactory;
import org.apache.synapse.task.TaskDescription;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;

public class StartupUtils {
    private static final Log log = LogFactory.getLog(StartupUtils.class);

    public static void addStartup(OMElement startupElement, SynapseConfiguration synapseConfiguration, SynapseEnvironment synapseEnvironment) {
        StartupUtils.addStartup(startupElement, null, true, synapseConfiguration, synapseEnvironment);
    }

    private static void addStartup(OMElement startupElement, String fileName, boolean generateFileName, SynapseConfiguration synapseConfiguration, SynapseEnvironment synapseEnvironment) {
        SimpleQuartzFactory factory = new SimpleQuartzFactory();
        Startup startup = factory.createStartup(startupElement);
        if (startup == null) {
            StartupUtils.handleException("Startup is null");
        } else {
            if (startup instanceof AbstractStartup) {
                if (generateFileName) {
                    fileName = ServiceBusUtils.generateFileName((String)startup.getName());
                }
                startup.setFileName(fileName);
            }
            synapseConfiguration.addStartup(startup);
            startup.init(synapseEnvironment);
            StartupUtils.persistStartup(startup, synapseConfiguration.getAxisConfiguration());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added Startup : " + startup + " from the configuration"));
            }
        }
    }

    public static void updateStartup(String name, OMElement taskElement, SynapseConfiguration synapseConfiguration, SynapseEnvironment synapseEnvironment) {
        Startup st = synapseConfiguration.getStartup(name);
        if (st == null) {
            log.warn((Object)("Cannot update the startup named: " + name + ", it doesn't exists in the SynapseConfiguration"));
            return;
        }
        String fileName = null;
        if (st instanceof AbstractStartup) {
            fileName = st.getFileName();
        }
        StartupUtils.deleteStartup(st.getName(), synapseConfiguration);
        StartupUtils.addStartup(taskElement, fileName, false, synapseConfiguration, synapseEnvironment);
    }

    public static void deleteStartup(String name, SynapseConfiguration synapseConfiguration) {
        Startup st = synapseConfiguration.getStartup(name);
        if (st != null) {
            st.destroy();
            String fileName = null;
            if (st instanceof AbstractStartup) {
                fileName = st.getFileName();
            }
            synapseConfiguration.removeStartup(name);
            MediationPersistenceManager pm = ServiceBusUtils.getMediationPersistenceManager((AxisConfiguration)synapseConfiguration.getAxisConfiguration());
            pm.deleteItem(name, fileName, 3);
        } else {
            log.warn((Object)("Cannot delete the startup named " + name + ", it doesn't exists in the SynapseConfiguration"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleted Startup : " + name + " from the configuration"));
        }
    }

    public static TaskDescription getTaskDescription(String name, SynapseEnvironment synapseEnvironment) {
        TaskDescription taskDescription;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Returning a Startup : " + name + " from the configuration"));
        }
        if ((taskDescription = synapseEnvironment.getTaskManager().getTaskDescriptionRepository().getTaskDescription(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning a TaskDescription : " + taskDescription));
            }
            return taskDescription;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("There is no  Startup with name :" + name));
        }
        return null;
    }

    public static Iterator<TaskDescription> getAllTaskDescriptions(SynapseEnvironment synapseEnvironment) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Returning a All Startups from the configuration");
        }
        return synapseEnvironment.getTaskManager().getTaskDescriptionRepository().getAllTaskDescriptions();
    }

    public static boolean isContains(String name, SynapseEnvironment synapseEnvironment) {
        return !synapseEnvironment.getTaskManager().getTaskDescriptionRepository().isUnique(name);
    }

    public static void shutDown() {
    }

    private static void persistStartup(Startup startup, AxisConfiguration axisCfg) {
        MediationPersistenceManager pm = ServiceBusUtils.getMediationPersistenceManager((AxisConfiguration)axisCfg);
        pm.saveItem(startup.getName(), 3);
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new IllegalArgumentException(msg);
    }
}

