/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.startup;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.task.TaskDescription;
import org.apache.synapse.task.TaskDescriptionSerializer;
import org.apache.synapse.task.service.TaskManagementService;
import org.wso2.carbon.mediation.initializer.AbstractServiceBusAdmin;
import org.wso2.carbon.startup.StartupUtils;

public class StartupAdminService
extends AbstractServiceBusAdmin
implements TaskManagementService {
    private static Log log = LogFactory.getLog(StartupAdminService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskDescription(TaskDescription taskDescription) {
        Lock lock = this.getLock();
        try {
            lock.lock();
            StartupAdminService.validateTaskDescription(taskDescription);
            OMElement taskElement = TaskDescriptionSerializer.serializeTaskDescription((OMNamespace)SynapseConstants.SYNAPSE_OMNAMESPACE, (TaskDescription)taskDescription);
            StartupAdminService.validateTaskElement(taskElement);
            StartupUtils.addStartup(taskElement, this.getSynapseConfiguration(), this.getSynapseEnvironment());
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTaskDescription(String taskName) {
        Lock lock = this.getLock();
        try {
            lock.lock();
            StartupAdminService.validateName(taskName);
            StartupUtils.deleteStartup(taskName, this.getSynapseConfiguration());
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editTaskDescription(TaskDescription taskDescription) {
        Lock lock = this.getLock();
        try {
            lock.lock();
            StartupAdminService.validateTaskDescription(taskDescription);
            OMElement taskElement = TaskDescriptionSerializer.serializeTaskDescription((OMNamespace)SynapseConstants.SYNAPSE_OMNAMESPACE, (TaskDescription)taskDescription);
            StartupAdminService.validateTaskElement(taskElement);
            StartupUtils.updateStartup(taskDescription.getName(), taskElement, this.getSynapseConfiguration(), this.getSynapseEnvironment());
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaskDescription> getAllTaskDescriptions() {
        Lock lock = this.getLock();
        try {
            lock.lock();
            ArrayList<TaskDescription> taskDescriptions = new ArrayList<TaskDescription>();
            Iterator<TaskDescription> iterator = StartupUtils.getAllTaskDescriptions(this.getSynapseEnvironment());
            while (iterator.hasNext()) {
                TaskDescription taskDescription = iterator.next();
                if (taskDescription == null) continue;
                taskDescriptions.add(taskDescription);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("All available Task based Startup " + taskDescriptions));
            }
            ArrayList<TaskDescription> arrayList = taskDescriptions;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskDescription getTaskDescription(String taskName) {
        Lock lock = this.getLock();
        try {
            lock.lock();
            StartupAdminService.validateName(taskName);
            TaskDescription taskDescription = StartupUtils.getTaskDescription(taskName, this.getSynapseEnvironment());
            return taskDescription;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContains(String taskName) {
        Lock lock = this.getLock();
        try {
            lock.lock();
            StartupAdminService.validateName(taskName);
            boolean bl = StartupUtils.isContains(taskName, this.getSynapseEnvironment());
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPropertyNames(String taskClass) {
        Lock lock = this.getLock();
        ArrayList<String> names = new ArrayList<String>();
        try {
            lock.lock();
            Class<?> clazz = Class.forName(taskClass.trim());
            Method[] methods = clazz.getMethods();
            Field[] fields = clazz.getDeclaredFields();
            block5: for (Method method : methods) {
                String methodName;
                if (method == null || (methodName = method.getName()) == null || !methodName.startsWith("set") || "setTraceState".equals(methodName)) continue;
                for (Field field : fields) {
                    if (!field.getName().equalsIgnoreCase(methodName.substring(3))) continue;
                    names.add(field.getName());
                    continue block5;
                }
            }
        }
        catch (ClassNotFoundException e) {
            StartupAdminService.handleException("Class " + taskClass + " not found in the path", e);
        }
        finally {
            lock.unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Task class '" + taskClass + "' contains property Names : " + names));
        }
        return names;
    }

    private static void validateTaskDescription(TaskDescription description) {
        if (description == null) {
            StartupAdminService.handleException("Task Description can not be found.");
        }
    }

    private static void validateTaskElement(OMElement taskElement) {
        if (taskElement == null) {
            StartupAdminService.handleException("Task Description OMElement can not be found.");
        }
    }

    private static void validateName(String name) {
        if (name == null || "".equals(name)) {
            StartupAdminService.handleException("Name is null or empty");
        }
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new IllegalArgumentException(msg);
    }

    private static void handleException(String msg, Throwable throwable) {
        log.error((Object)msg, throwable);
        throw new RuntimeException(msg);
    }
}

