/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.statistics.internal;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.wso2.carbon.statistics.services.StatisticsAdmin;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.MBeanRegistrar;
import org.wso2.carbon.utils.ServerConfiguration;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer {
    private static final Log log = LogFactory.getLog(Activator.class);
    private ServiceTracker configContextTracker;
    private BundleContext bundleContext;

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        try {
            bundleContext.registerService(StatisticsAdmin.class.getName(), (Object)new StatisticsAdmin(), null);
            this.configContextTracker = new ServiceTracker(bundleContext, ConfigurationContextService.class.getName(), (ServiceTrackerCustomizer)this);
            this.configContextTracker.open();
            ServiceTracker serverConfigTracker = new ServiceTracker(bundleContext, ServerConfiguration.class.getName(), (ServiceTrackerCustomizer)this);
            serverConfigTracker.open();
            if (serverConfigTracker.getService() != null) {
                ServerConfiguration serverConfig = (ServerConfiguration)serverConfigTracker.getService();
                this.registerMBeans(serverConfig);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error initializing the statistics component", (Throwable)e);
            throw new Exception("initializationError", e);
        }
    }

    private void registerMBeans(ServerConfiguration serverConfig) {
        if (serverConfig.getFirstProperty("Ports.JMX") != null) {
            MBeanRegistrar.registerMBean((Object)new StatisticsAdmin());
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference reference) {
        Object serviceObject = null;
        Class<Activator> clazz = Activator.class;
        synchronized (Activator.class) {
            try {
                serviceObject = this.bundleContext.getService(reference);
                if (serviceObject instanceof ConfigurationContextService) {
                    ConfigurationContext configContext = ((ConfigurationContextService)serviceObject).getServerConfigContext();
                    AxisConfiguration axisConf = configContext.getAxisConfiguration();
                    AxisModule statModule = axisConf.getModule("wso2statistics");
                    axisConf.engageModule(statModule);
                } else if (serviceObject instanceof ServerConfiguration) {
                    this.registerMBeans((ServerConfiguration)serviceObject);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error engaging the statistics module from within the statistics component", (Throwable)e);
            }
            return serviceObject;
        }
    }

    public void modifiedService(ServiceReference reference, Object serviceObject) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference reference, Object serviceObject) {
        Class<Activator> clazz = Activator.class;
        synchronized (Activator.class) {
            try {
                if (serviceObject instanceof ConfigurationContextService) {
                    ConfigurationContext configContext = ((ConfigurationContextService)serviceObject).getServerConfigContext();
                    AxisConfiguration axisConf = configContext.getAxisConfiguration();
                    AxisModule statModule = axisConf.getModule("wso2statistics");
                    axisConf.disengageModule(statModule);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error disengaging the statistics module from within the statistics component", (Throwable)e);
            }
            this.bundleContext.ungetService(reference);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }
}

