/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttle.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.throttle.ThrottleComponentConstants;
import org.wso2.carbon.throttle.ThrottleComponentException;

public class Activator
implements BundleActivator {
    private static final Log log = LogFactory.getLog(Activator.class);

    public void start(BundleContext bundleContext) throws Exception {
        ServiceReference reference = bundleContext.getServiceReference(RegistryService.class.getName());
        if (reference == null) {
            log.debug((Object)"WSO2 Registry is not available");
            throw new ThrottleComponentException("registryNotAvailable");
        }
        RegistryService registryService = (RegistryService)bundleContext.getService(reference);
        log.debug((Object)("WSO2 Registry is available : " + registryService.getSystemRegistry()));
        UserRegistry registry = registryService.getSystemRegistry();
        Resource serviceTemplate = registry.newResource();
        serviceTemplate.setContentStream(bundleContext.getBundle().getResource("template-service-policy.xml").openStream());
        registry.put(ThrottleComponentConstants.TEMPLATE_URI + "service", serviceTemplate);
        Resource moduleTemplate = registry.newResource();
        moduleTemplate.setContentStream(bundleContext.getBundle().getResource("template-module-policy.xml").openStream());
        registry.put(ThrottleComponentConstants.TEMPLATE_URI + "global", moduleTemplate);
        Resource operationTemplate = registry.newResource();
        operationTemplate.setContentStream(bundleContext.getBundle().getResource("template-operation-policy.xml").openStream());
        registry.put(ThrottleComponentConstants.TEMPLATE_URI + "operation", operationTemplate);
        Resource mediatorTemplate = registry.newResource();
        mediatorTemplate.setContentStream(bundleContext.getBundle().getResource("template-mediator-policy.xml").openStream());
        registry.put(ThrottleComponentConstants.TEMPLATE_URI + "mediator", mediatorTemplate);
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }
}

