/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.throttle;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConcurrentAccessController
implements Serializable {
    private static Log log = LogFactory.getLog((String)ConcurrentAccessController.class.getName());
    private int limit;
    private AtomicInteger counter;
    private static final long serialVersionUID = -6857325377726757251L;

    public ConcurrentAccessController(int limit) {
        this.limit = limit;
        this.counter = new AtomicInteger(limit);
    }

    public int getAndDecrement() {
        int ret = this.counter.getAndDecrement();
        if (ret <= 0) {
            this.counter.incrementAndGet();
            return 0;
        }
        return ret;
    }

    public int incrementAndGet() {
        int ret = this.counter.incrementAndGet();
        if (ret < 0) {
            return 0;
        }
        return ret;
    }

    public int getLimit() {
        return this.limit;
    }

    public void set(int newValue) {
        this.counter.set(newValue);
        this.limit = newValue;
    }
}

