/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttle.service;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.Version;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Constants;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.xml.XmlPrimtiveAssertion;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.persistence.PersistenceUtils;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.throttle.InternalData;
import org.wso2.carbon.throttle.ThrottleComponentException;
import org.wso2.carbon.throttle.ThrottlePolicy;
import org.wso2.throttle.ThrottleConstants;

public class ThrottleConfigAdminService
extends AbstractAdmin {
    private Registry registry = null;
    protected AxisConfiguration axisConfig = null;
    private Policy policyToUpdate = null;
    private static final String ADMIN_SERICE_PARAM_NAME = "adminService";
    private static final String GLOBALLY_ENGAGED_PARAM_NAME = "globallyEngaged";
    private static final String GLOBALLY_ENGAGED_CUSTOM = "globallyEngagedCustom";
    private static final Log log = LogFactory.getLog(ThrottleConfigAdminService.class);

    public ThrottleConfigAdminService() {
        try {
            this.axisConfig = this.getAxisConfig();
            this.registry = this.getConfigSystemRegistry();
        }
        catch (Exception e) {
            log.error((Object)"Can't initialize ThrottleAdminService.", (Throwable)e);
        }
    }

    public void enableThrottling(String serviceName, ThrottlePolicy policy) throws AxisFault, ThrottleComponentException {
        Policy builtPolicy;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Engaging throttling for the serviceName : " + serviceName));
        }
        AxisService axisService = this.getAxisService(serviceName);
        AxisModule module = axisService.getAxisConfiguration().getModule("wso2throttle");
        String servicePath = "/repository/axis2/service-groups/" + axisService.getAxisServiceGroup().getServiceGroupName() + "/services/" + serviceName;
        try {
            Association[] associations = this.registry.getAssociations(servicePath, "engaged.modules");
            boolean associationExist = false;
            for (Association association : associations) {
                if (!association.getDestinationPath().equals(this.getModuleResourcePath(module))) continue;
                associationExist = true;
                break;
            }
            if (!associationExist) {
                this.registry.addAssociation(servicePath, this.getModuleResourcePath(module), "engaged.modules");
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error occured in engaging throttlin at registry", (Throwable)e);
            throw new ThrottleComponentException("errorEngagingModuleAtRegistry");
        }
        XmlPrimtiveAssertion assertion = this.getThrottlePolicy(axisService.getPolicySubject().getAttachedPolicyComponents());
        OMElement policyElement = this.buildPolicy(policy, assertion, "service");
        Policy policyToPersist = builtPolicy = PolicyEngine.getPolicy((OMElement)policyElement);
        if (assertion == null) {
            axisService.getPolicySubject().attachPolicy(builtPolicy);
        } else {
            axisService.getPolicySubject().updatePolicy(this.policyToUpdate);
            policyToPersist = this.policyToUpdate;
        }
        try {
            Resource policyResource = this.registry.newResource();
            policyResource.setProperty("policy.type", "3");
            policyResource.setProperty("policy.uuid", policyToPersist.getId());
            this.persistPoliciesToRegistry(policyToPersist, servicePath, servicePath, policyResource);
        }
        catch (Exception e) {
            log.error((Object)"Error occured while saving the builtPolicy in registry", (Throwable)e);
            throw new ThrottleComponentException("errorSavingPolicy");
        }
        axisService.engageModule(module);
    }

    public void globallyEngageThrottling(ThrottlePolicy policy) throws AxisFault, ThrottleComponentException {
        Policy builtPolicy;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Globally engaging throttling");
        }
        AxisModule module = this.axisConfig.getModule("wso2throttle");
        String resourcePath = this.getModuleResourcePath(module);
        try {
            String globalPath = PersistenceUtils.getResourcePath((AxisModule)module);
            if (this.registry.resourceExists(globalPath)) {
                Resource resource = this.registry.get(globalPath);
                if (!Boolean.parseBoolean(resource.getProperty(GLOBALLY_ENGAGED_CUSTOM))) {
                    resource.removeProperty(GLOBALLY_ENGAGED_CUSTOM);
                    resource.addProperty(GLOBALLY_ENGAGED_CUSTOM, Boolean.TRUE.toString());
                    this.registry.put(globalPath, resource);
                }
            } else {
                Resource globalResource = this.registry.newResource();
                globalResource.addProperty(GLOBALLY_ENGAGED_CUSTOM, Boolean.TRUE.toString());
                this.registry.put(globalPath, globalResource);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error occured in globally engaging throttlin at registry", (Throwable)e);
            throw new ThrottleComponentException("errorEngagingModuleAtRegistry");
        }
        XmlPrimtiveAssertion assertion = this.getThrottlePolicy(module.getPolicySubject().getAttachedPolicyComponents());
        OMElement policyElement = this.buildPolicy(policy, assertion, "global");
        Policy policyToPersist = builtPolicy = PolicyEngine.getPolicy((OMElement)policyElement);
        if (assertion == null) {
            module.getPolicySubject().attachPolicy(builtPolicy);
        } else {
            module.getPolicySubject().updatePolicy(this.policyToUpdate);
            policyToPersist = this.policyToUpdate;
        }
        try {
            Resource policyResource = this.registry.newResource();
            policyResource.setProperty("policy.type", "2");
            policyResource.setProperty("policy.uuid", policyToPersist.getId());
            policyResource.setProperty("module.version", module.getVersion().toString());
            this.persistPoliciesToRegistry(policyToPersist, resourcePath, null, policyResource);
        }
        catch (Exception e) {
            log.error((Object)"Error occured while saving the builtPolicy in registry", (Throwable)e);
            throw new ThrottleComponentException("errorSavingPolicy");
        }
        module.addParameter(new Parameter(GLOBALLY_ENGAGED_PARAM_NAME, (Object)Boolean.TRUE.toString()));
        try {
            this.registry.beginTransaction();
            for (AxisService service : this.axisConfig.getServices().values()) {
                String adminParamValue = (String)service.getParent().getParameterValue(ADMIN_SERICE_PARAM_NAME);
                if (adminParamValue != null && adminParamValue.length() != 0 && Boolean.parseBoolean(adminParamValue.trim())) continue;
                this.enableThrottling(service.getName(), policy);
            }
            this.registry.commitTransaction();
        }
        catch (Exception e) {
            log.error((Object)"Error occured in globally engaging throttlin at registry", (Throwable)e);
            try {
                this.registry.rollbackTransaction();
            }
            catch (RegistryException ex) {
                log.error((Object)"Unable to rollback transaction", (Throwable)ex);
            }
            throw new ThrottleComponentException("errorEngagingModuleAtRegistry");
        }
    }

    public boolean engageThrottlingForOperation(ThrottlePolicy policy, String serviceName, String operationName) throws AxisFault, ThrottleComponentException {
        Policy builtPolicy;
        AxisModule module;
        AxisService axisService;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Engaging throttling for the operation : " + operationName + ", in service :" + serviceName));
        }
        if ((axisService = this.getAxisService(serviceName)).isEngaged(module = axisService.getAxisConfiguration().getModule("wso2throttle"))) {
            return true;
        }
        AxisOperation operation = axisService.getOperation(new QName(operationName));
        if (operation == null) {
            log.error((Object)("No operation found from the name " + operationName + ", in service : " + serviceName));
            throw new ThrottleComponentException("noSuchOperation", new String[]{serviceName});
        }
        String servicePath = "/repository/axis2/service-groups/" + axisService.getAxisServiceGroup().getServiceGroupName() + "/services/" + serviceName;
        String operationPath = servicePath + "/operations/" + operationName;
        try {
            Association[] associations = this.registry.getAssociations(operationPath, "engaged.modules");
            boolean associationExist = false;
            for (Association association : associations) {
                if (!association.getDestinationPath().equals(this.getModuleResourcePath(module))) continue;
                associationExist = true;
                break;
            }
            if (!associationExist) {
                this.registry.addAssociation(operationPath, this.getModuleResourcePath(module), "engaged.modules");
            }
        }
        catch (RegistryException e) {
            log.error((Object)("Error occured in engaging throttling for operation : " + operationName + " at registry"), (Throwable)e);
            throw new ThrottleComponentException("errorEngagingModuleAtRegistry");
        }
        XmlPrimtiveAssertion assertion = this.getThrottlePolicy(operation.getPolicySubject().getAttachedPolicyComponents());
        OMElement policyElement = this.buildPolicy(policy, assertion, "operation");
        Policy policyToPersist = builtPolicy = PolicyEngine.getPolicy((OMElement)policyElement);
        if (assertion == null) {
            operation.getPolicySubject().attachPolicy(builtPolicy);
        } else {
            operation.getPolicySubject().updatePolicy(this.policyToUpdate);
            policyToPersist = this.policyToUpdate;
        }
        try {
            Resource policyResource = this.registry.newResource();
            policyResource.setProperty("policy.type", "4");
            policyResource.setProperty("policy.uuid", policyToPersist.getId());
            this.persistPoliciesToRegistry(policyToPersist, servicePath, operationPath, policyResource);
        }
        catch (Exception e) {
            log.error((Object)"Error occured while saving the builtPolicy in registry", (Throwable)e);
            throw new ThrottleComponentException("errorSavingPolicy");
        }
        operation.engageModule(module);
        return false;
    }

    public boolean disengageThrottlingForOperation(String serviceName, String operationName) throws ThrottleComponentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Disengaging throttling from the operation : " + operationName + ", in service : " + serviceName));
        }
        try {
            AxisService axisService = this.getAxisService(serviceName);
            AxisModule module = axisService.getAxisConfiguration().getModule("wso2throttle");
            if (axisService.isEngaged(module)) {
                return true;
            }
            AxisOperation operation = axisService.getOperation(new QName(operationName));
            if (operation == null) {
                log.error((Object)("No operation found from the name " + operationName + ", in service : " + serviceName));
                throw new ThrottleComponentException("noSuchOperation", new String[]{serviceName});
            }
            String operationPath = "/repository/axis2/service-groups/" + axisService.getAxisServiceGroup().getServiceGroupName() + "/services/" + serviceName + "/operations/" + operationName;
            try {
                this.registry.removeAssociation(operationPath, this.getModuleResourcePath(module), "engaged.modules");
                operation.disengageModule(module);
            }
            catch (RegistryException e) {
                log.error((Object)"Error occured while removing assertion from registry", (Throwable)e);
                throw new ThrottleComponentException("errorDisablingAtRegistry");
            }
        }
        catch (AxisFault e) {
            log.error((Object)"Error occured while disengaging module from AxisService", (Throwable)e);
            throw new ThrottleComponentException("errorDisablingThrottling", e);
        }
        return false;
    }

    public void disableThrottling(String serviceName) throws ThrottleComponentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Disengaging throttling from the service : " + serviceName));
        }
        try {
            AxisService axisService = this.getAxisService(serviceName);
            String servicePath = "/repository/axis2/service-groups/" + axisService.getAxisServiceGroup().getServiceGroupName() + "/services/" + serviceName;
            try {
                AxisModule module = axisService.getAxisConfiguration().getModule("wso2throttle");
                this.registry.removeAssociation(servicePath, this.getModuleResourcePath(module), "engaged.modules");
                axisService.disengageModule(module);
            }
            catch (RegistryException e) {
                log.error((Object)"Error occured while removing assertion from registry", (Throwable)e);
                throw new ThrottleComponentException("errorDisablingAtRegistry");
            }
        }
        catch (AxisFault e) {
            log.error((Object)"Error occured while disengaging module from AxisService", (Throwable)e);
            throw new ThrottleComponentException("errorDisablingThrottling", e);
        }
    }

    public void disengageGlobalThrottling() throws ThrottleComponentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Disengaging globally engaged throttling");
        }
        try {
            Parameter param;
            Resource resource;
            AxisModule module = this.axisConfig.getModule("wso2throttle");
            String resourcePath = this.getModuleResourcePath(module);
            String globalPath = PersistenceUtils.getResourcePath((AxisModule)module);
            if (this.registry.resourceExists(globalPath) && Boolean.parseBoolean((resource = this.registry.get(globalPath)).getProperty(GLOBALLY_ENGAGED_CUSTOM))) {
                resource.removeProperty(GLOBALLY_ENGAGED_CUSTOM);
                resource.addProperty(GLOBALLY_ENGAGED_CUSTOM, "false");
                this.registry.put(globalPath, resource);
            }
            if ((param = module.getParameter(GLOBALLY_ENGAGED_PARAM_NAME)) != null) {
                module.removeParameter(module.getParameter(GLOBALLY_ENGAGED_PARAM_NAME));
            }
            for (AxisService service : this.axisConfig.getServices().values()) {
                String adminParamValue = (String)service.getParent().getParameterValue(ADMIN_SERICE_PARAM_NAME);
                if (adminParamValue != null && adminParamValue.length() != 0 && Boolean.parseBoolean(adminParamValue.trim())) continue;
                this.disableThrottling(service.getName());
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error occured while removing global throttle from registry", (Throwable)e);
            throw new ThrottleComponentException("errorDisablingAtRegistry");
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error occured while disengaging module from AxisService", (Throwable)axisFault);
            throw new ThrottleComponentException("errorDisablingThrottling", axisFault);
        }
    }

    public ThrottlePolicy getPolicyConfigs(String serviceName) throws AxisFault, ThrottleComponentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extracting current policy configurations for the service : " + serviceName));
        }
        AxisService service = this.getAxisService(serviceName);
        ThrottlePolicy currentConfig = new ThrottlePolicy();
        AxisModule module = service.getAxisConfiguration().getModule("wso2throttle");
        currentConfig.setEngaged(service.isEngaged(module));
        XmlPrimtiveAssertion assertion = this.getThrottlePolicy(service.getPolicySubject().getAttachedPolicyComponents());
        return this.preparePolicyConfigs(assertion, currentConfig);
    }

    public ThrottlePolicy getGlobalPolicyConfigs() throws AxisFault, ThrottleComponentException {
        String globallyEngaged;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Extracting current global policy configurations");
        }
        ThrottlePolicy currentConfig = new ThrottlePolicy();
        AxisModule module = this.axisConfig.getModule("wso2throttle");
        Parameter param = module.getParameter(GLOBALLY_ENGAGED_PARAM_NAME);
        if (param != null && (globallyEngaged = (String)param.getValue()) != null && globallyEngaged.length() != 0) {
            currentConfig.setEngaged(Boolean.parseBoolean(globallyEngaged.trim()));
        }
        XmlPrimtiveAssertion assertion = this.getThrottlePolicy(module.getPolicySubject().getAttachedPolicyComponents());
        return this.preparePolicyConfigs(assertion, currentConfig);
    }

    public ThrottlePolicy getOperationPolicyConfigs(String serviceName, String operationName) throws AxisFault, ThrottleComponentException {
        AxisService service;
        AxisOperation operation;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extracting current policy configurations for the operation : " + operationName + " in service : " + serviceName));
        }
        if ((operation = (service = this.getAxisService(serviceName)).getOperation(new QName(operationName))) == null) {
            log.error((Object)("No operation found from the name " + operationName + ", in service : " + serviceName));
            throw new ThrottleComponentException("noSuchOperation", new String[]{serviceName});
        }
        ThrottlePolicy currentConfig = new ThrottlePolicy();
        AxisModule module = service.getAxisConfiguration().getModule("wso2throttle");
        currentConfig.setEngaged(operation.isEngaged(module) || service.isEngaged(module));
        XmlPrimtiveAssertion assertion = null;
        if (service.isEngaged(module)) {
            assertion = this.getThrottlePolicy(service.getPolicySubject().getAttachedPolicyComponents());
        }
        if (assertion == null) {
            assertion = this.getThrottlePolicy(operation.getPolicySubject().getAttachedPolicyComponents());
        }
        return this.preparePolicyConfigs(assertion, currentConfig);
    }

    public ThrottlePolicy toThrottlePolicy(String policyXML) throws ThrottleComponentException {
        try {
            OMElement policyOM = this.createOMElement(policyXML);
            Policy policy = PolicyEngine.getPolicy((OMElement)policyOM);
            ArrayList<Policy> list = new ArrayList<Policy>();
            list.add(policy);
            XmlPrimtiveAssertion assertion = this.getThrottlePolicy(list);
            return this.preparePolicyConfigs(assertion, new ThrottlePolicy());
        }
        catch (Exception e) {
            throw new ThrottleComponentException("Invalid policy XML ", e);
        }
    }

    public String throttlePolicyToString(ThrottlePolicy policy) throws ThrottleComponentException {
        OMElement policyElement = this.buildPolicy(policy, null, "mediator");
        if (policyElement != null) {
            return policyElement.toString();
        }
        return "";
    }

    private OMElement createOMElement(String xml) {
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(xml));
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            return builder.getDocumentElement();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private ThrottlePolicy preparePolicyConfigs(XmlPrimtiveAssertion assertion, ThrottlePolicy currentConfig) {
        ArrayList<InternalData> internalConfigs = new ArrayList<InternalData>();
        if (assertion == null) {
            return new ThrottlePolicy();
        }
        Policy throttlePolicy = PolicyEngine.getPolicy((OMElement)assertion.getValue());
        if (throttlePolicy != null) {
            for (Object inThrottle : throttlePolicy.getPolicyComponents()) {
                if (inThrottle instanceof Policy) {
                    InternalData data = new InternalData();
                    for (Object inSecondLevelPolicy : ((Policy)inThrottle).getAssertions()) {
                        if (inSecondLevelPolicy instanceof XmlPrimtiveAssertion) {
                            OMElement range = ((XmlPrimtiveAssertion)inSecondLevelPolicy).getValue();
                            data.setRange(range.getText());
                            if (!range.getAttributeValue(ThrottleConstants.THROTTLE_TYPE_ATTRIBUTE_QNAME).equals("DOMAIN")) continue;
                            data.setRangeType("DOMAIN");
                            continue;
                        }
                        if (!(inSecondLevelPolicy instanceof Policy)) continue;
                        for (Object inThirdLevelPolicy : ((Policy)inSecondLevelPolicy).getPolicyComponents()) {
                            if (!(inThirdLevelPolicy instanceof XmlPrimtiveAssertion)) continue;
                            OMElement accessLevel = ((XmlPrimtiveAssertion)inThirdLevelPolicy).getValue();
                            if (accessLevel.getLocalName().equals("Allow")) {
                                data.setAccessLevel(2);
                                continue;
                            }
                            if (accessLevel.getLocalName().equals("Deny")) {
                                data.setAccessLevel(1);
                                continue;
                            }
                            data.setAccessLevel(0);
                            OMElement policy = accessLevel.getFirstChildWithName(Constants.Q_ELEM_POLICY);
                            Policy fourthLevelPolicy = PolicyEngine.getPolicy((OMElement)policy);
                            for (Object inFourthLevelPolicy : fourthLevelPolicy.getPolicyComponents()) {
                                OMElement temp = ((XmlPrimtiveAssertion)inFourthLevelPolicy).getValue();
                                String localname = temp.getLocalName();
                                if (localname.equals("MaximumCount")) {
                                    data.setMaxRequestCount(this.validateAndToInt(temp.getText()));
                                    continue;
                                }
                                if (localname.equals("UnitTime")) {
                                    data.setUnitTime(this.validateAndToInt(temp.getText()));
                                    continue;
                                }
                                if (!localname.equals("ProhibitTimePeriod")) continue;
                                data.setProhibitTimePeriod(this.validateAndToInt(temp.getText()));
                            }
                        }
                    }
                    internalConfigs.add(data);
                    continue;
                }
                if (!(inThrottle instanceof XmlPrimtiveAssertion)) continue;
                OMElement maxConc = ((XmlPrimtiveAssertion)inThrottle).getValue();
                currentConfig.setMaxConcurrentAccesses(this.validateAndToInt(maxConc.getText()));
            }
            InternalData[] data = new InternalData[internalConfigs.size()];
            for (int p = 0; p < internalConfigs.size(); ++p) {
                data[p] = (InternalData)internalConfigs.get(p);
            }
            currentConfig.setInternalConfigs(data);
        }
        return currentConfig;
    }

    private XmlPrimtiveAssertion getThrottlePolicy(Collection components) throws AxisFault {
        for (Object comp : components) {
            if (!(comp instanceof Policy)) continue;
            Policy policy = (Policy)comp;
            Iterator iterator = policy.getAlternatives();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof List)) continue;
                List list = (List)object;
                for (Object assertObj : list) {
                    XmlPrimtiveAssertion primitiveAssertion;
                    QName assertionName;
                    if (!(assertObj instanceof XmlPrimtiveAssertion) || !(assertionName = (primitiveAssertion = (XmlPrimtiveAssertion)assertObj).getName()).equals(ThrottleConstants.SERVICE_THROTTLE_ASSERTION_QNAME) && !assertionName.equals(ThrottleConstants.MODULE_THROTTLE_ASSERTION_QNAME) && !assertionName.equals(ThrottleConstants.OPERATION_THROTTLE_ASSERTION_QNAME) && !assertionName.equals(ThrottleConstants.MEDIATOR_THROTTLE_ASSERTION_QNAME)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Existing ThrottleAssertion found");
                    }
                    this.policyToUpdate = policy;
                    return primitiveAssertion;
                }
            }
        }
        return null;
    }

    private OMElement buildPolicy(ThrottlePolicy policyConfigs, XmlPrimtiveAssertion assertion, String level) throws ThrottleComponentException {
        InternalData[] internalData;
        OMElement throttleAssertion;
        OMElement policyElement;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Building the policy using received configurations");
        }
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace throttleNamespace = factory.createOMNamespace("http://www.wso2.org/products/wso2commons/throttle", "throttle");
        OMElement template = this.getTemplatePolicy(level);
        template.build();
        OMElement ta = this.getThrottleAssertion(level, template);
        OMElement secondLevelPolicy = ta.getFirstChildWithName(Constants.Q_ELEM_POLICY);
        if (assertion != null) {
            policyElement = this.getPolicyElement();
            OMElement existingElement = assertion.getValue();
            OMElement existingSecondLevelPolicy = existingElement.getFirstChildWithName(Constants.Q_ELEM_POLICY);
            while (existingSecondLevelPolicy != null) {
                existingSecondLevelPolicy.detach();
                existingSecondLevelPolicy = existingElement.getFirstChildWithName(Constants.Q_ELEM_POLICY);
            }
            policyElement.addChild((OMNode)existingElement);
            throttleAssertion = this.getThrottleAssertion(level, policyElement);
        } else {
            policyElement = template;
            throttleAssertion = ta;
        }
        QName maxName = new QName("http://www.wso2.org/products/wso2commons/throttle", "MaximumConcurrentAccess");
        OMElement tempToTreat = throttleAssertion.getFirstChildWithName(maxName);
        if (tempToTreat == null) {
            tempToTreat = OMAbstractFactory.getOMFactory().createOMElement(maxName);
            throttleAssertion.addChild((OMNode)tempToTreat);
        }
        this.treatSubElement(tempToTreat, policyConfigs.getMaxConcurrentAccesses());
        QName controlQName = new QName("http://www.wso2.org/products/wso2commons/throttle", "Control");
        for (InternalData confData : internalData = policyConfigs.getInternalConfigs()) {
            OMElement clonedElement = secondLevelPolicy.cloneOMElement();
            OMElement temp = clonedElement.getFirstChildWithName(new QName("http://www.wso2.org/products/wso2commons/throttle", "ID"));
            temp.setText(confData.getRange());
            if (confData.getRangeType().equals("DOMAIN")) {
                temp.getAttribute(ThrottleConstants.THROTTLE_TYPE_ATTRIBUTE_QNAME).setAttributeValue("DOMAIN");
            }
            temp = clonedElement.getFirstChildWithName(Constants.Q_ELEM_POLICY);
            if (confData.getAccessLevel() == 0) {
                temp = temp.getFirstChildWithName(new QName("http://www.wso2.org/products/wso2commons/throttle", "Control"));
                temp = temp.getFirstChildWithName(Constants.Q_ELEM_POLICY);
                OMElement e = temp.getFirstChildWithName(new QName("http://www.wso2.org/products/wso2commons/throttle", "MaximumCount"));
                this.treatSubElement(e, confData.getMaxRequestCount());
                tempToTreat = temp.getFirstChildWithName(new QName("http://www.wso2.org/products/wso2commons/throttle", "UnitTime"));
                this.treatSubElement(tempToTreat, confData.getUnitTime());
                tempToTreat = temp.getFirstChildWithName(new QName("http://www.wso2.org/products/wso2commons/throttle", "ProhibitTimePeriod"));
                this.treatSubElement(tempToTreat, confData.getProhibitTimePeriod());
            } else if (confData.getAccessLevel() == 2) {
                temp.getFirstChildWithName(controlQName).detach();
                temp.addChild((OMNode)factory.createOMElement("Allow", throttleNamespace));
            } else if (confData.getAccessLevel() == 1) {
                temp.getFirstChildWithName(controlQName).detach();
                temp.addChild((OMNode)factory.createOMElement("Deny", throttleNamespace));
            }
            throttleAssertion.addChild((OMNode)clonedElement);
        }
        secondLevelPolicy.detach();
        return policyElement;
    }

    private void treatSubElement(OMElement subElement, int configValue) {
        if (configValue != 0) {
            subElement.setText(String.valueOf(configValue));
        } else {
            subElement.detach();
        }
    }

    private void persistPoliciesToRegistry(Policy policy, String policyPath, String idPath, Resource policyResource) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Persisting new policy into Registry");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(baos);
        policy.serialize(writer);
        writer.flush();
        policyResource.setContent((Object)baos.toString());
        String policyResourcePath = policyPath + "/policies/" + policy.getId();
        this.registry.put(policyResourcePath, policyResource);
        if (idPath != null && idPath.length() != 0) {
            Resource resource = this.registry.resourceExists(idPath) ? this.registry.get(idPath) : this.registry.newResource();
            resource.addProperty("policy.uuid", policy.getId());
            this.registry.put(idPath, resource);
        }
    }

    private OMElement getPolicyElement() {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement policyElement = factory.createOMElement(Constants.Q_ELEM_POLICY);
        OMNamespace wsuNs = factory.createOMNamespace("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        policyElement.addAttribute(factory.createOMAttribute("Id", wsuNs, "DummyPolicy"));
        return policyElement;
    }

    private String getModuleResourcePath(AxisModule axisModule) {
        String moduleName = axisModule.getName();
        Version version = axisModule.getVersion();
        String moduleVersion = version.toString();
        if (moduleVersion == null || moduleVersion.length() == 0) {
            moduleVersion = "SNAPSHOT";
        }
        return "/repository/axis2/modules/" + moduleName + "/" + moduleVersion;
    }

    private OMElement getTemplatePolicy(String level) throws ThrottleComponentException {
        XMLStreamReader parser;
        String resourceUri = "/repository/components/org.wso2.carbon.throttle/templates/" + level;
        try {
            if (!this.registry.resourceExists(resourceUri)) {
                throw new ThrottleComponentException("templateNotFound");
            }
            Resource resource = this.registry.get(resourceUri);
            InputStream in = resource.getContentStream();
            parser = XMLInputFactory.newInstance().createXMLStreamReader(in);
        }
        catch (Exception e) {
            log.error((Object)"Error occoured while loading template from registry", (Throwable)e);
            throw new ThrottleComponentException("errorLoadingTemplate");
        }
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        return builder.getDocumentElement();
    }

    private OMElement getThrottleAssertion(String level, OMElement parent) {
        OMElement throttleAssertion = level.equals("service") ? parent.getFirstChildWithName(ThrottleConstants.SERVICE_THROTTLE_ASSERTION_QNAME) : (level.equals("operation") ? parent.getFirstChildWithName(ThrottleConstants.OPERATION_THROTTLE_ASSERTION_QNAME) : (level.equals("mediator") ? parent.getFirstChildWithName(ThrottleConstants.MEDIATOR_THROTTLE_ASSERTION_QNAME) : parent.getFirstChildWithName(ThrottleConstants.MODULE_THROTTLE_ASSERTION_QNAME)));
        return throttleAssertion;
    }

    private AxisService getAxisService(String serviceName) throws ThrottleComponentException {
        AxisService axisService = this.axisConfig.getServiceForActivation(serviceName);
        if (axisService == null) {
            log.error((Object)("No service found from the name " + serviceName));
            throw new ThrottleComponentException("noSuchService", new String[]{serviceName});
        }
        return axisService;
    }

    private int validateAndToInt(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
        int intValue = -1;
        try {
            intValue = Integer.parseInt(value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (intValue == -1) {
            throw new IllegalArgumentException("Invalid parameter value : " + value + ".Expected integer value.");
        }
        return intValue;
    }
}

