/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.wsdl2code;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.CommandLineOption;
import org.apache.axis2.util.CommandLineOptionParser;
import org.apache.axis2.util.OptionsValidator;
import org.apache.axis2.wsdl.codegen.CodeGenerationEngine;
import org.apache.axis2.wsdl.util.WSDL2JavaOptionsValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.transports.http.HttpTransportListener;
import org.wso2.carbon.utils.ArchiveManipulator;
import org.wso2.carbon.utils.FileManipulator;
import org.wso2.carbon.utils.NetworkUtils;
import org.wso2.carbon.wsdl2code.CodegenDownloadData;

public class WSDL2Code
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(WSDL2Code.class);
    private static final String CODEGEN_POM_XSL = "org/wso2/carbon/wsdl2code/codegen-pom.xsl";

    public CodegenDownloadData codegen(String[] options) throws AxisFault {
        String msg;
        Map allOptions;
        String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
        ConfigurationContext configContext = this.getConfigContext();
        String codegenOutputDir = configContext.getProperty("WORK_DIR") + File.separator + "tools_codegen" + File.separator + uuid + File.separator;
        System.getProperties().remove("project.base.dir");
        System.getProperties().remove("name");
        System.setProperty("project.base.dir", codegenOutputDir);
        ArrayList<String> optionsList = new ArrayList<String>();
        for (int j = 0; j < options.length; ++j) {
            String option = options[j];
            optionsList.add(option);
        }
        optionsList.add("-o");
        optionsList.add(codegenOutputDir);
        String[] args = optionsList.toArray(new String[optionsList.size()]);
        try {
            File file;
            CommandLineOptionParser commandLineOptionParser = new CommandLineOptionParser(args);
            allOptions = commandLineOptionParser.getAllOptions();
            List list = commandLineOptionParser.getInvalidOptions((OptionsValidator)new WSDL2JavaOptionsValidator());
            if (list.size() > 0) {
                String faultOptions = "";
                for (CommandLineOption commandLineOption : list) {
                    String optionValue = commandLineOption.getOptionValue();
                    faultOptions = faultOptions + "Invalid input for [ " + commandLineOption.getOptionType() + (optionValue != null ? " : " + optionValue + " ]" : " ]") + "\n";
                }
                log.error((Object)faultOptions);
                throw new AxisFault(faultOptions);
            }
            CommandLineOption commandLineOption = (CommandLineOption)allOptions.get("uri");
            if (commandLineOption == null) {
                throw new AxisFault("WSDL URI or Path Cannot be empty");
            }
            String uriValue = commandLineOption.getOptionValue().trim();
            if ("".equals(uriValue)) {
                throw new AxisFault("WSDL URI or Path Cannot be empty");
            }
            if (!(uriValue.startsWith("https://") || uriValue.startsWith("http://") || (file = new File(uriValue)).exists() && file.isFile())) {
                throw new AxisFault("The wsdl uri should be a URL or a valid path on the file system");
            }
            new CodeGenerationEngine(commandLineOptionParser).generate();
        }
        catch (Exception e) {
            String msg2;
            String rootMsg = "Code generation failed";
            Throwable throwable = e.getCause();
            if (throwable != null && (msg2 = throwable.getMessage()) != null) {
                log.error((Object)(rootMsg + " " + msg2), throwable);
                throw new AxisFault(throwable.toString());
            }
            log.error((Object)rootMsg, (Throwable)e);
            throw AxisFault.makeFault((Throwable)e);
        }
        CommandLineOption option = (CommandLineOption)allOptions.get("sn");
        try {
            uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
            File destDir = new File(configContext.getProperty("WORK_DIR") + File.separator + "tools_codegen" + File.separator + uuid);
            if (!destDir.exists()) {
                destDir.mkdirs();
            }
            String destFileName = uuid.substring(2) + ".zip";
            String destArchive = destDir.getAbsolutePath() + File.separator + destFileName;
            InputStream pomXslInputStream = ((Object)((Object)this)).getClass().getResourceAsStream(CODEGEN_POM_XSL);
            if (pomXslInputStream == null) {
                pomXslInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(CODEGEN_POM_XSL);
            }
            String name = uuid;
            boolean isBuildXml = false;
            String version = "1.0";
            File buildXml = new File(codegenOutputDir, "build.xml");
            if (buildXml.exists() && buildXml.isFile()) {
                OMAttribute omAttribute;
                String nameVal;
                isBuildXml = true;
                FileInputStream buildInputStream = new FileInputStream(buildXml);
                AXIOMXPath xp = new AXIOMXPath("/project/property[@name='name']");
                XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(buildInputStream);
                StAXOMBuilder builder = new StAXOMBuilder(streamReader);
                OMElement documentElement = builder.getDocumentElement();
                OMElement nameEle = (OMElement)xp.selectSingleNode((Object)documentElement);
                if (nameEle != null && (nameVal = (omAttribute = nameEle.getAttribute(new QName("value"))).getAttributeValue()) != null) {
                    name = nameVal;
                }
            }
            OMFactory fac = OMAbstractFactory.getOMFactory();
            OMElement infoEle = fac.createOMElement(new QName("info"));
            OMElement nameEle = fac.createOMElement(new QName("name"));
            nameEle.setText(this.formatServiceName(name));
            infoEle.addChild((OMNode)nameEle);
            OMElement isBuildXmlEle = fac.createOMElement(new QName("isBuildXml"));
            isBuildXmlEle.setText(Boolean.valueOf(isBuildXml).toString());
            infoEle.addChild((OMNode)isBuildXmlEle);
            OMElement versionEle = fac.createOMElement(new QName("version"));
            versionEle.setText(version);
            infoEle.addChild((OMNode)versionEle);
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            infoEle.serialize((OutputStream)bao);
            ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(bao.toByteArray());
            if (pomXslInputStream != null) {
                File pomFileOut = new File(codegenOutputDir, "pom.xml");
                FileOutputStream pomFileOutputStream = new FileOutputStream(pomFileOut);
                StreamSource xmlSource = new StreamSource(xmlInputStream);
                StreamSource xslSource = new StreamSource(pomXslInputStream);
                StreamResult result = new StreamResult(pomFileOutputStream);
                Transformer transformer = TransformerFactory.newInstance().newTransformer(xslSource);
                transformer.transform(xmlSource, result);
            }
            new ArchiveManipulator().archiveDir(destArchive, new File(codegenOutputDir).getPath());
            FileManipulator.deleteDir((File)new File(codegenOutputDir));
            if (destArchive != null) {
                File file = new File(destArchive);
                FileDataSource datasource = new FileDataSource(file);
                DataHandler handler = new DataHandler((DataSource)datasource);
                CodegenDownloadData data = new CodegenDownloadData();
                data.setFileName(file.getName());
                data.setCodegenFileData(handler);
                return data;
            }
            return null;
        }
        catch (IOException e) {
            msg = WSDL2Code.class.getName() + " IOException has occured.";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        catch (XMLStreamException e) {
            msg = WSDL2Code.class.getName() + " error encountred while reading the build.xml";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        catch (JaxenException e) {
            msg = WSDL2Code.class.getName() + " xpath error has occured";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            msg = WSDL2Code.class.getName() + " transformation error has occured";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        catch (TransformerException e) {
            msg = WSDL2Code.class.getName() + " transformation error has occured";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    private String getWsdlInformation(String serviceName, AxisConfiguration axisConfig) throws AxisFault {
        String ip;
        try {
            ip = NetworkUtils.getLocalHostname();
        }
        catch (SocketException e) {
            throw new AxisFault("Cannot get local host name", (Throwable)e);
        }
        TransportInDescription http = axisConfig.getTransportIn("http");
        if (http != null) {
            EndpointReference epr = ((HttpTransportListener)http.getReceiver()).getEPRForService(serviceName, ip);
            String wsdlUrlPrefix = epr.getAddress();
            if (wsdlUrlPrefix.endsWith("/")) {
                wsdlUrlPrefix = wsdlUrlPrefix.substring(0, wsdlUrlPrefix.length() - 1);
            }
            return wsdlUrlPrefix + "?wsdl";
        }
        return null;
    }

    private String formatServiceName(String name) {
        String newName = name;
        if (newName.indexOf(47) != -1) {
            newName = newName.replace('/', '-');
        }
        return newName;
    }
}

