/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dnsserverregistration;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Stack;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dnsserverregistration.internal.ServerRegistrationComponent;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.ServerConfiguration;

public class ServerRegistration {
    private static Log log = LogFactory.getLog(ServerRegistration.class);
    private Stack<JmDNSRegistration> registrations = new Stack();

    public String getServerConfigurationProperty() {
        try {
            ServerConfiguration serverConfig = ServerRegistrationComponent.getServerConfiguration();
            return serverConfig.getFirstProperty("Name");
        }
        catch (Exception e) {
            String msg = "ServerConfiguration Service not available";
            log.error((Object)msg, (Throwable)e);
            return null;
        }
    }

    private int getTransportPort() {
        ConfigurationContextService configurationContextService = ServerRegistrationComponent.getConfigurationContextService();
        return CarbonUtils.getTransportPort((ConfigurationContextService)configurationContextService, (String)"https");
    }

    public void registerServer() {
        Logger logger = Logger.getLogger(JmDNS.class.getName());
        ConsoleHandler handler = new ConsoleHandler();
        logger.addHandler(handler);
        logger.setLevel(Level.FINER);
        handler.setLevel(Level.FINER);
        String serverName = this.getServerConfigurationProperty();
        String serviceType = "_wso2server._tcp.local.";
        int port = this.getTransportPort();
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface i = e.nextElement();
                Enumeration<InetAddress> ie = i.getInetAddresses();
                while (ie.hasMoreElements()) {
                    InetAddress addr = ie.nextElement();
                    if (addr.isAnyLocalAddress() || addr.isMulticastAddress() || addr.isLoopbackAddress() || addr instanceof Inet6Address) continue;
                    JmDNS jmdns = JmDNS.create((InetAddress)addr);
                    jmdns.requestServiceInfo(serviceType, serverName);
                    String text = jmdns.getHostName();
                    ServiceInfo info = ServiceInfo.create((String)serviceType, (String)serverName, (int)port, (String)text);
                    jmdns.registerService(info);
                    this.registrations.push(new JmDNSRegistration(info, jmdns));
                }
            }
        }
        catch (Exception e) {
            String msg = "Failed to register the server";
            log.error((Object)msg, (Throwable)e);
        }
    }

    public void unregisterServer() {
        while (!this.registrations.isEmpty()) {
            JmDNSRegistration jmDNSRegistration = this.registrations.pop();
        }
    }

    private final class JmDNSRegistration {
        private ServiceInfo info;
        private JmDNS jmdns;

        public JmDNSRegistration(ServiceInfo info, JmDNS jmdns) {
            this.info = info;
            this.jmdns = jmdns;
        }

        public ServiceInfo getInfo() {
            return this.info;
        }

        public JmDNS getJmdns() {
            return this.jmdns;
        }
    }
}

