/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dnsserverregistration.internal;

import org.apache.axis2.engine.ListenerManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.dnsserverregistration.ServerRegistration;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.ServerConfiguration;

public class ServerRegistrationComponent {
    private static Log log = LogFactory.getLog(ServerRegistrationComponent.class);
    private static ServerConfiguration serverConfiguration;
    private static RegistryService registryServiceInstance;
    private static ConfigurationContextService ccServiceInstance;
    private ServerRegistration serverRegistration = null;
    private ServiceRegistration serviceRegistration = null;

    protected void activate(ComponentContext ctxt) {
        try {
            this.serverRegistration = new ServerRegistration();
            this.serverRegistration.registerServer();
            log.info((Object)("Registered Server as: " + this.serverRegistration.getServerConfigurationProperty() + "." + "_wso2server._tcp.local."));
            this.serviceRegistration = ctxt.getBundleContext().registerService(ServerRegistration.class.getName(), (Object)this.serverRegistration, null);
        }
        catch (Throwable e) {
            log.error((Object)"Failed to register the server with jmdns. ", e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        block2: {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
            try {
                this.serverRegistration.unregisterServer();
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Exception occured while unregistering the server from jmdns", (Throwable)e);
            }
        }
        this.serverRegistration = null;
        log.debug((Object)"Server Registration bundle is deactivated ");
    }

    public static ServerConfiguration getServerConfiguration() throws Exception {
        if (serverConfiguration == null) {
            String msg = "Before activating Registration bundle, an instance of ServerConfiguration Service should be in existance";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        return serverConfiguration;
    }

    protected void setServerConfiguration(ServerConfiguration serverConfiguration) {
        ServerRegistrationComponent.serverConfiguration = serverConfiguration;
    }

    protected void unsetServerConfiguration(ServerConfiguration serverConfiguration) {
        ServerRegistrationComponent.serverConfiguration = null;
    }

    public static ConfigurationContextService getConfigurationContextService() {
        if (ccServiceInstance == null) {
            String msg = "Before activating Registration bundle, an instance of UserRealm service should be in existance";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return ccServiceInstance;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        ccServiceInstance = null;
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        ccServiceInstance = contextService;
    }

    protected void setRegistryService(RegistryService registryService) {
        registryServiceInstance = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        registryServiceInstance = null;
    }

    protected void setListenerManager(ListenerManager listenerManager) {
    }

    protected void unsetListenerManager(ListenerManager listenerManager) {
    }

    public static RegistryService getRegistryService() throws Exception {
        if (registryServiceInstance == null) {
            String msg = "Before activating Carbon UI bundle, an instance of RegistryService should be in existance";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        return registryServiceInstance;
    }
}

