/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.osgi.test.util;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.wso2.carbon.osgi.test.util.CarbonSysPropConfiguration;

public class OSGiTestConfigurationUtils {
    public static List<Option> getConfiguration() {
        return OSGiTestConfigurationUtils.getBaseOptions(System.getProperty("carbon.home"), null, null, null);
    }

    public static List<Option> getConfiguration(List<Option> customOptions, CarbonSysPropConfiguration sysPropConfiguration) {
        ArrayList<Option> optionList = new ArrayList<Option>();
        if (sysPropConfiguration != null) {
            optionList.addAll(OSGiTestConfigurationUtils.getBaseOptions(sysPropConfiguration.getCarbonHome(), sysPropConfiguration.getServerKey(), sysPropConfiguration.getServerName(), sysPropConfiguration.getServerVersion()));
        } else {
            optionList.addAll(OSGiTestConfigurationUtils.getConfiguration());
        }
        optionList.addAll(customOptions);
        return optionList;
    }

    private static List<Option> getBaseOptions(String carbonHome, String serverKey, String serverName, String serverVersion) {
        ArrayList<Option> optionList = new ArrayList<Option>();
        optionList.add((Option)CoreOptions.systemProperty((String)"carbon.home").value(carbonHome));
        optionList.add((Option)CoreOptions.systemProperty((String)"server.key").value(serverKey != null ? serverKey : "carbon-kernel"));
        optionList.add((Option)CoreOptions.systemProperty((String)"server.name").value(serverName != null ? serverName : "WSO2 Carbon Kernel"));
        optionList.add((Option)CoreOptions.systemProperty((String)"server.version").value(serverVersion != null ? serverVersion : "5.0.0"));
        optionList.add((Option)CoreOptions.systemProperty((String)"carbon.start.time").value(System.currentTimeMillis() + ""));
        if (System.getProperty("pax.exam.system", "test").equals("default")) {
            optionList.add((Option)CoreOptions.mavenBundle().artifactId("pax-exam").groupId("org.ops4j.pax.exam").versionAsInProject());
            optionList.add((Option)CoreOptions.mavenBundle().artifactId("pax-exam-inject").groupId("org.ops4j.pax.exam").versionAsInProject());
            optionList.add((Option)CoreOptions.mavenBundle().artifactId("pax-exam-extender-service").groupId("org.ops4j.pax.exam").versionAsInProject());
            optionList.add((Option)CoreOptions.mavenBundle().artifactId("org.osgi.compendium").groupId("org.osgi").versionAsInProject());
            optionList.add((Option)CoreOptions.mavenBundle().artifactId("ops4j-base").groupId("org.ops4j.base").versionAsInProject());
            optionList.add((Option)CoreOptions.mavenBundle().artifactId("pax-swissbox-core").groupId("org.ops4j.pax.swissbox").versionAsInProject());
            optionList.add((Option)CoreOptions.mavenBundle().artifactId("pax-swissbox-extender").groupId("org.ops4j.pax.swissbox").versionAsInProject());
            optionList.add((Option)CoreOptions.mavenBundle().artifactId("pax-swissbox-framework").groupId("org.ops4j.pax.swissbox").versionAsInProject());
            optionList.add((Option)CoreOptions.mavenBundle().artifactId("pax-swissbox-lifecycle").groupId("org.ops4j.pax.swissbox").versionAsInProject());
            optionList.add((Option)CoreOptions.mavenBundle().artifactId("pax-swissbox-tracker").groupId("org.ops4j.pax.swissbox").versionAsInProject());
            optionList.add((Option)CoreOptions.mavenBundle().artifactId("geronimo-atinject_1.0_spec").groupId("org.apache.geronimo.specs").versionAsInProject());
        }
        optionList.add(CoreOptions.repositories((String[])new String[]{"http://maven.wso2.org/nexus/content/groups/wso2-public"}));
        optionList.add((Option)CoreOptions.mavenBundle().artifactId("testng").groupId("org.testng").versionAsInProject());
        optionList.add((Option)CoreOptions.mavenBundle().artifactId("org.eclipse.osgi.services").groupId("org.wso2.eclipse.osgi").versionAsInProject());
        optionList.add((Option)CoreOptions.mavenBundle().artifactId("pax-logging-api").groupId("org.ops4j.pax.logging").versionAsInProject());
        optionList.add((Option)CoreOptions.mavenBundle().artifactId("pax-logging-log4j2").groupId("org.ops4j.pax.logging").versionAsInProject());
        optionList.add((Option)CoreOptions.mavenBundle().artifactId("org.eclipse.equinox.simpleconfigurator").groupId("org.wso2.eclipse.equinox").versionAsInProject());
        optionList.add((Option)CoreOptions.mavenBundle().artifactId("org.apache.felix.gogo.command").groupId("org.apache.felix").versionAsInProject());
        optionList.add((Option)CoreOptions.mavenBundle().artifactId("org.apache.felix.gogo.runtime").groupId("org.apache.felix").versionAsInProject());
        optionList.add((Option)CoreOptions.mavenBundle().artifactId("org.apache.felix.gogo.shell").groupId("org.apache.felix").versionAsInProject());
        optionList.add((Option)CoreOptions.mavenBundle().artifactId("org.eclipse.equinox.app").groupId("org.wso2.eclipse.equinox").versionAsInProject());
        optionList.add((Option)CoreOptions.mavenBundle().artifactId("org.eclipse.equinox.common").groupId("org.wso2.eclipse.equinox").versionAsInProject());
        optionList.add((Option)CoreOptions.mavenBundle().artifactId("org.eclipse.equinox.concurrent").groupId("org.wso2.eclipse.equinox").versionAsInProject());
        optionList.add((Option)CoreOptions.mavenBundle().artifactId("org.eclipse.equinox.console").groupId("org.wso2.eclipse.equinox").versionAsInProject());
        optionList.add((Option)CoreOptions.mavenBundle().artifactId("org.eclipse.equinox.ds").groupId("org.wso2.eclipse.equinox").versionAsInProject());
        optionList.add((Option)CoreOptions.mavenBundle().artifactId("org.eclipse.equinox.frameworkadmin").groupId("org.wso2.eclipse.equinox").versionAsInProject());
        optionList.add((Option)CoreOptions.mavenBundle().artifactId("org.eclipse.equinox.frameworkadmin.equinox").groupId("org.wso2.eclipse.equinox").versionAsInProject());
        optionList.add((Option)CoreOptions.mavenBundle().artifactId("org.eclipse.equinox.launcher").groupId("org.wso2.eclipse.equinox").versionAsInProject());
        optionList.add((Option)CoreOptions.mavenBundle().artifactId("org.eclipse.equinox.preferences").groupId("org.wso2.eclipse.equinox").versionAsInProject());
        optionList.add((Option)CoreOptions.mavenBundle().artifactId("org.eclipse.equinox.registry").groupId("org.wso2.eclipse.equinox").versionAsInProject());
        optionList.add((Option)CoreOptions.mavenBundle().artifactId("org.eclipse.equinox.simpleconfigurator.manipulator").groupId("org.wso2.eclipse.equinox").versionAsInProject());
        optionList.add((Option)CoreOptions.mavenBundle().artifactId("org.eclipse.equinox.util").groupId("org.wso2.eclipse.equinox").versionAsInProject());
        optionList.add((Option)CoreOptions.mavenBundle().artifactId("org.eclipse.equinox.cm").groupId("org.wso2.eclipse.equinox").versionAsInProject());
        optionList.add((Option)CoreOptions.mavenBundle().artifactId("snakeyaml").groupId("org.wso2.orbit.org.yaml").versionAsInProject());
        optionList.add((Option)CoreOptions.mavenBundle().artifactId("org.wso2.carbon.core").groupId("org.wso2.carbon").versionAsInProject());
        return optionList;
    }

    static {
        String currentDir = Paths.get("", new String[0]).toAbsolutePath().toString();
        String carbonHome = Paths.get(currentDir, "target", "carbon-home").toString();
        System.setProperty("carbon.home", carbonHome);
    }
}

